/*
 * Decompiled with CFR 0.152.
 */
package org.phenoscape.kb.ingest.xenbase;

import org.apache.commons.lang3.StringUtils;
import org.phenoscape.kb.ingest.util.Vocab$;
import org.phenoscape.scowl.converters.AnnotationValuer;
import org.phenoscape.scowl.package;
import org.phenoscape.scowl.package$;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.io.Source;

public final class XenbaseGenesToOWL$ {
    public static final XenbaseGenesToOWL$ MODULE$;
    private final OWLDataFactory factory;
    private final OWLAnnotationProperty rdfsLabel;
    private final OWLAnnotationProperty hasExactSynonym;
    private final OWLAnnotationProperty hasRelatedSynonym;

    static {
        new XenbaseGenesToOWL$();
    }

    public OWLDataFactory factory() {
        return this.factory;
    }

    public OWLAnnotationProperty rdfsLabel() {
        return this.rdfsLabel;
    }

    public OWLAnnotationProperty hasExactSynonym() {
        return this.hasExactSynonym;
    }

    public OWLAnnotationProperty hasRelatedSynonym() {
        return this.hasRelatedSynonym;
    }

    public scala.collection.immutable.Set<OWLAxiom> convert(Source markersData) {
        return markersData.getLines().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<OWLAxiom> apply(String line) {
                return XenbaseGenesToOWL$.MODULE$.translate(line);
            }
        }).toSet();
    }

    public scala.collection.immutable.Set<OWLAxiom> translate(String line) {
        String[] items = line.split("\t");
        Set axioms = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        String geneID = StringUtils.stripToNull((String)items[0]);
        String geneSymbol = StringUtils.stripToNull((String)items[1]);
        String geneFullName = StringUtils.stripToNull((String)items[2]);
        IRI geneIRI = this.getGeneIRI(geneID);
        OWLNamedIndividual gene = package$.MODULE$.Individual(geneIRI);
        axioms.add((Object)package$.MODULE$.Declaration().apply((OWLEntity)gene));
        axioms.add((Object)package.ScowlIndividual$.MODULE$.Type$extension(package$.MODULE$.ScowlIndividual((OWLIndividual)gene), (OWLClassExpression)Vocab$.MODULE$.Gene()));
        axioms.add((Object)package.ScowlAnnotationSubject$.MODULE$.Annotation$extension(package$.MODULE$.ScowlAnnotationSubject((OWLAnnotationSubject)geneIRI), this.rdfsLabel(), (Object)geneSymbol, (AnnotationValuer)package$.MODULE$.StringLiterable()));
        axioms.add((Object)package.ScowlAnnotationSubject$.MODULE$.Annotation$extension(package$.MODULE$.ScowlAnnotationSubject((OWLAnnotationSubject)geneIRI), this.hasExactSynonym(), (Object)geneFullName, (AnnotationValuer)package$.MODULE$.StringLiterable()));
        if (Predef$.MODULE$.refArrayOps((Object[])items).size() > 4) {
            String synonymsField = StringUtils.stripToEmpty((String)items[4]);
            Predef$.MODULE$.refArrayOps((Object[])synonymsField.split("\\|")).foreach((Function1)new Serializable(axioms, geneIRI){
                public static final long serialVersionUID = 0L;
                private final Set axioms$1;
                private final IRI geneIRI$1;

                public final boolean apply(String synonym) {
                    return this.axioms$1.add((Object)package.ScowlAnnotationSubject$.MODULE$.Annotation$extension(package$.MODULE$.ScowlAnnotationSubject((OWLAnnotationSubject)this.geneIRI$1), XenbaseGenesToOWL$.MODULE$.hasRelatedSynonym(), (Object)synonym, (AnnotationValuer)package$.MODULE$.StringLiterable()));
                }
                {
                    this.axioms$1 = axioms$1;
                    this.geneIRI$1 = geneIRI$1;
                }
            });
        }
        return axioms.toSet();
    }

    public IRI getGeneIRI(String geneID) {
        return IRI.create((String)new StringBuilder().append((Object)"http://xenbase.org/").append((Object)geneID).toString());
    }

    private XenbaseGenesToOWL$() {
        MODULE$ = this;
        this.factory = OWLManager.getOWLDataFactory();
        this.rdfsLabel = this.factory().getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI());
        this.hasExactSynonym = this.factory().getOWLAnnotationProperty(Vocab$.MODULE$.HAS_EXACT_SYNONYM());
        this.hasRelatedSynonym = this.factory().getOWLAnnotationProperty(Vocab$.MODULE$.HAS_RELATED_SYNONYM());
    }
}

