package org.phenoscape.kb.ingest.human

import org.apache.commons.lang3.StringUtils
import org.phenoscape.kb.ingest.util.{OBOUtil, OntUtil, Vocab}
import org.phenoscape.kb.ingest.util.Vocab._
import org.phenoscape.scowl._
import org.semanticweb.owlapi.apibinding.OWLManager
import org.semanticweb.owlapi.model.{IRI, OWLAxiom}
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary

import scala.collection.mutable
import scala.io.Source

object HumanPhenotypesToOWL {

  val factory = OWLManager.getOWLDataFactory
  val rdfsLabel = factory.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI)
  val human = factory.getOWLNamedIndividual(Vocab.HUMAN)

  def convert(phenotypeData: Source): Set[OWLAxiom] = phenotypeData.getLines.drop(1).flatMap(translate).toSet[OWLAxiom]

  def translate(phenotypeLine: String): Set[OWLAxiom] = {
    val items = phenotypeLine.split("\t")
    val axioms = mutable.Set.empty[OWLAxiom]
    val phenotype = OntUtil.nextIndividual()
    axioms.add(phenotype Type AnnotatedPhenotype)
    axioms.add(Declaration(phenotype))
    val phenotypeID = StringUtils.stripToNull(items(3))
    val phenotypeClass = Class(OBOUtil.iriForTermID(phenotypeID))
    axioms.add(phenotype Type phenotypeClass)
    val geneIRI = IRI.create("http://www.ncbi.nlm.nih.gov/gene/" + StringUtils.stripToNull(items(0)))
    val geneSymbol = StringUtils.stripToNull(items(1))
    axioms.add(geneIRI Annotation (rdfsLabel, geneSymbol))
    val gene = Individual(geneIRI)
    axioms.add(gene Type Gene)
    axioms.add(Declaration(gene))
    axioms.add(phenotype Fact (associated_with_gene, gene))
    axioms.add(phenotype Fact (associated_with_taxon, human))
    axioms.toSet
  }
}

//  object test extends App{
//    println("test");
//  }