/*
 * Decompiled with CFR 0.152.
 */
package org.phenoscape.kb.ingest.bgee;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.phenoscape.kb.ingest.util.OBOUtil$;
import org.phenoscape.kb.ingest.util.OntUtil$;
import org.phenoscape.kb.ingest.util.Vocab$;
import org.phenoscape.scowl.package;
import org.phenoscape.scowl.package$;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;

public final class BgeeExpressionToOWL$ {
    public static final BgeeExpressionToOWL$ MODULE$ = new BgeeExpressionToOWL$();

    public Source strToSource(String str) {
        return Source$.MODULE$.fromFile(str, Codec$.MODULE$.fallbackSystemCodec());
    }

    public scala.collection.immutable.Set<OWLAxiom> convert(Source expressionData) {
        return expressionData.getLines().flatMap((Function1 & Serializable)expressionLine -> MODULE$.translate((String)expressionLine)).toSet();
    }

    public scala.collection.immutable.Set<OWLAxiom> translate(String expressionLine) {
        scala.collection.immutable.Set set;
        String[] items = expressionLine.split("\t", -1);
        if (items.length == 1 || items[6].startsWith("absent") || items[6].startsWith("Expression") || items[2].startsWith("ZFA")) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            Set axioms = (Set)Set$.MODULE$.empty();
            String geneID = StringUtils.stripToNull((String)items[0]);
            String anatomicalID = StringUtils.stripToNull((String)items[2]);
            OWLNamedIndividual expression = OntUtil$.MODULE$.nextIndividual();
            axioms.add((Object)package$.MODULE$.Declaration().apply((OWLEntity)expression));
            OWLNamedIndividual structure = OntUtil$.MODULE$.nextIndividual();
            axioms.add((Object)package$.MODULE$.Declaration().apply((OWLEntity)structure));
            String term = StringUtils.stripToNull((String)items[2]);
            boolean structureValid = false;
            try {
                structureValid = term.startsWith("UBERON") || term.startsWith("CL") || term.startsWith("ZFA");
            }
            catch (NullPointerException e) {
                System.err.println(new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)e), " Empty structure in line: ")).append(expressionLine).toString());
            }
            if (structureValid) {
                OWLClass structureType = (OWLClass)package$.MODULE$.Class().apply(OBOUtil$.MODULE$.iriForTermID(term));
                axioms.add((Object)package.ScowlIndividual$.MODULE$.Type$extension(package$.MODULE$.ScowlIndividual((OWLIndividual)structure), (OWLClassExpression)structureType));
                Predef$.MODULE$.println((Object)package.ScowlIndividual$.MODULE$.Type$extension(package$.MODULE$.ScowlIndividual((OWLIndividual)structure), (OWLClassExpression)structureType));
            }
            String id = new StringBuilder(31).append("http://identifiers.org/ensembl/").append(StringUtils.stripToNull((String)items[0])).toString();
            IRI geneIRI = IRI.create((String)id);
            OWLNamedIndividual gene = package$.MODULE$.Individual(geneIRI);
            axioms.add((Object)package$.MODULE$.Declaration().apply((OWLEntity)gene));
            axioms.add((Object)package.ScowlIndividual$.MODULE$.Fact$extension(package$.MODULE$.ScowlIndividual((OWLIndividual)expression), (OWLObjectPropertyExpression)Vocab$.MODULE$.associated_with_gene(), (OWLIndividual)gene));
            axioms.add((Object)package.ScowlIndividual$.MODULE$.Fact$extension(package$.MODULE$.ScowlIndividual((OWLIndividual)expression), (OWLObjectPropertyExpression)Vocab$.MODULE$.occurs_in(), (OWLIndividual)structure));
            set = axioms.toSet();
        }
        return set;
    }

    private BgeeExpressionToOWL$() {
    }
}

