/*
 * Decompiled with CFR 0.152.
 */
package org.phenoscape.kb.ingest.util;

import org.phenoscape.kb.ingest.mgi.MGIAnatomyBridgeToEMAPA$;
import org.phenoscape.kb.ingest.util.ExpressionUtil$;
import org.phenoscape.kb.ingest.util.PostCompositionParser$;
import org.phenoscape.scowl.package;
import org.phenoscape.scowl.package$;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedObject;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;

public final class OBOUtil$ {
    public static final OBOUtil$ MODULE$ = new OBOUtil$();
    private static final OWLDataFactory factory = OWLManager.getOWLDataFactory();

    public OWLDataFactory factory() {
        return factory;
    }

    public IRI iriForTermID(String id) {
        return id.startsWith("http://") ? IRI.create((String)id) : IRI.create((String)new StringBuilder(31).append("http://purl.obolibrary.org/obo/").append(id.replaceAll(":", "_")).toString());
    }

    public IRI zfinIRI(String identifier) {
        return IRI.create((String)new StringBuilder(16).append("http://zfin.org/").append(identifier).toString());
    }

    public IRI mgiAnatomyIRI(String identifier) {
        return IRI.create((String)new StringBuilder(1).append(MGIAnatomyBridgeToEMAPA$.MODULE$.ontologyName()).append("#").append(StringOps$.MODULE$.replaceAllLiterally$extension(Predef$.MODULE$.augmentString(identifier), ":", "_")).toString());
    }

    public IRI mgiReferenceIRI(String identifier) {
        return IRI.create((String)new StringBuilder(52).append("http://www.informatics.jax.org/reference/summary?id=").append(identifier).toString());
    }

    public IRI xenbaseImageIRI(String identifier) {
        return IRI.create((String)new StringBuilder(65).append("http://www.xenbase.org/common/ViewImageActionNonAdmin.do?imageId=").append(identifier.replaceFirst(".*IMG-", "")).toString());
    }

    public IRI xenbaseArticleIRI(String identifier) {
        return IRI.create((String)new StringBuilder(70).append("http://www.xenbase.org/literature/article.do?method=display&articleId=").append(identifier.replaceFirst(".*ART-", "")).toString());
    }

    public Option<OWLAnnotationAssertionAxiom> createDefinedByAnnotation(OWLEntity term) {
        None$ none$;
        String iri = term.getIRI().toString();
        if (iri.startsWith("http://purl.obolibrary.org/obo/")) {
            String prefix = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(iri), "http://purl.obolibrary.org/obo/").split("_", -1)), 1)).mkString("_");
            String ontIRI = new StringBuilder(35).append("http://purl.obolibrary.org/obo/").append(prefix.toLowerCase()).append(".owl").toString();
            none$ = Option$.MODULE$.apply((Object)package.ScowlNamedObject$.MODULE$.Annotation$extension(package$.MODULE$.ScowlNamedObject((OWLNamedObject)term), this.factory().getRDFSIsDefinedBy(), (OWLAnnotationValue)IRI.create((String)ontIRI)));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public OWLClassExpression translatePostComposition(String id) {
        return (OWLClassExpression)PostCompositionParser$.MODULE$.parseExpression(id).get();
    }

    public Tuple2<OWLClass, Set<OWLAxiom>> translatePostCompositionNamed(String id) {
        Tuple2 tuple2;
        OWLClassExpression oWLClassExpression = this.translatePostComposition(id);
        if (oWLClassExpression instanceof OWLClass) {
            OWLClass oWLClass = (OWLClass)oWLClassExpression;
            tuple2 = new Tuple2((Object)oWLClass, (Object)Predef$.MODULE$.Set().empty());
        } else {
            tuple2 = ExpressionUtil$.MODULE$.nameForExpressionWithAxioms(oWLClassExpression);
        }
        return tuple2;
    }

    private OBOUtil$() {
    }
}

