/*
 * Decompiled with CFR 0.152.
 */
package org.phenoscape.kb.ingest.xenbase;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.phenoscape.kb.ingest.util.OBOUtil$;
import org.phenoscape.kb.ingest.util.OntUtil$;
import org.phenoscape.kb.ingest.util.Vocab$;
import org.phenoscape.kb.ingest.xenbase.XenbaseGenesToOWL$;
import org.phenoscape.scowl.converters.AnnotationValuer;
import org.phenoscape.scowl.package;
import org.phenoscape.scowl.package$;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.io.Source;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class XenbaseExpressionToOWL$ {
    public static final XenbaseExpressionToOWL$ MODULE$ = new XenbaseExpressionToOWL$();
    private static final OWLNamedIndividual laevis = package$.MODULE$.Individual(Vocab$.MODULE$.XENOPUS_LAEVIS());
    private static final OWLNamedIndividual tropicalis = package$.MODULE$.Individual(Vocab$.MODULE$.XENOPUS_TROPICALIS());

    public OWLNamedIndividual laevis() {
        return laevis;
    }

    public OWLNamedIndividual tropicalis() {
        return tropicalis;
    }

    public scala.collection.immutable.Set<OWLAxiom> convert(Source genepageMappingsFile, Source laevisExpressionFile, Source tropicalisExpressionFile) {
        Map<String, String> mappings = this.indexGenepageMappings(genepageMappingsFile);
        return (scala.collection.immutable.Set)this.convert(laevisExpressionFile, mappings, this.laevis()).$plus$plus(this.convert(tropicalisExpressionFile, mappings, this.tropicalis()));
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> indexGenepageMappings(Source mappings) {
        void var2_2;
        scala.collection.mutable.Map index = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        mappings.getLines().foreach((Function1 & Serializable)mapping -> {
            XenbaseExpressionToOWL$.$anonfun$indexGenepageMappings$1(index, mapping);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public scala.collection.immutable.Set<OWLAxiom> convert(Source expressionData, Map<String, String> genepageMappings, OWLNamedIndividual species) {
        return (scala.collection.immutable.Set)expressionData.getLines().flatMap((Function1 & Serializable)x$3 -> MODULE$.translate((String)x$3, genepageMappings, species)).toSet().$plus((Object)package.ScowlNamedObject$.MODULE$.Annotation$extension(package$.MODULE$.ScowlNamedObject((OWLNamedObject)this.laevis()), Vocab$.MODULE$.rdfsLabel(), (Object)"Xenopus laevis", (AnnotationValuer)package$.MODULE$.StringLiterable())).$plus((Object)package.ScowlNamedObject$.MODULE$.Annotation$extension(package$.MODULE$.ScowlNamedObject((OWLNamedObject)this.tropicalis()), Vocab$.MODULE$.rdfsLabel(), (Object)"Xenopus tropicalis", (AnnotationValuer)package$.MODULE$.StringLiterable()));
    }

    public scala.collection.immutable.Set<OWLAxiom> translate(String expressionLine, Map<String, String> genepageMappings, OWLNamedIndividual species) {
        scala.collection.immutable.Set set;
        String[] items = expressionLine.split("\t");
        String string = StringUtils.stripToEmpty((String)items[3]);
        String string2 = "unspecified";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            set = Predef$.MODULE$.Set().empty();
        } else {
            Object object;
            Set axioms = (Set)Set$.MODULE$.empty();
            OWLNamedIndividual expression = OntUtil$.MODULE$.nextIndividual();
            axioms.add((Object)package$.MODULE$.Declaration().apply((OWLEntity)expression));
            axioms.add((Object)package.ScowlIndividual$.MODULE$.Type$extension(package$.MODULE$.ScowlIndividual((OWLIndividual)expression), (OWLClassExpression)Vocab$.MODULE$.GeneExpression()));
            String[] structureItems = items[3].split(",", -1);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])structureItems), (Function1 & Serializable)structureItem -> BoxesRunTime.boxToBoolean((boolean)XenbaseExpressionToOWL$.$anonfun$translate$1(axioms, expression, structureItem)));
            String evidenceText = StringUtils.stripToEmpty((String)items[7]);
            if (evidenceText.contains("XB-IMG")) {
                OWLNamedIndividual image = package$.MODULE$.Individual(OBOUtil$.MODULE$.xenbaseImageIRI(evidenceText));
                object = BoxesRunTime.boxToBoolean((boolean)axioms.add((Object)package.ScowlIndividual$.MODULE$.Fact$extension(package$.MODULE$.ScowlIndividual((OWLIndividual)expression), (OWLObjectPropertyExpression)Vocab$.MODULE$.dcSource(), (OWLIndividual)image)));
            } else {
                object = BoxedUnit.UNIT;
            }
            String genepageID = (String)genepageMappings.apply((Object)StringUtils.stripToNull((String)items[0]));
            IRI geneIRI = XenbaseGenesToOWL$.MODULE$.getGeneIRI(genepageID);
            OWLNamedIndividual gene = package$.MODULE$.Individual(geneIRI);
            axioms.add((Object)package$.MODULE$.Declaration().apply((OWLEntity)gene));
            axioms.add((Object)package.ScowlIndividual$.MODULE$.Fact$extension(package$.MODULE$.ScowlIndividual((OWLIndividual)expression), (OWLObjectPropertyExpression)Vocab$.MODULE$.associated_with_gene(), (OWLIndividual)gene));
            axioms.add((Object)package.ScowlIndividual$.MODULE$.Fact$extension(package$.MODULE$.ScowlIndividual((OWLIndividual)expression), (OWLObjectPropertyExpression)Vocab$.MODULE$.associated_with_taxon(), (OWLIndividual)species));
            set = axioms.toSet();
        }
        return set;
    }

    public static final /* synthetic */ void $anonfun$indexGenepageMappings$1(scala.collection.mutable.Map index$1, String mapping) {
        String[] items = mapping.split("\t", -1);
        String genepageID = StringUtils.stripToNull((String)items[0]);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.drop$extension(Predef$.MODULE$.refArrayOps((Object[])items), 1)), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("XB-GENE")))), (Function1 & Serializable)x$2 -> x$2.trim(), ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)geneID -> {
            index$1.update((Object)StringUtils.stripToNull((String)geneID), (Object)genepageID);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$translate$1(Set axioms$1, OWLNamedIndividual expression$1, String structureItem) {
        String structureID = StringUtils.stripToNull((String)structureItem.trim().split(" ")[0]);
        OWLClass structureType = (OWLClass)package$.MODULE$.Class().apply(OBOUtil$.MODULE$.iriForTermID(structureID));
        OWLNamedIndividual punnedStructure = package$.MODULE$.Individual(structureType.getIRI());
        axioms$1.add((Object)package$.MODULE$.Declaration().apply((OWLEntity)punnedStructure));
        return axioms$1.add((Object)package.ScowlIndividual$.MODULE$.Fact$extension(package$.MODULE$.ScowlIndividual((OWLIndividual)expression$1), (OWLObjectPropertyExpression)Vocab$.MODULE$.occurs_in(), (OWLIndividual)punnedStructure));
    }

    private XenbaseExpressionToOWL$() {
    }
}

