/*
 * Decompiled with CFR 0.152.
 */
package org.phenoscape.kb.ingest.xenbase;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.phenoscape.kb.ingest.util.Vocab$;
import org.phenoscape.scowl.converters.AnnotationValuer;
import org.phenoscape.scowl.package;
import org.phenoscape.scowl.package$;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.io.Source;
import scala.runtime.BoxesRunTime;

public final class XenbaseGenesToOWL$ {
    public static final XenbaseGenesToOWL$ MODULE$ = new XenbaseGenesToOWL$();
    private static final OWLDataFactory factory = OWLManager.getOWLDataFactory();
    private static final OWLAnnotationProperty rdfsLabel = MODULE$.factory().getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI());
    private static final OWLAnnotationProperty hasExactSynonym = MODULE$.factory().getOWLAnnotationProperty(Vocab$.MODULE$.HAS_EXACT_SYNONYM());
    private static final OWLAnnotationProperty hasRelatedSynonym = MODULE$.factory().getOWLAnnotationProperty(Vocab$.MODULE$.HAS_RELATED_SYNONYM());

    public OWLDataFactory factory() {
        return factory;
    }

    public OWLAnnotationProperty rdfsLabel() {
        return rdfsLabel;
    }

    public OWLAnnotationProperty hasExactSynonym() {
        return hasExactSynonym;
    }

    public OWLAnnotationProperty hasRelatedSynonym() {
        return hasRelatedSynonym;
    }

    public scala.collection.immutable.Set<OWLAxiom> convert(Source markersData) {
        return markersData.getLines().flatMap((Function1 & Serializable)line -> MODULE$.translate((String)line)).toSet();
    }

    public scala.collection.immutable.Set<OWLAxiom> translate(String line) {
        Set axioms;
        block0: {
            String[] items = line.split("\t");
            axioms = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            String geneID = StringUtils.stripToNull((String)items[0]);
            String geneSymbol = StringUtils.stripToNull((String)items[1]);
            String geneFullName = StringUtils.stripToNull((String)items[2]);
            IRI geneIRI = this.getGeneIRI(geneID);
            OWLNamedIndividual gene = package$.MODULE$.Individual(geneIRI);
            axioms.add((Object)package$.MODULE$.Declaration().apply((OWLEntity)gene));
            axioms.add((Object)package.ScowlIndividual$.MODULE$.Type$extension(package$.MODULE$.ScowlIndividual((OWLIndividual)gene), (OWLClassExpression)Vocab$.MODULE$.Gene()));
            axioms.add((Object)package.ScowlAnnotationSubject$.MODULE$.Annotation$extension(package$.MODULE$.ScowlAnnotationSubject((OWLAnnotationSubject)geneIRI), this.rdfsLabel(), (Object)geneSymbol, (AnnotationValuer)package$.MODULE$.StringLiterable()));
            axioms.add((Object)package.ScowlAnnotationSubject$.MODULE$.Annotation$extension(package$.MODULE$.ScowlAnnotationSubject((OWLAnnotationSubject)geneIRI), this.hasExactSynonym(), (Object)geneFullName, (AnnotationValuer)package$.MODULE$.StringLiterable()));
            if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])items)) <= 4) break block0;
            String synonymsField = StringUtils.stripToEmpty((String)items[4]);
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])synonymsField.split("\\|")), (Function1 & Serializable)synonym -> BoxesRunTime.boxToBoolean((boolean)axioms.add((Object)package.ScowlAnnotationSubject$.MODULE$.Annotation$extension(package$.MODULE$.ScowlAnnotationSubject((OWLAnnotationSubject)geneIRI), XenbaseGenesToOWL$.MODULE$.hasRelatedSynonym(), (Object)synonym, (AnnotationValuer)package$.MODULE$.StringLiterable()))));
        }
        return axioms.toSet();
    }

    public IRI getGeneIRI(String geneID) {
        return IRI.create((String)new StringBuilder(19).append("http://xenbase.org/").append(geneID).toString());
    }

    private XenbaseGenesToOWL$() {
    }
}

