/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.hash.MurmurHash3;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Containers {
    public static final int NB_OF_PROCESSORS = Runtime.getRuntime().availableProcessors();
    public static final int DEFAULT_EXPECTED_ELEMENTS = 8;
    private static volatile String testsSeedProperty;
    private static final String NOT_AVAILABLE = "";

    private Containers() {
    }

    public static long randomSeed64() {
        if (testsSeedProperty == null) {
            try {
                testsSeedProperty = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("tests.seed", Containers.NOT_AVAILABLE);
                    }
                });
            }
            catch (SecurityException e) {
                testsSeedProperty = NOT_AVAILABLE;
                Logger.getLogger(Containers.class.getName()).log(Level.INFO, "Failed to read 'tests.seed' property for initial random seed.", e);
            }
        }
        long initialSeed = !testsSeedProperty.equals(NOT_AVAILABLE) ? (long)testsSeedProperty.hashCode() : System.nanoTime() ^ (long)System.identityHashCode(new Object());
        return MurmurHash3.mix64(initialSeed);
    }

    public static int randomSeed32() {
        long longId = Containers.randomSeed64();
        return (int)(longId >>> 32 ^ longId);
    }

    public static void forceReloadTestProperty() {
        testsSeedProperty = null;
    }
}

