/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.lists;

import com.carrotsearch.hppcrt.AbstractFloatCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.FloatContainer;
import com.carrotsearch.hppcrt.FloatDeque;
import com.carrotsearch.hppcrt.FloatIndexedContainer;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.FloatCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.FloatPredicate;
import com.carrotsearch.hppcrt.procedures.FloatProcedure;
import com.carrotsearch.hppcrt.sorting.FloatSort;
import com.carrotsearch.hppcrt.strategies.FloatComparator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatLinkedList
extends AbstractFloatCollection
implements FloatIndexedContainer,
FloatDeque,
Cloneable {
    public float[] buffer;
    protected long[] beforeAfterPointers;
    protected static final int HEAD_POSITION = 0;
    protected static final int TAIL_POSITION = 1;
    protected int elementsCount = 2;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<FloatCursor, ValueIterator> valueIteratorPool;
    protected final IteratorPool<FloatCursor, DescendingValueIterator> descendingValueIteratorPool;

    public FloatLinkedList() {
        this(8);
    }

    public FloatLinkedList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public FloatLinkedList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.elementsCount = 2;
        this.beforeAfterPointers[0] = 1L;
        this.beforeAfterPointers[1] = 1L;
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = -1;
                obj.buffer = FloatLinkedList.this.buffer;
                obj.pointers = FloatLinkedList.this.beforeAfterPointers;
                obj.internalPos = 0;
            }

            @Override
            public void reset(ValueIterator obj) {
                obj.buffer = null;
                obj.pointers = null;
            }
        });
        this.descendingValueIteratorPool = new IteratorPool(new ObjectFactory<DescendingValueIterator>(){

            @Override
            public DescendingValueIterator create() {
                return new DescendingValueIterator();
            }

            @Override
            public void initialize(DescendingValueIterator obj) {
                obj.cursor.index = FloatLinkedList.this.size();
                obj.buffer = FloatLinkedList.this.buffer;
                obj.pointers = FloatLinkedList.this.beforeAfterPointers;
                obj.internalPos = 1;
            }

            @Override
            public void reset(DescendingValueIterator obj) {
                obj.buffer = null;
                obj.pointers = null;
            }
        });
    }

    public FloatLinkedList(FloatContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(float e1) {
        this.addLast(e1);
    }

    public void add(float e1, float e2) {
        this.ensureBufferSpace(2);
        this.insertAfterPosNoCheck(e1, (int)(this.beforeAfterPointers[1] >> 32));
        this.insertAfterPosNoCheck(e2, (int)(this.beforeAfterPointers[1] >> 32));
    }

    public void addLast(float ... elements) {
        this.addLast(elements, 0, elements.length);
    }

    public void addLast(float[] elements, int start, int length) {
        assert (length + start <= elements.length) : "Length is smaller than required";
        this.ensureBufferSpace(length);
        long[] beforeAfterPointers = this.beforeAfterPointers;
        for (int i = 0; i < length; ++i) {
            this.insertAfterPosNoCheck(elements[start + i], (int)(beforeAfterPointers[1] >> 32));
        }
    }

    public void add(float[] elements, int start, int length) {
        this.addLast(elements, start, length);
    }

    public void add(float ... elements) {
        this.addLast(elements, 0, elements.length);
    }

    public int addAll(FloatContainer container) {
        return this.addLast(container);
    }

    public int addAll(Iterable<? extends FloatCursor> iterable) {
        return this.addLast(iterable);
    }

    @Override
    public void insert(int index, float e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        if (index == 0) {
            this.insertAfterPosNoCheck(e1, 0);
        } else {
            this.insertAfterPosNoCheck(e1, this.gotoIndex(index - 1));
        }
    }

    @Override
    public float get(int index) {
        return this.buffer[this.gotoIndex(index)];
    }

    @Override
    public float set(int index, float e1) {
        int pos = this.gotoIndex(index);
        float elem = this.buffer[pos];
        this.buffer[pos] = e1;
        return elem;
    }

    @Override
    public float remove(int index) {
        int currentPos = this.gotoIndex(index);
        float elem = this.buffer[currentPos];
        this.removeAtPosNoCheck(currentPos);
        return elem;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int currentPos = this.gotoIndex(fromIndex);
        int size = toIndex - fromIndex;
        for (int count = 0; count < size; ++count) {
            currentPos = this.removeAtPosNoCheck(currentPos);
        }
    }

    @Override
    public int removeFirst(float e1) {
        long[] pointers = this.beforeAfterPointers;
        float[] buffer = this.buffer;
        int currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
        int count = 0;
        while (currentPos != 1) {
            if (Float.floatToIntBits(e1) == Float.floatToIntBits(buffer[currentPos])) {
                this.removeAtPosNoCheck(currentPos);
                return count;
            }
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
            ++count;
        }
        return -1;
    }

    @Override
    public int removeLast(float e1) {
        long[] pointers = this.beforeAfterPointers;
        float[] buffer = this.buffer;
        int size = this.size();
        int currentPos = (int)(pointers[1] >> 32);
        int count = 0;
        while (currentPos != 0) {
            if (Float.floatToIntBits(e1) == Float.floatToIntBits(buffer[currentPos])) {
                this.removeAtPosNoCheck(currentPos);
                return size - count - 1;
            }
            currentPos = (int)(pointers[currentPos] >> 32);
            ++count;
        }
        return -1;
    }

    @Override
    public int removeAll(float e1) {
        float[] buffer = this.buffer;
        int deleted = 0;
        int pos = 2;
        while (pos < this.elementsCount) {
            if (Float.floatToIntBits(e1) == Float.floatToIntBits(buffer[pos])) {
                this.removeAtPosNoCheck(pos);
                ++deleted;
                continue;
            }
            ++pos;
        }
        return deleted;
    }

    @Override
    public boolean contains(float e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(float e1) {
        long[] pointers = this.beforeAfterPointers;
        float[] buffer = this.buffer;
        int currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
        int count = 0;
        while (currentPos != 1) {
            if (Float.floatToIntBits(e1) == Float.floatToIntBits(buffer[currentPos])) {
                return count;
            }
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
            ++count;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(float e1) {
        long[] pointers = this.beforeAfterPointers;
        float[] buffer = this.buffer;
        int currentPos = (int)(pointers[1] >> 32);
        int count = 0;
        while (currentPos != 0) {
            if (Float.floatToIntBits(e1) == Float.floatToIntBits(buffer[currentPos])) {
                return this.size() - count - 1;
            }
            currentPos = (int)(pointers[currentPos] >> 32);
            ++count;
        }
        return -1;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected boolean ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            if (this.buffer == null) {
                newSize += 2;
            }
            try {
                float[] newBuffer = new float[newSize];
                long[] newPointers = new long[newSize];
                if (bufferLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                    System.arraycopy(this.beforeAfterPointers, 0, newPointers, 0, this.beforeAfterPointers.length);
                }
                this.buffer = newBuffer;
                this.beforeAfterPointers = newPointers;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elementsCount - 2;
    }

    @Override
    public int capacity() {
        return this.buffer.length - 2;
    }

    @Override
    public void clear() {
        this.elementsCount = 2;
        this.beforeAfterPointers[0] = 1L;
        this.beforeAfterPointers[1] = 1L;
    }

    @Override
    public float[] toArray(float[] target) {
        long[] pointers = this.beforeAfterPointers;
        float[] buffer = this.buffer;
        int index = 0;
        int currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
        while (currentPos != 1) {
            target[index] = buffer[currentPos];
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
            ++index;
        }
        return target;
    }

    public FloatLinkedList clone() {
        FloatLinkedList cloned = new FloatLinkedList(8, this.resizer);
        cloned.buffer = (float[])this.buffer.clone();
        cloned.beforeAfterPointers = (long[])this.beforeAfterPointers.clone();
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public int hashCode() {
        long[] pointers = this.beforeAfterPointers;
        float[] buffer = this.buffer;
        int h2 = 1;
        int currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
        while (currentPos != 1) {
            h2 = 31 * h2 + BitMixer.mix(buffer[currentPos]);
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FloatDeque) && !(obj instanceof FloatIndexedContainer)) {
                return false;
            }
            FloatContainer other = (FloatContainer)obj;
            if (other.size() != this.size()) {
                return false;
            }
            ValueIterator it = this.iterator();
            AbstractIterator itOther = (AbstractIterator)other.iterator();
            while (it.hasNext()) {
                float myVal = ((FloatCursor)it.next()).value;
                float otherVal = ((FloatCursor)itOther.next()).value;
                if (Float.floatToIntBits(myVal) == Float.floatToIntBits(otherVal)) continue;
                it.release();
                itOther.release();
                return false;
            }
            itOther.release();
            return true;
        }
        return false;
    }

    protected int gotoIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds [" + 0 + ", size=" + this.size() + "[.");
        }
        int currentPos = 1;
        int currentIndex = -1;
        long[] pointers = this.beforeAfterPointers;
        if ((double)index <= (double)this.elementsCount / 2.0) {
            currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
            for (currentIndex = 0; currentIndex < index && currentPos != 1; ++currentIndex) {
                currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
            }
        } else {
            currentPos = (int)(pointers[1] >> 32);
            for (currentIndex = this.size() - 1; currentIndex > index && currentPos != 0; --currentIndex) {
                currentPos = (int)(pointers[currentPos] >> 32);
            }
        }
        assert (currentIndex == index);
        return currentPos;
    }

    private void insertAfterPosNoCheck(float e1, int insertionPos) {
        long[] pointers = this.beforeAfterPointers;
        int nextAfterInsertionPos = (int)(pointers[insertionPos] & 0xFFFFFFFFL);
        pointers[this.elementsCount] = (long)insertionPos << 32 | (long)nextAfterInsertionPos;
        pointers[insertionPos] = (long)this.elementsCount | pointers[insertionPos] & 0xFFFFFFFF00000000L;
        pointers[nextAfterInsertionPos] = (long)this.elementsCount << 32 | pointers[nextAfterInsertionPos] & 0xFFFFFFFFL;
        this.buffer[this.elementsCount] = e1;
        ++this.elementsCount;
    }

    private int removeAtPosNoCheck(int removalPos) {
        long[] pointers = this.beforeAfterPointers;
        int beforeRemovalPos = (int)(pointers[removalPos] >> 32);
        int afterRemovalPos = (int)(pointers[removalPos] & 0xFFFFFFFFL);
        pointers[beforeRemovalPos] = (long)afterRemovalPos | pointers[beforeRemovalPos] & 0xFFFFFFFF00000000L;
        pointers[afterRemovalPos] = (long)beforeRemovalPos << 32 | pointers[afterRemovalPos] & 0xFFFFFFFFL;
        if (removalPos != this.elementsCount - 1) {
            int beforeLastElementPos = (int)(pointers[this.elementsCount - 1] >> 32);
            int afterLastElementPos = (int)(pointers[this.elementsCount - 1] & 0xFFFFFFFFL);
            this.buffer[removalPos] = this.buffer[this.elementsCount - 1];
            pointers[removalPos] = pointers[this.elementsCount - 1];
            pointers[beforeLastElementPos] = (long)removalPos | pointers[beforeLastElementPos] & 0xFFFFFFFF00000000L;
            pointers[afterLastElementPos] = (long)removalPos << 32 | pointers[afterLastElementPos] & 0xFFFFFFFFL;
        }
        --this.elementsCount;
        return (int)(pointers[beforeRemovalPos] & 0xFFFFFFFFL);
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    public DescendingValueIterator descendingIterator() {
        return (DescendingValueIterator)this.descendingValueIteratorPool.borrow();
    }

    @Override
    public <T extends FloatProcedure> T forEach(T procedure) {
        this.forEach(procedure, 0, this.size());
        return procedure;
    }

    @Override
    public <T extends FloatProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        this.internalForEach(procedure, fromIndex, toIndex);
        return procedure;
    }

    private void internalForEach(FloatProcedure procedure, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int currentPos = this.gotoIndex(fromIndex);
        long[] pointers = this.beforeAfterPointers;
        float[] buffer = this.buffer;
        int size = toIndex - fromIndex;
        for (int count = 0; count < size; ++count) {
            procedure.apply(buffer[currentPos]);
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
        }
    }

    @Override
    public <T extends FloatPredicate> T forEach(T predicate) {
        this.forEach(predicate, 0, this.size());
        return predicate;
    }

    @Override
    public <T extends FloatPredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        this.internalForEach(predicate, fromIndex, toIndex);
        return predicate;
    }

    private void internalForEach(FloatPredicate predicate, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int currentPos = this.gotoIndex(fromIndex);
        long[] pointers = this.beforeAfterPointers;
        float[] buffer = this.buffer;
        int size = toIndex - fromIndex;
        for (int count = 0; count < size && predicate.apply(buffer[currentPos]); ++count) {
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
        }
    }

    @Override
    public <T extends FloatProcedure> T descendingForEach(T procedure) {
        long[] pointers = this.beforeAfterPointers;
        float[] buffer = this.buffer;
        int currentPos = (int)(pointers[1] >> 32);
        while (currentPos != 0) {
            procedure.apply(buffer[currentPos]);
            currentPos = (int)(pointers[currentPos] >> 32);
        }
        return procedure;
    }

    @Override
    public <T extends FloatPredicate> T descendingForEach(T predicate) {
        long[] pointers = this.beforeAfterPointers;
        float[] buffer = this.buffer;
        int currentPos = (int)(pointers[1] >> 32);
        while (currentPos != 0 && predicate.apply(buffer[currentPos])) {
            currentPos = (int)(pointers[currentPos] >> 32);
        }
        return predicate;
    }

    @Override
    public int removeAll(FloatPredicate predicate) {
        float[] buffer = this.buffer;
        int deleted = 0;
        int pos = 2;
        while (pos < this.elementsCount) {
            if (predicate.apply(buffer[pos])) {
                this.removeAtPosNoCheck(pos);
                ++deleted;
                continue;
            }
            ++pos;
        }
        return deleted;
    }

    public static FloatLinkedList newInstance() {
        return new FloatLinkedList();
    }

    public static FloatLinkedList newInstance(int initialCapacity) {
        return new FloatLinkedList(initialCapacity);
    }

    public static FloatLinkedList from(float ... elements) {
        FloatLinkedList list = new FloatLinkedList(elements.length);
        list.add(elements);
        return list;
    }

    public static FloatLinkedList from(FloatContainer container) {
        return new FloatLinkedList(container);
    }

    public void sort(int beginIndex, int endIndex) {
        FloatSort.quicksort(this, beginIndex, endIndex);
    }

    public void sort(int beginIndex, int endIndex, FloatComparator comp) {
        FloatSort.quicksort(this, beginIndex, endIndex, comp);
    }

    public void sort() {
        if (this.elementsCount > 3) {
            int elementsCount = this.elementsCount;
            long[] pointers = this.beforeAfterPointers;
            FloatSort.quicksort(this.buffer, 2, elementsCount);
            pointers[0] = 2L;
            pointers[2] = 3L;
            for (int pos = 3; pos < elementsCount - 1; ++pos) {
                pointers[pos] = (long)(pos - 1) << 32 | (long)(pos + 1);
            }
            pointers[elementsCount - 1] = (long)(elementsCount - 2) << 32 | 1L;
            pointers[1] = (long)(elementsCount - 1) << 32 | 1L;
        }
    }

    public void sort(FloatComparator comp) {
        if (this.elementsCount > 3) {
            int elementsCount = this.elementsCount;
            long[] pointers = this.beforeAfterPointers;
            FloatSort.quicksort(this.buffer, 2, elementsCount, comp);
            pointers[0] = 2L;
            pointers[2] = 3L;
            for (int pos = 3; pos < elementsCount - 1; ++pos) {
                pointers[pos] = (long)(pos - 1) << 32 | (long)(pos + 1);
            }
            pointers[elementsCount - 1] = (long)(elementsCount - 2) << 32 | 1L;
            pointers[1] = (long)(elementsCount - 1) << 32 | 1L;
        }
    }

    @Override
    public void addFirst(float e1) {
        this.ensureBufferSpace(1);
        this.insertAfterPosNoCheck(e1, 0);
    }

    public int addFirst(FloatContainer container) {
        return this.addFirst((Iterable<? extends FloatCursor>)container);
    }

    public void addFirst(float ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.insertAfterPosNoCheck(elements[i], 0);
        }
    }

    public int addFirst(Iterable<? extends FloatCursor> iterable) {
        int size = 0;
        for (FloatCursor floatCursor : iterable) {
            this.ensureBufferSpace(1);
            this.insertAfterPosNoCheck(floatCursor.value, 0);
            ++size;
        }
        return size;
    }

    @Override
    public void addLast(float e1) {
        this.ensureBufferSpace(1);
        this.insertAfterPosNoCheck(e1, (int)(this.beforeAfterPointers[1] >> 32));
    }

    public int addLast(FloatContainer container) {
        return this.addLast((Iterable<? extends FloatCursor>)container);
    }

    public int addLast(Iterable<? extends FloatCursor> iterable) {
        int size = 0;
        for (FloatCursor floatCursor : iterable) {
            this.ensureBufferSpace(1);
            this.insertAfterPosNoCheck(floatCursor.value, (int)(this.beforeAfterPointers[1] >> 32));
            ++size;
        }
        return size;
    }

    @Override
    public float removeFirst() {
        assert (this.size() > 0);
        int removedPos = (int)(this.beforeAfterPointers[0] & 0xFFFFFFFFL);
        float elem = this.buffer[removedPos];
        this.removeAtPosNoCheck(removedPos);
        return elem;
    }

    @Override
    public float removeLast() {
        assert (this.size() > 0);
        int removedPos = (int)(this.beforeAfterPointers[1] >> 32);
        float elem = this.buffer[removedPos];
        this.removeAtPosNoCheck(removedPos);
        return elem;
    }

    @Override
    public float getFirst() {
        assert (this.size() > 0);
        return this.buffer[(int)(this.beforeAfterPointers[0] & 0xFFFFFFFFL)];
    }

    @Override
    public float getLast() {
        assert (this.size() > 0);
        return this.buffer[(int)(this.beforeAfterPointers[1] >> 32)];
    }

    private void checkRangeBounds(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("Index beginIndex " + beginIndex + " is > endIndex " + endIndex);
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Index beginIndex < 0");
        }
        if (endIndex > this.size()) {
            throw new IndexOutOfBoundsException("Index endIndex " + endIndex + " out of bounds [" + 0 + ", " + this.size() + "].");
        }
    }

    public final class DescendingValueIterator
    extends ValueIterator {
        public DescendingValueIterator() {
            this.cursor.index = FloatLinkedList.this.size();
            this.buffer = FloatLinkedList.this.buffer;
            this.pointers = FloatLinkedList.this.beforeAfterPointers;
            this.internalPos = 1;
        }

        protected FloatCursor fetch() {
            int previousPos;
            if (this.cursor.index == 0) {
                return (FloatCursor)this.done();
            }
            this.internalPos = previousPos = (int)(this.pointers[this.internalPos] >> 32);
            --this.cursor.index;
            this.cursor.value = this.buffer[previousPos];
            return this.cursor;
        }

        public boolean hasAfter() {
            return super.hasBefore();
        }

        public boolean hasBefore() {
            return super.hasAfter();
        }

        public ValueIterator gotoHead() {
            return super.gotoTail();
        }

        public DescendingValueIterator gotoTail() {
            return (DescendingValueIterator)super.gotoHead();
        }

        public DescendingValueIterator gotoNext() {
            return (DescendingValueIterator)super.gotoPrevious();
        }

        public DescendingValueIterator gotoPrevious() {
            return (DescendingValueIterator)super.gotoNext();
        }

        public float getNext() {
            return super.getPrevious();
        }

        public float getPrevious() {
            return super.getNext();
        }

        public float removeNext() {
            return super.removePrevious();
        }

        public float removePrevious() {
            return super.removeNext();
        }

        public void insertBefore(float e1) {
            super.insertAfter(e1);
        }

        public void insertAfter(float e1) {
            super.insertBefore(e1);
        }

        public DescendingValueIterator delete() {
            if (this.internalPos == 0 || this.internalPos == 1) {
                throw new IndexOutOfBoundsException("Cannot delete while pointing at head or tail");
            }
            int nextPos = FloatLinkedList.this.removeAtPosNoCheck(this.internalPos);
            this.internalPos = (int)(this.pointers[nextPos] >> 32);
            this.cursor.value = this.buffer[this.internalPos];
            --this.cursor.index;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ValueIterator
    extends AbstractIterator<FloatCursor> {
        public final FloatCursor cursor = new FloatCursor();
        float[] buffer;
        int internalPos;
        long[] pointers;

        public ValueIterator() {
            this.cursor.index = -1;
            this.buffer = FloatLinkedList.this.buffer;
            this.pointers = FloatLinkedList.this.beforeAfterPointers;
            this.internalPos = 0;
        }

        @Override
        protected FloatCursor fetch() {
            int nextPos;
            if (this.cursor.index + 1 == FloatLinkedList.this.size()) {
                return (FloatCursor)this.done();
            }
            this.internalPos = nextPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            ++this.cursor.index;
            this.cursor.value = this.buffer[nextPos];
            return this.cursor;
        }

        public boolean hasAfter() {
            int nextPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            return nextPos != 1;
        }

        public boolean hasBefore() {
            int beforePos = (int)(this.pointers[this.internalPos] >> 32);
            return beforePos != 0;
        }

        public ValueIterator gotoHead() {
            this.internalPos = 0;
            this.cursor.index = -1;
            return this;
        }

        public ValueIterator gotoTail() {
            this.internalPos = 1;
            this.cursor.index = FloatLinkedList.this.size();
            return this;
        }

        public ValueIterator gotoNext() {
            this.internalPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            if (this.internalPos == 1) {
                this.cursor.index = FloatLinkedList.this.size();
            } else {
                ++this.cursor.index;
                this.cursor.value = this.buffer[this.internalPos];
            }
            return this;
        }

        public ValueIterator gotoPrevious() {
            this.internalPos = (int)(this.pointers[this.internalPos] >> 32);
            if (this.internalPos == 0) {
                this.cursor.index = -1;
            } else {
                --this.cursor.index;
                this.cursor.value = this.buffer[this.internalPos];
            }
            return this;
        }

        public float getNext() {
            int nextPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            if (nextPos == 1) {
                throw new NoSuchElementException("Either no next element (forward iterator) or previous element (backward iterator)");
            }
            return this.buffer[nextPos];
        }

        public float getPrevious() {
            int beforePos = (int)(this.pointers[this.internalPos] >> 32);
            if (beforePos == 0) {
                throw new NoSuchElementException("Either no previous element (forward iterator) or next element (backward iterator)");
            }
            return this.buffer[beforePos];
        }

        public float removeNext() {
            int nextPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            if (nextPos == 1) {
                throw new NoSuchElementException("Either no next element to remove (forward iterator) or previous element to remove (backward iterator)");
            }
            float value = this.buffer[nextPos];
            FloatLinkedList.this.removeAtPosNoCheck(nextPos);
            return value;
        }

        public float removePrevious() {
            int previousPos = (int)(this.pointers[this.internalPos] >> 32);
            if (previousPos == 0) {
                throw new NoSuchElementException("Either no previous element to remove (forward iterator) or next element to remove (backward iterator)");
            }
            float value = this.buffer[previousPos];
            this.internalPos = FloatLinkedList.this.removeAtPosNoCheck(previousPos);
            --this.cursor.index;
            return value;
        }

        public void insertBefore(float e1) {
            if (this.internalPos == 0) {
                throw new IndexOutOfBoundsException("Either cannot insert before (forward iterator) or insert after (backward iterator)");
            }
            if (FloatLinkedList.this.ensureBufferSpace(1)) {
                this.pointers = FloatLinkedList.this.beforeAfterPointers;
                this.buffer = FloatLinkedList.this.buffer;
            }
            int beforePos = (int)(this.pointers[this.internalPos] >> 32);
            FloatLinkedList.this.insertAfterPosNoCheck(e1, beforePos);
            ++this.cursor.index;
        }

        public void insertAfter(float e1) {
            if (this.internalPos == 1) {
                throw new IndexOutOfBoundsException("Either cannot insert after (forward iterator) or insert before (backward iterator)");
            }
            if (FloatLinkedList.this.ensureBufferSpace(1)) {
                this.pointers = FloatLinkedList.this.beforeAfterPointers;
                this.buffer = FloatLinkedList.this.buffer;
            }
            FloatLinkedList.this.insertAfterPosNoCheck(e1, this.internalPos);
        }

        public void set(float e1) {
            if (this.internalPos == 0 || this.internalPos == 1) {
                throw new IndexOutOfBoundsException("Cannot set while pointing at head or tail");
            }
            this.buffer[this.internalPos] = e1;
            this.cursor.value = e1;
        }

        public ValueIterator delete() {
            if (this.internalPos == 0 || this.internalPos == 1) {
                throw new IndexOutOfBoundsException("Cannot delete while pointing at head or tail");
            }
            this.internalPos = FloatLinkedList.this.removeAtPosNoCheck(this.internalPos);
            this.cursor.value = this.buffer[this.internalPos];
            return this;
        }
    }
}

