/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractDoubleCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.DoubleArrays;
import com.carrotsearch.hppcrt.DoubleContainer;
import com.carrotsearch.hppcrt.DoubleDoubleAssociativeContainer;
import com.carrotsearch.hppcrt.DoubleDoubleMap;
import com.carrotsearch.hppcrt.DoubleLookupContainer;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.DoubleCursor;
import com.carrotsearch.hppcrt.cursors.DoubleDoubleCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.DoubleDoublePredicate;
import com.carrotsearch.hppcrt.predicates.DoublePredicate;
import com.carrotsearch.hppcrt.procedures.DoubleDoubleProcedure;
import com.carrotsearch.hppcrt.procedures.DoubleProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleDoubleHashMap
implements DoubleDoubleMap,
Cloneable {
    protected double defaultValue = 0.0;
    public double[] keys;
    public double[] values;
    public boolean allocatedDefaultKey = false;
    public double allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<DoubleDoubleCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = DoubleDoubleHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public DoubleDoubleHashMap() {
        this(8);
    }

    public DoubleDoubleHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public DoubleDoubleHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public DoubleDoubleHashMap(DoubleDoubleAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public double put(double key, double value) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            if (this.allocatedDefaultKey) {
                double previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                double oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(DoubleDoubleAssociativeContainer container) {
        return this.putAll((Iterable<? extends DoubleDoubleCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends DoubleDoubleCursor> iterable) {
        int count = this.size();
        for (DoubleDoubleCursor doubleDoubleCursor : iterable) {
            this.put(doubleDoubleCursor.key, doubleDoubleCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(double key, double value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public double putOrAdd(double key, double putValue, double incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public double addTo(double key, double incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(double pendingKey, double pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (Double.doubleToLongBits(pendingKey) != 0L);
        double[] oldKeys = this.keys;
        double[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        double key = 0.0;
        double value = 0.0;
        int slot = -1;
        double[] keys = this.keys;
        double[] values = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (Double.doubleToLongBits(key) == 0L) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (Double.doubleToLongBits(keys[slot]) != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            double[] keys = new double[capacity];
            double[] values = new double[capacity];
            this.keys = keys;
            this.values = values;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public double remove(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            if (this.allocatedDefaultKey) {
                double previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                double value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        double[] values = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            double existing = keys[slot];
            double existingValue = values[slot];
            if (Double.doubleToLongBits(existing) == 0L) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0.0;
        --this.assigned;
    }

    @Override
    public int removeAll(DoubleContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof DoubleLookupContainer) {
            if (this.allocatedDefaultKey && other.contains(0.0)) {
                this.allocatedDefaultKey = false;
            }
            double[] keys = this.keys;
            int i = 0;
            while (i < keys.length) {
                double existing = keys[i];
                if (Double.doubleToLongBits(existing) != 0L && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (DoubleCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(DoublePredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0.0)) {
            this.allocatedDefaultKey = false;
        }
        double[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(DoubleDoublePredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0.0, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        double[] keys = this.keys;
        double[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public double get(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        DoubleArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        double[] keys = this.keys;
        double[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            DoubleDoubleHashMap other = (DoubleDoubleHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                DoubleDoubleCursor c = (DoubleDoubleCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                double otherValue = other.get(c.key);
                if (Double.doubleToLongBits(c.value) == Double.doubleToLongBits(otherValue)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends DoubleDoubleProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0.0, this.allocatedDefaultKeyValue);
        }
        double[] keys = this.keys;
        double[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            procedure.apply(existing, values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends DoubleDoublePredicate> T forEach(T predicate) {
        double existing;
        if (this.allocatedDefaultKey && !predicate.apply(0.0, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        double[] keys = this.keys;
        double[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && (Double.doubleToLongBits(existing = keys[i]) == 0L || predicate.apply(existing, values[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public DoubleDoubleHashMap clone() {
        DoubleDoubleHashMap cloned = new DoubleDoubleHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (DoubleDoubleCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static DoubleDoubleHashMap from(double[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleDoubleHashMap map = new DoubleDoubleHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static DoubleDoubleHashMap from(DoubleDoubleAssociativeContainer container) {
        return new DoubleDoubleHashMap(container);
    }

    public static DoubleDoubleHashMap newInstance() {
        return new DoubleDoubleHashMap();
    }

    public static DoubleDoubleHashMap newInstance(int initialCapacity, double loadFactor) {
        return new DoubleDoubleHashMap(initialCapacity, loadFactor);
    }

    @Override
    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(double defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        public final DoubleCursor cursor = new DoubleCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            if (this.cursor.index == DoubleDoubleHashMap.this.values.length + 1) {
                if (DoubleDoubleHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = DoubleDoubleHashMap.this.values.length;
                    this.cursor.value = DoubleDoubleHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = DoubleDoubleHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Double.doubleToLongBits(DoubleDoubleHashMap.this.keys[i]) == 0L; --i) {
            }
            if (i == -1) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = DoubleDoubleHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractDoubleCollection {
        private final DoubleDoubleHashMap owner;
        protected final IteratorPool<DoubleCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = DoubleDoubleHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = DoubleDoubleHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(double value) {
            if (this.owner.allocatedDefaultKey && Double.doubleToLongBits(value) == Double.doubleToLongBits(this.owner.allocatedDefaultKeyValue)) {
                return true;
            }
            double[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (Double.doubleToLongBits(keys[slot]) == 0L || Double.doubleToLongBits(value) != Double.doubleToLongBits(values[slot])) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            double[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (Double.doubleToLongBits(keys[slot]) == 0L) continue;
                procedure.apply(values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            double[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (Double.doubleToLongBits(keys[slot]) == 0L || predicate.apply(values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(double e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && Double.doubleToLongBits(e) == Double.doubleToLongBits(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            double[] keys = this.owner.keys;
            double[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (Double.doubleToLongBits(keys[slot]) != 0L && Double.doubleToLongBits(e) == Double.doubleToLongBits(values[slot])) {
                    DoubleDoubleHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            double[] keys = this.owner.keys;
            double[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (Double.doubleToLongBits(keys[slot]) != 0L && predicate.apply(values[slot])) {
                    DoubleDoubleHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public double[] toArray(double[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            double[] keys = this.owner.keys;
            double[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (Double.doubleToLongBits(keys[i]) == 0L) continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<DoubleCursor> {
        public final DoubleCursor cursor = new DoubleCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            if (this.cursor.index == DoubleDoubleHashMap.this.keys.length + 1) {
                if (DoubleDoubleHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = DoubleDoubleHashMap.this.keys.length;
                    this.cursor.value = 0.0;
                    return this.cursor;
                }
                this.cursor.index = DoubleDoubleHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Double.doubleToLongBits(DoubleDoubleHashMap.this.keys[i]) == 0L; --i) {
            }
            if (i == -1) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = DoubleDoubleHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractDoubleCollection
    implements DoubleLookupContainer {
        private final DoubleDoubleHashMap owner;
        protected final IteratorPool<DoubleCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = DoubleDoubleHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = DoubleDoubleHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(double e) {
            return DoubleDoubleHashMap.this.containsKey(e);
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(0.0);
            }
            double[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                double existing = keys[i];
                if (Double.doubleToLongBits(existing) == 0L) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            double existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(0.0)) {
                return predicate;
            }
            double[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && (Double.doubleToLongBits(existing = keys[i]) == 0L || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(double e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public double[] toArray(double[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0.0;
            }
            double[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                double existing = keys[i];
                if (Double.doubleToLongBits(existing) == 0L) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<DoubleDoubleCursor> {
        public final DoubleDoubleCursor cursor = new DoubleDoubleCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected DoubleDoubleCursor fetch() {
            int i;
            if (this.cursor.index == DoubleDoubleHashMap.this.keys.length + 1) {
                if (DoubleDoubleHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = DoubleDoubleHashMap.this.keys.length;
                    this.cursor.key = 0.0;
                    this.cursor.value = DoubleDoubleHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = DoubleDoubleHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Double.doubleToLongBits(DoubleDoubleHashMap.this.keys[i]) == 0L; --i) {
            }
            if (i == -1) {
                return (DoubleDoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = DoubleDoubleHashMap.this.keys[i];
            this.cursor.value = DoubleDoubleHashMap.this.values[i];
            return this.cursor;
        }
    }
}

