/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractDoubleCollection;
import com.carrotsearch.hppcrt.AbstractFloatCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.DoubleArrays;
import com.carrotsearch.hppcrt.DoubleContainer;
import com.carrotsearch.hppcrt.DoubleFloatAssociativeContainer;
import com.carrotsearch.hppcrt.DoubleFloatMap;
import com.carrotsearch.hppcrt.DoubleLookupContainer;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.DoubleCursor;
import com.carrotsearch.hppcrt.cursors.DoubleFloatCursor;
import com.carrotsearch.hppcrt.cursors.FloatCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.DoubleFloatPredicate;
import com.carrotsearch.hppcrt.predicates.DoublePredicate;
import com.carrotsearch.hppcrt.predicates.FloatPredicate;
import com.carrotsearch.hppcrt.procedures.DoubleFloatProcedure;
import com.carrotsearch.hppcrt.procedures.DoubleProcedure;
import com.carrotsearch.hppcrt.procedures.FloatProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleFloatHashMap
implements DoubleFloatMap,
Cloneable {
    protected float defaultValue = 0.0f;
    public double[] keys;
    public float[] values;
    public boolean allocatedDefaultKey = false;
    public float allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<DoubleFloatCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = DoubleFloatHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public DoubleFloatHashMap() {
        this(8);
    }

    public DoubleFloatHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public DoubleFloatHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public DoubleFloatHashMap(DoubleFloatAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public float put(double key, float value) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            if (this.allocatedDefaultKey) {
                float previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                float oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(DoubleFloatAssociativeContainer container) {
        return this.putAll((Iterable<? extends DoubleFloatCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends DoubleFloatCursor> iterable) {
        int count = this.size();
        for (DoubleFloatCursor doubleFloatCursor : iterable) {
            this.put(doubleFloatCursor.key, doubleFloatCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(double key, float value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public float putOrAdd(double key, float putValue, float incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public float addTo(double key, float incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(double pendingKey, float pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (Double.doubleToLongBits(pendingKey) != 0L);
        double[] oldKeys = this.keys;
        float[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        double key = 0.0;
        float value = 0.0f;
        int slot = -1;
        double[] keys = this.keys;
        float[] values = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (Double.doubleToLongBits(key) == 0L) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (Double.doubleToLongBits(keys[slot]) != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            double[] keys = new double[capacity];
            float[] values = new float[capacity];
            this.keys = keys;
            this.values = values;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public float remove(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            if (this.allocatedDefaultKey) {
                float previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                float value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        float[] values = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            double existing = keys[slot];
            float existingValue = values[slot];
            if (Double.doubleToLongBits(existing) == 0L) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0.0;
        --this.assigned;
    }

    @Override
    public int removeAll(DoubleContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof DoubleLookupContainer) {
            if (this.allocatedDefaultKey && other.contains(0.0)) {
                this.allocatedDefaultKey = false;
            }
            double[] keys = this.keys;
            int i = 0;
            while (i < keys.length) {
                double existing = keys[i];
                if (Double.doubleToLongBits(existing) != 0L && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (DoubleCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(DoublePredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0.0)) {
            this.allocatedDefaultKey = false;
        }
        double[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(DoubleFloatPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0.0, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        double[] keys = this.keys;
        float[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public float get(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        DoubleArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        double[] keys = this.keys;
        float[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            DoubleFloatHashMap other = (DoubleFloatHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                DoubleFloatCursor c = (DoubleFloatCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                float otherValue = other.get(c.key);
                if (Float.floatToIntBits(c.value) == Float.floatToIntBits(otherValue)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends DoubleFloatProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0.0, this.allocatedDefaultKeyValue);
        }
        double[] keys = this.keys;
        float[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            procedure.apply(existing, values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends DoubleFloatPredicate> T forEach(T predicate) {
        double existing;
        if (this.allocatedDefaultKey && !predicate.apply(0.0, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        double[] keys = this.keys;
        float[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && (Double.doubleToLongBits(existing = keys[i]) == 0L || predicate.apply(existing, values[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public DoubleFloatHashMap clone() {
        DoubleFloatHashMap cloned = new DoubleFloatHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (DoubleFloatCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static DoubleFloatHashMap from(double[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleFloatHashMap map = new DoubleFloatHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static DoubleFloatHashMap from(DoubleFloatAssociativeContainer container) {
        return new DoubleFloatHashMap(container);
    }

    public static DoubleFloatHashMap newInstance() {
        return new DoubleFloatHashMap();
    }

    public static DoubleFloatHashMap newInstance(int initialCapacity, double loadFactor) {
        return new DoubleFloatHashMap(initialCapacity, loadFactor);
    }

    @Override
    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(float defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        public final FloatCursor cursor = new FloatCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected FloatCursor fetch() {
            int i;
            if (this.cursor.index == DoubleFloatHashMap.this.values.length + 1) {
                if (DoubleFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = DoubleFloatHashMap.this.values.length;
                    this.cursor.value = DoubleFloatHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = DoubleFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Double.doubleToLongBits(DoubleFloatHashMap.this.keys[i]) == 0L; --i) {
            }
            if (i == -1) {
                return (FloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = DoubleFloatHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractFloatCollection {
        private final DoubleFloatHashMap owner;
        protected final IteratorPool<FloatCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = DoubleFloatHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = DoubleFloatHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(float value) {
            if (this.owner.allocatedDefaultKey && Float.floatToIntBits(value) == Float.floatToIntBits(this.owner.allocatedDefaultKeyValue)) {
                return true;
            }
            double[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (Double.doubleToLongBits(keys[slot]) == 0L || Float.floatToIntBits(value) != Float.floatToIntBits(values[slot])) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            double[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (Double.doubleToLongBits(keys[slot]) == 0L) continue;
                procedure.apply(values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            double[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (Double.doubleToLongBits(keys[slot]) == 0L || predicate.apply(values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(float e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && Float.floatToIntBits(e) == Float.floatToIntBits(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            double[] keys = this.owner.keys;
            float[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (Double.doubleToLongBits(keys[slot]) != 0L && Float.floatToIntBits(e) == Float.floatToIntBits(values[slot])) {
                    DoubleFloatHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(FloatPredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            double[] keys = this.owner.keys;
            float[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (Double.doubleToLongBits(keys[slot]) != 0L && predicate.apply(values[slot])) {
                    DoubleFloatHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public float[] toArray(float[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            double[] keys = this.owner.keys;
            float[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (Double.doubleToLongBits(keys[i]) == 0L) continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<DoubleCursor> {
        public final DoubleCursor cursor = new DoubleCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            if (this.cursor.index == DoubleFloatHashMap.this.keys.length + 1) {
                if (DoubleFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = DoubleFloatHashMap.this.keys.length;
                    this.cursor.value = 0.0;
                    return this.cursor;
                }
                this.cursor.index = DoubleFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Double.doubleToLongBits(DoubleFloatHashMap.this.keys[i]) == 0L; --i) {
            }
            if (i == -1) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = DoubleFloatHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractDoubleCollection
    implements DoubleLookupContainer {
        private final DoubleFloatHashMap owner;
        protected final IteratorPool<DoubleCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = DoubleFloatHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = DoubleFloatHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(double e) {
            return DoubleFloatHashMap.this.containsKey(e);
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(0.0);
            }
            double[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                double existing = keys[i];
                if (Double.doubleToLongBits(existing) == 0L) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            double existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(0.0)) {
                return predicate;
            }
            double[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && (Double.doubleToLongBits(existing = keys[i]) == 0L || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(double e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public double[] toArray(double[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0.0;
            }
            double[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                double existing = keys[i];
                if (Double.doubleToLongBits(existing) == 0L) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<DoubleFloatCursor> {
        public final DoubleFloatCursor cursor = new DoubleFloatCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected DoubleFloatCursor fetch() {
            int i;
            if (this.cursor.index == DoubleFloatHashMap.this.keys.length + 1) {
                if (DoubleFloatHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = DoubleFloatHashMap.this.keys.length;
                    this.cursor.key = 0.0;
                    this.cursor.value = DoubleFloatHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = DoubleFloatHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Double.doubleToLongBits(DoubleFloatHashMap.this.keys[i]) == 0L; --i) {
            }
            if (i == -1) {
                return (DoubleFloatCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = DoubleFloatHashMap.this.keys[i];
            this.cursor.value = DoubleFloatHashMap.this.values[i];
            return this.cursor;
        }
    }
}

