/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractLongCollection;
import com.carrotsearch.hppcrt.AbstractObjectCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectArrays;
import com.carrotsearch.hppcrt.ObjectContainer;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ObjectLongAssociativeContainer;
import com.carrotsearch.hppcrt.ObjectLongMap;
import com.carrotsearch.hppcrt.ObjectLookupContainer;
import com.carrotsearch.hppcrt.cursors.LongCursor;
import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.cursors.ObjectLongCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.LongPredicate;
import com.carrotsearch.hppcrt.predicates.ObjectLongPredicate;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;
import com.carrotsearch.hppcrt.procedures.LongProcedure;
import com.carrotsearch.hppcrt.procedures.ObjectLongProcedure;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectLongHashMap<KType>
implements ObjectLongMap<KType>,
Cloneable {
    protected long defaultValue = 0L;
    public Object[] keys;
    public long[] values;
    protected int[] hash_cache;
    public boolean allocatedDefaultKey = false;
    public long allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<ObjectLongCursor<KType>, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = ObjectLongHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
            obj.cursor.key = null;
        }
    });

    protected int hashKey(KType key) {
        return key.hashCode();
    }

    protected boolean equalKeys(KType a, KType b) {
        return a.equals(b);
    }

    public ObjectLongHashMap() {
        this(8);
    }

    public ObjectLongHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public ObjectLongHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public ObjectLongHashMap(ObjectLongAssociativeContainer<KType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public long put(KType key, long value) {
        Object existing;
        if (key == null) {
            if (this.allocatedDefaultKey) {
                long previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        Object[] keys = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        long[] values = this.values;
        int[] cached = this.hash_cache;
        int initial_slot = slot;
        int dist = 0;
        int existing_distance = 0;
        while ((existing = keys[slot]) != null) {
            existing_distance = this.probe_distance(slot, cached);
            if (dist <= existing_distance && this.equalKeys(key, existing)) {
                long oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            if (dist > existing_distance) {
                Object tmpKey = keys[slot];
                keys[slot] = key;
                key = tmpKey;
                int tmpAllocated = cached[slot];
                cached[slot] = initial_slot;
                initial_slot = tmpAllocated;
                long tmpValue = values[slot];
                values[slot] = value;
                value = tmpValue;
                dist = existing_distance;
            }
            slot = slot + 1 & mask;
            ++dist;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            cached[slot] = initial_slot;
            keys[slot] = key;
            values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(ObjectLongAssociativeContainer<? extends KType> container) {
        return this.putAll((Iterable<? extends ObjectLongCursor<? extends KType>>)container);
    }

    @Override
    public int putAll(Iterable<? extends ObjectLongCursor<? extends KType>> iterable) {
        int count = this.size();
        for (ObjectLongCursor<KType> objectLongCursor : iterable) {
            this.put(objectLongCursor.key, objectLongCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(KType key, long value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public long putOrAdd(KType key, long putValue, long incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public long addTo(KType key, long incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(KType pendingKey, long pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (pendingKey != null);
        Object[] oldKeys = this.keys;
        long[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        Object key = null;
        long value = 0L;
        int slot = -1;
        Object[] keys = this.keys;
        long[] values = this.values;
        int[] cached = this.hash_cache;
        Object tmpKey = null;
        long tmpValue = 0L;
        int tmpAllocated = -1;
        int initial_slot = -1;
        int dist = -1;
        int existing_distance = -1;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (key == null) continue;
            value = oldValues[i];
            initial_slot = slot = BitMixer.mix(this.hashKey(key), perturb) & mask;
            dist = 0;
            while (keys[slot] != null) {
                existing_distance = this.probe_distance(slot, cached);
                if (dist > existing_distance) {
                    tmpKey = keys[slot];
                    keys[slot] = key;
                    key = tmpKey;
                    tmpAllocated = cached[slot];
                    cached[slot] = initial_slot;
                    initial_slot = tmpAllocated;
                    tmpValue = values[slot];
                    values[slot] = value;
                    value = tmpValue;
                    dist = existing_distance;
                }
                slot = slot + 1 & mask;
                ++dist;
            }
            cached[slot] = initial_slot;
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            Object[] keys = new Object[capacity];
            long[] values = new long[capacity];
            int[] cached = new int[capacity];
            this.keys = keys;
            this.values = values;
            this.hash_cache = cached;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public long remove(KType key) {
        Object existing;
        if (key == null) {
            if (this.allocatedDefaultKey) {
                long previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        Object[] keys = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        int[] cached = this.hash_cache;
        for (int dist = 0; (existing = keys[slot]) != null && dist <= this.probe_distance(slot, cached); ++dist) {
            if (this.equalKeys(key, existing)) {
                long value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        Object[] keys = this.keys;
        long[] values = this.values;
        int[] cached = this.hash_cache;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            Object existing = keys[slot];
            long existingValue = values[slot];
            if (existing == null) break;
            int idealSlotModMask = cached[slot];
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            cached[gapSlot] = idealSlotModMask;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = null;
        --this.assigned;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int removeAll(ObjectContainer<? super KType> other) {
        int before = this.size();
        if (other.size() >= before && other instanceof ObjectLookupContainer) {
            void var4_6;
            if (this.allocatedDefaultKey && other.contains(null)) {
                this.allocatedDefaultKey = false;
            }
            Object[] keys = this.keys;
            boolean bl = false;
            while (var4_6 < keys.length) {
                Object existing = keys[var4_6];
                if (existing != null && other.contains(existing)) {
                    this.shiftConflictingKeys((int)var4_6);
                    continue;
                }
                ++var4_6;
            }
        } else {
            for (ObjectCursor<Object> objectCursor : other) {
                this.remove(objectCursor.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(null)) {
            this.allocatedDefaultKey = false;
        }
        Object[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            Object existing = keys[i];
            if (existing != null && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ObjectLongPredicate<? super KType> predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(null, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        Object[] keys = this.keys;
        long[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            Object existing = keys[i];
            if (existing != null && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public long get(KType key) {
        Object existing;
        if (key == null) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        Object[] keys = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        int[] cached = this.hash_cache;
        for (int dist = 0; (existing = keys[slot]) != null && dist <= this.probe_distance(slot, cached); ++dist) {
            if (this.equalKeys(key, existing)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(KType key) {
        Object existing;
        if (key == null) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        Object[] keys = this.keys;
        int slot = BitMixer.mix(this.hashKey(key), this.perturbation) & mask;
        int[] cached = this.hash_cache;
        for (int dist = 0; (existing = keys[slot]) != null && dist <= this.probe_distance(slot, cached); ++dist) {
            if (this.equalKeys(key, existing)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        ObjectArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        Object[] keys = this.keys;
        long[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            Object existing = keys[i];
            if (existing == null) continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ObjectLongHashMap other = (ObjectLongHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                ObjectLongCursor c = (ObjectLongCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                long otherValue = other.get(c.key);
                if (c.value == otherValue) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends ObjectLongProcedure<? super KType>> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(null, this.allocatedDefaultKeyValue);
        }
        Object[] keys = this.keys;
        long[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            Object existing = keys[i];
            if (existing == null) continue;
            procedure.apply((Object)existing, values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectLongPredicate<? super KType>> T forEach(T predicate) {
        Object existing;
        if (this.allocatedDefaultKey && !predicate.apply(null, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        Object[] keys = this.keys;
        long[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == null || predicate.apply((Object)existing, values[i])); --i) {
        }
        return predicate;
    }

    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public ObjectLongHashMap<KType> clone() {
        ObjectLongHashMap<KType> cloned = new ObjectLongHashMap<KType>(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ObjectLongCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static <KType> ObjectLongHashMap<KType> from(KType[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectLongHashMap<KType> map = new ObjectLongHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <KType> ObjectLongHashMap<KType> from(ObjectLongAssociativeContainer<KType> container) {
        return new ObjectLongHashMap<KType>(container);
    }

    public static <KType> ObjectLongHashMap<KType> newInstance() {
        return new ObjectLongHashMap<KType>();
    }

    public static <KType> ObjectLongHashMap<KType> newInstance(int initialCapacity, double loadFactor) {
        return new ObjectLongHashMap<KType>(initialCapacity, loadFactor);
    }

    @Override
    public long getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(long defaultValue) {
        this.defaultValue = defaultValue;
    }

    private int probe_distance(int slot, int[] cache) {
        int rh = cache[slot];
        if (slot < rh) {
            return slot - rh + cache.length;
        }
        return slot - rh;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        public final LongCursor cursor = new LongCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected LongCursor fetch() {
            int i;
            if (this.cursor.index == ObjectLongHashMap.this.values.length + 1) {
                if (ObjectLongHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ObjectLongHashMap.this.values.length;
                    this.cursor.value = ObjectLongHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ObjectLongHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ObjectLongHashMap.this.keys[i] == null; --i) {
            }
            if (i == -1) {
                return (LongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ObjectLongHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractLongCollection {
        private final ObjectLongHashMap<KType> owner;
        protected final IteratorPool<LongCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = ObjectLongHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = ObjectLongHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(long value) {
            if (this.owner.allocatedDefaultKey && value == this.owner.allocatedDefaultKeyValue) {
                return true;
            }
            Object[] keys = this.owner.keys;
            long[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == null || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            Object[] keys = this.owner.keys;
            long[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (keys[slot] == null) continue;
                procedure.apply(values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            Object[] keys = this.owner.keys;
            long[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (keys[slot] == null || predicate.apply(values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(long e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && e == this.owner.allocatedDefaultKeyValue) {
                this.owner.allocatedDefaultKey = false;
            }
            Object[] keys = this.owner.keys;
            long[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != null && e == values[slot]) {
                    ObjectLongHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            Object[] keys = this.owner.keys;
            long[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (keys[slot] != null && predicate.apply(values[slot])) {
                    ObjectLongHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public long[] toArray(long[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            Object[] keys = this.owner.keys;
            long[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (keys[i] == null) continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        public final ObjectCursor<KType> cursor = new ObjectCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int i;
            if (this.cursor.index == ObjectLongHashMap.this.keys.length + 1) {
                if (ObjectLongHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ObjectLongHashMap.this.keys.length;
                    this.cursor.value = null;
                    return this.cursor;
                }
                this.cursor.index = ObjectLongHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ObjectLongHashMap.this.keys[i] == null; --i) {
            }
            if (i == -1) {
                return (ObjectCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = ObjectLongHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectLongHashMap<KType> owner;
        protected final IteratorPool<ObjectCursor<KType>, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = ObjectLongHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = ObjectLongHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                    obj.cursor.value = null;
                }
            });
        }

        @Override
        public boolean contains(KType e) {
            return ObjectLongHashMap.this.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(null);
            }
            Object[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                Object existing = keys[i];
                if (existing == null) continue;
                procedure.apply((Object)existing);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            Object existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(null)) {
                return predicate;
            }
            Object[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && ((existing = keys[i]) == null || predicate.apply((Object)existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(KType e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public KType[] toArray(KType[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = null;
            }
            Object[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                Object existing = keys[i];
                if (existing == null) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<ObjectLongCursor<KType>> {
        public final ObjectLongCursor<KType> cursor = new ObjectLongCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected ObjectLongCursor<KType> fetch() {
            int i;
            if (this.cursor.index == ObjectLongHashMap.this.keys.length + 1) {
                if (ObjectLongHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = ObjectLongHashMap.this.keys.length;
                    this.cursor.key = null;
                    this.cursor.value = ObjectLongHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = ObjectLongHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && ObjectLongHashMap.this.keys[i] == null; --i) {
            }
            if (i == -1) {
                return (ObjectLongCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = ObjectLongHashMap.this.keys[i];
            this.cursor.value = ObjectLongHashMap.this.values[i];
            return this.cursor;
        }
    }
}

