/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.sorting;

import com.carrotsearch.hppcrt.sorting.IndirectComparator;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndirectSort {
    private static final int MIN_LENGTH_FOR_INSERTION_SORT = 30;
    private static final int MIN_LENGTH_FOR_INSERTION_SORT_IN_QSORT = 17;
    private static final int DIST_SIZE_DUALQSORT = 13;

    private IndirectSort() {
    }

    public static int[] mergesort(int start, int length, IndirectComparator comparator) {
        int[] sorted = new int[length];
        IndirectSort.mergesort(start, length, comparator, new int[length], sorted);
        return sorted;
    }

    public static void mergesort(int start, int length, IndirectComparator comparator, int[] tmpArray, int[] sorted) {
        assert (length <= sorted.length);
        IndirectSort.fillOrderArray(start, length, tmpArray);
        System.arraycopy(tmpArray, 0, sorted, 0, length);
        if (length > 1) {
            IndirectSort.topDownMergeSort(tmpArray, sorted, 0, length, comparator);
        }
    }

    public static void quicksort(int start, int length, IndirectComparator comparator, int[] sorted) {
        assert (length <= sorted.length);
        IndirectSort.fillOrderArray(start, length, sorted);
        if (length > 1) {
            IndirectSort.dualPivotQuicksort(sorted, start, start + length - 1, comparator);
        }
    }

    public static <T> int[] mergesort(T[] input, int start, int length, Comparator<? super T> comparator) {
        return IndirectSort.mergesort(start, length, new IndirectComparator.DelegatingComparator<T>(input, comparator));
    }

    private static void topDownMergeSort(int[] src, int[] dst, int fromIndex, int toIndex, IndirectComparator comp) {
        if (toIndex - fromIndex <= 30) {
            IndirectSort.insertionSort(fromIndex, toIndex - fromIndex, dst, comp);
            return;
        }
        int mid = fromIndex + toIndex >>> 1;
        IndirectSort.topDownMergeSort(dst, src, fromIndex, mid, comp);
        IndirectSort.topDownMergeSort(dst, src, mid, toIndex, comp);
        if (comp.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, fromIndex, dst, fromIndex, toIndex - fromIndex);
        } else {
            int i = fromIndex;
            int j = mid;
            for (int k = fromIndex; k < toIndex; ++k) {
                dst[k] = j == toIndex || i < mid && comp.compare(src[i], src[j]) <= 0 ? src[i++] : src[j++];
            }
        }
    }

    private static void insertionSort(int off, int len, int[] order, IndirectComparator intComparator) {
        for (int i = off + 1; i < off + len; ++i) {
            int t;
            int v = order[i];
            int j = i;
            while (j > off && intComparator.compare(t = order[j - 1], v) > 0) {
                order[j--] = t;
            }
            order[j] = v;
        }
    }

    private static void fillOrderArray(int start, int length, int[] order) {
        for (int i = 0; i < length; ++i) {
            order[i] = start + i;
        }
    }

    private static void dualPivotQuicksort(int[] a, int left, int right, IndirectComparator comp) {
        int k;
        int pivot2;
        int pivot1;
        int x;
        int len = right - left;
        if (len <= 17) {
            IndirectSort.insertionSort(left, len + 1, a, comp);
            return;
        }
        int sixth = len / 6;
        int m1 = left + sixth;
        int m22 = m1 + sixth;
        int m3 = m22 + sixth;
        int m4 = m3 + sixth;
        int m5 = m4 + sixth;
        if (comp.compare(a[m1], a[m22]) > 0) {
            x = a[m1];
            a[m1] = a[m22];
            a[m22] = x;
        }
        if (comp.compare(a[m4], a[m5]) > 0) {
            x = a[m4];
            a[m4] = a[m5];
            a[m5] = x;
        }
        if (comp.compare(a[m1], a[m3]) > 0) {
            x = a[m1];
            a[m1] = a[m3];
            a[m3] = x;
        }
        if (comp.compare(a[m22], a[m3]) > 0) {
            x = a[m22];
            a[m22] = a[m3];
            a[m3] = x;
        }
        if (comp.compare(a[m1], a[m4]) > 0) {
            x = a[m1];
            a[m1] = a[m4];
            a[m4] = x;
        }
        if (comp.compare(a[m3], a[m4]) > 0) {
            x = a[m3];
            a[m3] = a[m4];
            a[m4] = x;
        }
        if (comp.compare(a[m22], a[m5]) > 0) {
            x = a[m22];
            a[m22] = a[m5];
            a[m5] = x;
        }
        if (comp.compare(a[m22], a[m3]) > 0) {
            x = a[m22];
            a[m22] = a[m3];
            a[m3] = x;
        }
        if (comp.compare(a[m4], a[m5]) > 0) {
            x = a[m4];
            a[m4] = a[m5];
            a[m5] = x;
        }
        boolean diffPivots = comp.compare(pivot1 = a[m22], pivot2 = a[m4]) != 0;
        a[m22] = a[left];
        a[m4] = a[right];
        int less = left + 1;
        int great = right - 1;
        if (diffPivots) {
            for (k = less; k <= great; ++k) {
                x = a[k];
                if (comp.compare(x, pivot1) < 0) {
                    a[k] = a[less];
                    a[less++] = x;
                    continue;
                }
                if (comp.compare(x, pivot2) <= 0) continue;
                while (comp.compare(a[great], pivot2) > 0 && k < great) {
                    --great;
                }
                a[k] = a[great];
                a[great--] = x;
                x = a[k];
                if (comp.compare(x, pivot1) >= 0) continue;
                a[k] = a[less];
                a[less++] = x;
            }
        } else {
            for (k = less; k <= great; ++k) {
                x = a[k];
                if (comp.compare(x, pivot1) == 0) continue;
                if (comp.compare(x, pivot1) < 0) {
                    a[k] = a[less];
                    a[less++] = x;
                    continue;
                }
                while (comp.compare(a[great], pivot2) > 0 && k < great) {
                    --great;
                }
                a[k] = a[great];
                a[great--] = x;
                x = a[k];
                if (comp.compare(x, pivot1) >= 0) continue;
                a[k] = a[less];
                a[less++] = x;
            }
        }
        a[left] = a[less - 1];
        a[less - 1] = pivot1;
        a[right] = a[great + 1];
        a[great + 1] = pivot2;
        IndirectSort.dualPivotQuicksort(a, left, less - 2, comp);
        IndirectSort.dualPivotQuicksort(a, great + 2, right, comp);
        if (great - less > len - 13 && diffPivots) {
            for (k = less; k <= great; ++k) {
                x = a[k];
                if (comp.compare(x, pivot1) == 0) {
                    a[k] = a[less];
                    a[less++] = x;
                    continue;
                }
                if (comp.compare(x, pivot2) != 0) continue;
                a[k] = a[great];
                a[great--] = x;
                x = a[k];
                if (comp.compare(x, pivot1) != 0) continue;
                a[k] = a[less];
                a[less++] = x;
            }
        }
        if (diffPivots) {
            IndirectSort.dualPivotQuicksort(a, less, great, comp);
        }
    }
}

