/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.soap.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    public static String nodeToString(Node node) {
        StringWriter stringWriter = new StringWriter();
        DOMWriter.serializeAsXML(node, stringWriter);
        return stringWriter.toString();
    }

    private static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': {
                    if (n2 > 0) {
                        char c2 = stringBuffer.charAt(stringBuffer.length() - 1);
                        if (c2 != '\r') {
                            stringBuffer.append(StringUtils.lineSeparator);
                            break;
                        }
                        stringBuffer.append('\n');
                        break;
                    }
                    stringBuffer.append(StringUtils.lineSeparator);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static void print(Node node, PrintWriter printWriter) {
        if (node == null) {
            return;
        }
        boolean bl = false;
        short s2 = node.getNodeType();
        switch (s2) {
            case 9: {
                printWriter.println("<?xml version=\"1.0\"?>");
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    DOMWriter.print(nodeList.item(n2), printWriter);
                    ++n2;
                }
                break;
            }
            case 1: {
                Object object;
                printWriter.print(String.valueOf('<') + node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = namedNodeMap != null ? namedNodeMap.getLength() : 0;
                int n3 = 0;
                while (n3 < n) {
                    object = (Attr)namedNodeMap.item(n3);
                    printWriter.print(String.valueOf(' ') + object.getNodeName() + "=\"" + DOMWriter.normalize(object.getValue()) + '\"');
                    ++n3;
                }
                object = node.getChildNodes();
                if (object != null) {
                    int n4 = object.getLength();
                    boolean bl2 = bl = n4 > 0;
                    if (bl) {
                        printWriter.print('>');
                    }
                    int n5 = 0;
                    while (n5 < n4) {
                        DOMWriter.print(object.item(n5), printWriter);
                        ++n5;
                    }
                } else {
                    bl = false;
                }
                if (bl) break;
                printWriter.print("/>");
                break;
            }
            case 5: {
                printWriter.print('&');
                printWriter.print(node.getNodeName());
                printWriter.print(';');
                break;
            }
            case 4: {
                printWriter.print("<![CDATA[");
                printWriter.print(node.getNodeValue());
                printWriter.print("]]>");
                break;
            }
            case 3: {
                printWriter.print(DOMWriter.normalize(node.getNodeValue()));
                break;
            }
            case 8: {
                printWriter.print("<!--");
                printWriter.print(node.getNodeValue());
                printWriter.print("-->");
                break;
            }
            case 7: {
                printWriter.print("<?");
                printWriter.print(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    printWriter.print(' ');
                    printWriter.print(string);
                }
                printWriter.println("?>");
                break;
            }
        }
        if (s2 == 1 && bl) {
            printWriter.print("</");
            printWriter.print(node.getNodeName());
            printWriter.print('>');
            bl = false;
        }
    }

    public static void serializeAsXML(Node node, Writer writer) {
        DOMWriter.print(node, new PrintWriter(writer));
    }
}

