/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;

public abstract class DelayedIteration<E, X extends Exception>
extends AbstractCloseableIteration<E, X> {
    private volatile Iteration<? extends E, ? extends X> iter;

    protected abstract Iteration<? extends E, ? extends X> createIteration() throws X;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() throws X {
        if (this.isClosed()) {
            return false;
        }
        Iteration<E, X> resultIter = this.iter;
        if (resultIter == null) {
            DelayedIteration delayedIteration = this;
            synchronized (delayedIteration) {
                resultIter = this.iter;
                if (resultIter == null) {
                    this.iter = this.createIteration();
                    resultIter = this.iter;
                }
            }
        }
        return resultIter.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() throws X {
        if (this.isClosed()) {
            throw new NoSuchElementException("Iteration has been closed");
        }
        Iteration<E, X> resultIter = this.iter;
        if (resultIter == null) {
            DelayedIteration delayedIteration = this;
            synchronized (delayedIteration) {
                resultIter = this.iter;
                if (resultIter == null) {
                    this.iter = this.createIteration();
                    resultIter = this.iter;
                }
            }
        }
        return resultIter.next();
    }

    @Override
    public void remove() throws X {
        if (this.isClosed()) {
            throw new IllegalStateException("The iteration has been closed.");
        }
        Iteration<E, X> resultIter = this.iter;
        if (resultIter == null) {
            throw new IllegalStateException("Underlying iteration was null");
        }
        resultIter.remove();
    }

    @Override
    protected void handleClose() throws X {
        try {
            super.handleClose();
        }
        finally {
            Iteration<? extends E, ? extends X> toClose = this.iter;
            if (toClose != null) {
                Iterations.closeCloseable(toClose);
            }
        }
    }
}

