/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.util.iterators.Iterators;

public class Models {
    protected Models() {
    }

    public static Optional<Value> object(Model m3) {
        return m3.stream().map(st -> st.getObject()).findAny();
    }

    @Deprecated
    public static Value anyObject(Model m3) {
        return Models.object(m3).orElse(null);
    }

    public static Optional<Literal> objectLiteral(Model m3) {
        return m3.stream().map(st -> st.getObject()).filter(o -> o instanceof Literal).map(l -> (Literal)l).findAny();
    }

    public static Set<Literal> objectLiterals(Model m3) {
        return m3.stream().map(st -> st.getObject()).filter(o -> o instanceof Literal).map(l -> (Literal)l).collect(Collectors.toSet());
    }

    @Deprecated
    public static Literal anyObjectLiteral(Model m3) {
        return Models.objectLiteral(m3).orElse(null);
    }

    public static Optional<Resource> objectResource(Model m3) {
        return m3.stream().map(st -> st.getObject()).filter(o -> o instanceof Resource).map(r -> (Resource)r).findAny();
    }

    public static Set<Resource> objectResources(Model m3) {
        return m3.stream().map(st -> st.getObject()).filter(o -> o instanceof Resource).map(r -> (Resource)r).collect(Collectors.toSet());
    }

    @Deprecated
    public static Resource anyObjectResource(Model m3) {
        return Models.objectResource(m3).orElse(null);
    }

    public static Optional<IRI> objectIRI(Model m3) {
        return m3.stream().map(st -> st.getObject()).filter(o -> o instanceof IRI).map(r -> (IRI)r).findAny();
    }

    public static Set<IRI> objectIRIs(Model m3) {
        return m3.stream().map(st -> st.getObject()).filter(o -> o instanceof IRI).map(r -> (IRI)r).collect(Collectors.toSet());
    }

    public static Optional<String> objectString(Model m3) {
        return m3.stream().map(st -> st.getObject().stringValue()).findAny();
    }

    public static Set<String> objectStrings(Model m3) {
        return m3.stream().map(st -> st.getObject().stringValue()).collect(Collectors.toSet());
    }

    @Deprecated
    public static URI anyObjectURI(Model m3) {
        return Models.objectIRI(m3).orElse(null);
    }

    public static Optional<Resource> subject(Model m3) {
        return m3.stream().map(st -> st.getSubject()).findAny();
    }

    @Deprecated
    public static Resource anySubject(Model m3) {
        return Models.subject(m3).orElse(null);
    }

    public static Optional<IRI> subjectIRI(Model m3) {
        return m3.stream().map(st -> st.getSubject()).filter(s2 -> s2 instanceof IRI).map(s2 -> (IRI)s2).findAny();
    }

    public static Set<IRI> subjectIRIs(Model m3) {
        return m3.subjects().stream().filter(s2 -> s2 instanceof IRI).map(s2 -> (IRI)s2).collect(Collectors.toSet());
    }

    @Deprecated
    public static URI anySubjectURI(Model m3) {
        return Models.subjectIRI(m3).orElse(null);
    }

    public static Optional<BNode> subjectBNode(Model m3) {
        return m3.stream().map(st -> st.getSubject()).filter(s2 -> s2 instanceof BNode).map(s2 -> (BNode)s2).findAny();
    }

    public static Set<BNode> subjectBNodes(Model m3) {
        return m3.subjects().stream().filter(s2 -> s2 instanceof BNode).map(s2 -> (BNode)s2).collect(Collectors.toSet());
    }

    @Deprecated
    public static BNode anySubjectBNode(Model m3) {
        return Models.subjectBNode(m3).orElse(null);
    }

    public static Optional<IRI> predicate(Model m3) {
        return m3.stream().map(st -> st.getPredicate()).findAny();
    }

    @Deprecated
    public static URI anyPredicate(Model m3) {
        return Models.predicate(m3).orElse(null);
    }

    public static Model setProperty(Model m3, Resource subject, IRI property, Value value, Resource ... contexts) {
        Objects.requireNonNull(m3, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        Objects.requireNonNull(value, "value may not be null");
        if (m3.contains(subject, property, null, contexts)) {
            m3.remove(subject, property, null, contexts);
        }
        m3.add(subject, property, value, contexts);
        return m3;
    }

    public static Optional<Value> getProperty(Model m3, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m3, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.object(m3.filter(subject, property, null, contexts));
    }

    public static Set<Value> getProperties(Model m3, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m3, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return m3.filter(subject, property, null, contexts).objects();
    }

    public static Optional<Resource> getPropertyResource(Model m3, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m3, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectResource(m3.filter(subject, property, null, contexts));
    }

    public static Set<Resource> getPropertyResources(Model m3, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m3, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectResources(m3.filter(subject, property, null, contexts));
    }

    public static Optional<IRI> getPropertyIRI(Model m3, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m3, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectIRI(m3.filter(subject, property, null, contexts));
    }

    public static Set<IRI> getPropertyIRIs(Model m3, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m3, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectIRIs(m3.filter(subject, property, null, contexts));
    }

    public static Optional<Literal> getPropertyLiteral(Model m3, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m3, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectLiteral(m3.filter(subject, property, null, contexts));
    }

    public static Set<Literal> getPropertyLiterals(Model m3, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m3, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectLiterals(m3.filter(subject, property, null, contexts));
    }

    public static Optional<String> getPropertyString(Model m3, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m3, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectString(m3.filter(subject, property, null, contexts));
    }

    public static Set<String> getPropertyStrings(Model m3, Resource subject, IRI property, Resource ... contexts) {
        Objects.requireNonNull(m3, "model may not be null");
        Objects.requireNonNull(subject, "subject may not be null");
        Objects.requireNonNull(property, "property may not be null");
        return Models.objectStrings(m3.filter(subject, property, null, contexts));
    }

    public static boolean isomorphic(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        Model set1 = Models.toModel(model1);
        Model set2 = Models.toModel(model2);
        if (set1.size() != set2.size()) {
            return false;
        }
        return Models.isSubsetInternal(set1, set2);
    }

    @Deprecated
    public static boolean equals(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        return Models.isomorphic(model1, model2);
    }

    public static boolean isSubset(Iterable<? extends Statement> model1, Iterable<? extends Statement> model2) {
        Model set1 = Models.toModel(model1);
        Model set2 = Models.toModel(model2);
        return Models.isSubset(set1, set2);
    }

    public static boolean isSubset(Set<? extends Statement> model1, Set<? extends Statement> model2) {
        if (model1.size() > model2.size()) {
            return false;
        }
        return Models.isSubsetInternal(Models.toModel(model1), Models.toModel(model2));
    }

    private static boolean isSubsetInternal(Model model1, Model model2) {
        return Models.matchModels(model1, model2);
    }

    private static boolean matchModels(Model model1, Model model2) {
        ArrayList<Statement> model1BNodes = new ArrayList<Statement>(model1.size());
        for (Statement st : model1) {
            if (Models.isBlank(st.getSubject()) || Models.isBlank(st.getObject()) || Models.isBlank(st.getContext())) {
                model1BNodes.add(st);
                continue;
            }
            if (model2.contains(st)) continue;
            return false;
        }
        return Models.matchModels(model1BNodes, model2, new HashMap<Resource, Resource>(), 0);
    }

    private static boolean matchModels(List<? extends Statement> model1, Model model2, Map<Resource, Resource> bNodeMapping, int idx) {
        boolean result = false;
        if (idx < model1.size()) {
            Statement st1 = model1.get(idx);
            List<Statement> matchingStats = Models.findMatchingStatements(st1, model2, bNodeMapping);
            for (Statement st2 : matchingStats) {
                HashMap<Resource, Resource> newBNodeMapping = new HashMap<Resource, Resource>(bNodeMapping);
                if (Models.isBlank(st1.getSubject()) && Models.isBlank(st2.getSubject())) {
                    newBNodeMapping.put(st1.getSubject(), st2.getSubject());
                }
                if (Models.isBlank(st1.getObject()) && Models.isBlank(st2.getObject())) {
                    newBNodeMapping.put((Resource)st1.getObject(), (Resource)st2.getObject());
                }
                if (Models.isBlank(st1.getContext()) && Models.isBlank(st2.getContext())) {
                    newBNodeMapping.put(st1.getContext(), st2.getContext());
                }
                if (!(result = Models.matchModels(model1, model2, newBNodeMapping, idx + 1))) continue;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    private static List<Statement> findMatchingStatements(Statement st, Model model, Map<Resource, Resource> bNodeMapping) {
        Resource[] resourceArray;
        Value o;
        Resource s2 = Models.isBlank(st.getSubject()) ? null : st.getSubject();
        IRI p = st.getPredicate();
        Value value = o = Models.isBlank(st.getObject()) ? null : st.getObject();
        if (Models.isBlank(st.getContext())) {
            resourceArray = new Resource[]{};
        } else {
            Resource[] resourceArray2 = new Resource[1];
            resourceArray = resourceArray2;
            resourceArray2[0] = st.getContext();
        }
        Resource[] g2 = resourceArray;
        ArrayList<Statement> result = new ArrayList<Statement>();
        for (Statement modelSt : model.filter(s2, p, o, g2)) {
            if (!Models.statementsMatch(st, modelSt, bNodeMapping)) continue;
            result.add(modelSt);
        }
        return result;
    }

    private static boolean statementsMatch(Statement st1, Statement st2, Map<Resource, Resource> bNodeMapping) {
        Resource mappedBNode;
        Resource mappedBNode2;
        Resource mappedBNode3;
        IRI pred2;
        IRI pred1 = st1.getPredicate();
        if (!pred1.equals(pred2 = st2.getPredicate())) {
            return false;
        }
        Resource subj1 = st1.getSubject();
        Resource subj2 = st2.getSubject();
        if (Models.isBlank(subj1) && Models.isBlank(subj2) ? ((mappedBNode3 = bNodeMapping.get(subj1)) != null ? !subj2.equals(mappedBNode3) : bNodeMapping.containsValue(subj2)) : !subj1.equals(subj2)) {
            return false;
        }
        Value obj1 = st1.getObject();
        Value obj2 = st2.getObject();
        if (Models.isBlank(obj1) && Models.isBlank(obj2) ? ((mappedBNode2 = bNodeMapping.get(obj1)) != null ? !obj2.equals(mappedBNode2) : bNodeMapping.containsValue(obj2)) : !obj1.equals(obj2)) {
            return false;
        }
        Resource context1 = st1.getContext();
        Resource context2 = st2.getContext();
        if (context1 == null) {
            return context2 == null;
        }
        if (context2 == null) {
            return false;
        }
        return !(Models.isBlank(context1) && Models.isBlank(context2) ? ((mappedBNode = bNodeMapping.get(context1)) != null ? !context2.equals(mappedBNode) : bNodeMapping.containsValue(context2)) : !context1.equals(context1));
    }

    private static boolean isBlank(Value value) {
        if (value instanceof IRI) {
            return value.stringValue().indexOf("/.well-known/genid/") > 0;
        }
        return value instanceof BNode;
    }

    private static Model toModel(Iterable<? extends Statement> iterable) {
        Model set = null;
        if (iterable instanceof Model) {
            set = (Model)iterable;
        } else {
            set = new TreeModel();
            Iterators.addAll(iterable.iterator(), set);
        }
        return set;
    }

    public static Supplier<ModelException> modelException(String message) {
        return () -> new ModelException(message);
    }
}

