/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.ntriples;

import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class NTriplesUtil {
    public static Value parseValue(String nTriplesValue, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesValue.startsWith("<")) {
            return NTriplesUtil.parseURI(nTriplesValue, valueFactory);
        }
        if (nTriplesValue.startsWith("_:")) {
            return NTriplesUtil.parseBNode(nTriplesValue, valueFactory);
        }
        if (nTriplesValue.startsWith("\"")) {
            return NTriplesUtil.parseLiteral(nTriplesValue, valueFactory);
        }
        throw new IllegalArgumentException("Not a legal N-Triples value: " + nTriplesValue);
    }

    public static Resource parseResource(String nTriplesResource, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesResource.startsWith("<")) {
            return NTriplesUtil.parseURI(nTriplesResource, valueFactory);
        }
        if (nTriplesResource.startsWith("_:")) {
            return NTriplesUtil.parseBNode(nTriplesResource, valueFactory);
        }
        throw new IllegalArgumentException("Not a legal N-Triples resource: " + nTriplesResource);
    }

    public static URI parseURI(String nTriplesURI, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesURI.startsWith("<") && nTriplesURI.endsWith(">")) {
            String uri = nTriplesURI.substring(1, nTriplesURI.length() - 1);
            uri = NTriplesUtil.unescapeString(uri);
            return valueFactory.createURI(uri);
        }
        throw new IllegalArgumentException("Not a legal N-Triples URI: " + nTriplesURI);
    }

    public static BNode parseBNode(String nTriplesBNode, ValueFactory valueFactory) throws IllegalArgumentException {
        if (nTriplesBNode.startsWith("_:")) {
            return valueFactory.createBNode(nTriplesBNode.substring(2));
        }
        throw new IllegalArgumentException("Not a legal N-Triples URI: " + nTriplesBNode);
    }

    public static Literal parseLiteral(String nTriplesLiteral, ValueFactory valueFactory) throws IllegalArgumentException {
        int endLabelIdx;
        if (nTriplesLiteral.startsWith("\"") && (endLabelIdx = NTriplesUtil._findEndOfLabel(nTriplesLiteral)) != -1) {
            int startLangIdx = nTriplesLiteral.indexOf("@", endLabelIdx);
            int startDtIdx = nTriplesLiteral.indexOf("^^", endLabelIdx);
            if (startLangIdx != -1 && startDtIdx != -1) {
                throw new IllegalArgumentException("Literals can not have both a language and a datatype");
            }
            String label = nTriplesLiteral.substring(1, endLabelIdx);
            label = NTriplesUtil.unescapeString(label);
            if (startLangIdx != -1) {
                String language = nTriplesLiteral.substring(startLangIdx + 1);
                return valueFactory.createLiteral(label, language);
            }
            if (startDtIdx != -1) {
                String datatype = nTriplesLiteral.substring(startDtIdx + 2);
                URI dtURI = NTriplesUtil.parseURI(datatype, valueFactory);
                return valueFactory.createLiteral(label, dtURI);
            }
            return valueFactory.createLiteral(label);
        }
        throw new IllegalArgumentException("Not a legal N-Triples literal: " + nTriplesLiteral);
    }

    private static int _findEndOfLabel(String nTriplesLiteral) {
        boolean previousWasBackslash = false;
        for (int i = 1; i < nTriplesLiteral.length(); ++i) {
            char c = nTriplesLiteral.charAt(i);
            if (c == '\"' && !previousWasBackslash) {
                return i;
            }
            if (c == '\\' && !previousWasBackslash) {
                previousWasBackslash = true;
                continue;
            }
            if (!previousWasBackslash) continue;
            previousWasBackslash = false;
        }
        return -1;
    }

    public static String toNTriplesString(Value value) {
        if (value instanceof Resource) {
            return NTriplesUtil.toNTriplesString((Resource)value);
        }
        return NTriplesUtil.toNTriplesString((Literal)value);
    }

    public static String toNTriplesString(Resource resource) {
        if (resource instanceof URI) {
            return NTriplesUtil.toNTriplesString((URI)resource);
        }
        return NTriplesUtil.toNTriplesString((BNode)resource);
    }

    public static String toNTriplesString(URI uri) {
        return "<" + NTriplesUtil.escapeString(uri.getURI()) + ">";
    }

    public static String toNTriplesString(BNode bNode) {
        return "_:" + bNode.getID();
    }

    public static String toNTriplesString(Literal lit) {
        StringBuffer result = new StringBuffer(128);
        result.append("\"");
        result.append(NTriplesUtil.escapeString(lit.getLabel()));
        result.append("\"");
        if (lit.getDatatype() != null) {
            result.append("^^");
            result.append(NTriplesUtil.toNTriplesString(lit.getDatatype()));
        } else if (lit.getLanguage() != null) {
            result.append("@");
            result.append(lit.getLanguage());
        }
        return result.toString();
    }

    public static boolean isLetterOrNumber(int c) {
        return NTriplesUtil.isLetter(c) || NTriplesUtil.isNumber(c);
    }

    public static boolean isLetter(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122;
    }

    public static boolean isNumber(int c) {
        return c >= 48 && c <= 57;
    }

    public static String escapeString(String label) {
        int labelLength = label.length();
        StringBuffer result = new StringBuffer(2 * labelLength);
        for (int i = 0; i < labelLength; ++i) {
            char c;
            char cInt = c = label.charAt(i);
            if (c == '\\') {
                result.append("\\\\");
                continue;
            }
            if (c == '\"') {
                result.append("\\\"");
                continue;
            }
            if (c == '\n') {
                result.append("\\n");
                continue;
            }
            if (c == '\r') {
                result.append("\\r");
                continue;
            }
            if (c == '\t') {
                result.append("\\t");
                continue;
            }
            if (cInt >= '\u0000' && cInt <= '\b' || cInt == '\u000b' || cInt == '\f' || cInt >= '\u000e' && cInt <= '\u001f' || cInt >= '\u007f' && cInt <= '\uffff') {
                result.append("\\u");
                result.append(NTriplesUtil.toHexString(cInt, 4));
                continue;
            }
            if (cInt >= '\u10000' && cInt <= '\u10ffff') {
                result.append("\\U");
                result.append(NTriplesUtil.toHexString(cInt, 8));
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String unescapeString(String s2) {
        int backSlashIdx = s2.indexOf(92);
        if (backSlashIdx == -1) {
            return s2;
        }
        int startIdx = 0;
        int sLength = s2.length();
        StringBuffer buf = new StringBuffer(sLength);
        while (backSlashIdx != -1) {
            String xx;
            buf.append(s2.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s2);
            }
            char c = s2.charAt(backSlashIdx + 1);
            if (c == 't') {
                buf.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                buf.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                buf.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                buf.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                buf.append('\\');
                startIdx = backSlashIdx + 2;
            } else if (c == 'u') {
                if (backSlashIdx + 5 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s2);
                }
                xx = s2.substring(backSlashIdx + 2, backSlashIdx + 6);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    buf.append(c);
                    startIdx = backSlashIdx + 6;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + s2);
                }
            } else if (c == 'U') {
                if (backSlashIdx + 9 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s2);
                }
                xx = s2.substring(backSlashIdx + 2, backSlashIdx + 10);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    buf.append(c);
                    startIdx = backSlashIdx + 10;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + s2);
                }
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s2);
            }
            backSlashIdx = s2.indexOf(92, startIdx);
        }
        buf.append(s2.substring(startIdx));
        return buf.toString();
    }

    public static String toHexString(int decimal, int stringLength) {
        StringBuffer result = new StringBuffer(stringLength);
        String hexVal = Integer.toHexString(decimal).toUpperCase();
        int nofZeros = stringLength - hexVal.length();
        for (int i = 0; i < nofZeros; ++i) {
            result.append('0');
        }
        result.append(hexVal);
        return result.toString();
    }
}

