/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.rdfxml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Stack;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.rio.rdfxml.RdfXmlWriter;

public class AbbreviatedRdfXmlWriter
extends RdfXmlWriter {
    private Stack _subjectStack = new Stack();
    private Stack _predicateStack = new Stack();

    public AbbreviatedRdfXmlWriter(OutputStream out) {
        super(out);
    }

    public AbbreviatedRdfXmlWriter(Writer out) {
        super(out);
    }

    public void startDocument() throws IOException {
        if (this._writingStarted) {
            throw new RuntimeException("Document writing has already started");
        }
        this._setNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#", false);
        super.startDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDocument() throws IOException {
        if (!this._writingStarted) {
            throw new RuntimeException("Document writing has not yet started");
        }
        try {
            this.emptyStack(null);
            this._writeNewLine();
            this._writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
            this._out.flush();
        }
        finally {
            this._writingStarted = false;
        }
    }

    public void flush() throws IOException {
        if (!this._writingStarted) {
            throw new RuntimeException("Document writing has not yet started");
        }
        this.emptyStack(null);
        this._out.flush();
    }

    private void emptyStack(Resource subject) throws IOException {
        SubjectStackElement lastElement;
        for (int i = 0; i < this._subjectStack.size() - 1; ++i) {
            SubjectStackElement nextElement = (SubjectStackElement)this._subjectStack.get(i);
            if (nextElement.isWritten()) continue;
            if (i != 0) {
                this._writeIndents(i * 2 - 1);
                URI nextPredicate = (URI)this._predicateStack.get(i - 1);
                this._writeStartOfStartTag(nextPredicate.getNamespace(), nextPredicate.getLocalName());
                this._writeEndOfStartTag();
                this._writeNewLine();
            }
            this._writeIndents(i * 2);
            this._writeStartSubject(nextElement);
            nextElement.setIsWritten(true);
        }
        URI lastPredicate = null;
        if (this._predicateStack.size() > 0) {
            lastPredicate = (URI)this._predicateStack.pop();
        }
        if ((lastElement = (SubjectStackElement)this._subjectStack.pop()).getType() == null && lastPredicate != null) {
            this._writeIndents(this._subjectStack.size() * 2 - 1);
            this._writeAbbreviatedPredicate(lastPredicate, lastElement.getSubject());
        } else {
            if (lastPredicate != null) {
                this._writeIndents(this._subjectStack.size() * 2 - 1);
                this._writeStartOfStartTag(lastPredicate.getNamespace(), lastPredicate.getLocalName());
                this._writeEndOfStartTag();
                this._writeNewLine();
            }
            this._writeIndents(this._subjectStack.size() * 2);
            this._writeEmptySubject(lastElement);
            this._writeNewLine();
            if (lastPredicate != null) {
                this._writeIndents(this._subjectStack.size() * 2 - 1);
                this._writeEndTag(lastPredicate.getNamespace(), lastPredicate.getLocalName());
                this._writeNewLine();
            }
        }
        boolean foundSubject = false;
        while (this._subjectStack.size() > 0 && !foundSubject) {
            SubjectStackElement nextElement = this._peekSubjectStack(0);
            if (subject != null && subject.equals(nextElement.getSubject())) {
                foundSubject = true;
                continue;
            }
            this._subjectStack.pop();
            this._writeIndents(this._predicateStack.size() + this._subjectStack.size());
            this._writeEndSubject(nextElement);
            if (this._predicateStack.size() <= 0) continue;
            URI nextPredicate = (URI)this._predicateStack.pop();
            this._writeIndents(this._predicateStack.size() + this._subjectStack.size());
            this._writeEndTag(nextPredicate.getNamespace(), nextPredicate.getLocalName());
            this._writeNewLine();
        }
    }

    public void writeStatement(Resource subj, URI pred, Value obj) throws IOException {
        if (!this._writingStarted) {
            throw new RuntimeException("Document writing has not yet started");
        }
        SubjectStackElement top = null;
        if (this._subjectStack.size() > 0) {
            top = this._peekSubjectStack(0);
        }
        if (top != null && !subj.equals(top.getSubject())) {
            this.emptyStack(subj);
        }
        if (this._subjectStack.size() == 0) {
            this._subjectStack.push(new SubjectStackElement(subj));
        }
        top = this._peekSubjectStack(0);
        if (pred != null && ((Object)pred).equals(URIImpl.RDF_TYPE) && obj != null && obj instanceof URI) {
            if (top.getType() == null && !top.isWritten()) {
                top.setType((URI)obj);
            } else {
                this._predicateStack.push(pred);
                this._subjectStack.push(new SubjectStackElement(obj));
            }
        } else {
            this._predicateStack.push(pred);
            this._subjectStack.push(new SubjectStackElement(obj));
        }
    }

    private void _writeStartOfStartSubject(SubjectStackElement element) throws IOException {
        Value subj = element.getSubject();
        if (element.getType() != null) {
            this._writeStartOfStartTag(element.getType().getNamespace(), element.getType().getLocalName());
        } else {
            this._writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
        }
        if (subj instanceof BNode) {
            BNode bNode = (BNode)subj;
            this._writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", bNode.getID());
        } else {
            URI uri = (URI)subj;
            this._writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", uri.getURI());
        }
    }

    private void _writeStartSubject(SubjectStackElement element) throws IOException {
        this._writeStartOfStartSubject(element);
        this._writeEndOfStartTag();
        this._writeNewLine();
    }

    private void _writeEndSubject(SubjectStackElement element) throws IOException {
        if (element.getType() != null) {
            this._writeEndTag(element.getType().getNamespace(), element.getType().getLocalName());
        } else {
            this._writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
        }
        this._writeNewLine();
    }

    private void _writeEmptySubject(SubjectStackElement element) throws IOException {
        this._writeStartOfStartSubject(element);
        this._writeEndOfEmptyTag();
    }

    private void _writeAbbreviatedPredicate(URI pred, Value obj) throws IOException {
        this._writeStartOfStartTag(pred.getNamespace(), pred.getLocalName());
        if (obj instanceof Literal) {
            Literal objLit = (Literal)obj;
            if (objLit.getLanguage() != null) {
                this._writeAttribute("xml:lang", objLit.getLanguage());
            }
            boolean isXmlLiteral = false;
            URI datatype = objLit.getDatatype();
            if (datatype != null) {
                String datatypeString = datatype.getURI();
                isXmlLiteral = datatypeString.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
                if (isXmlLiteral) {
                    this._writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", "Literal");
                } else {
                    this._writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype", objLit.getDatatype().getURI());
                }
            }
            this._writeEndOfStartTag();
            if (isXmlLiteral) {
                this._out.write(objLit.getLabel());
            } else {
                this._writeCharacterData(objLit.getLabel());
            }
            this._writeEndTag(pred.getNamespace(), pred.getLocalName());
        } else {
            Resource objRes = (Resource)obj;
            if (objRes instanceof BNode) {
                BNode bNode = (BNode)objRes;
                this._writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", bNode.getID());
            } else {
                URI uri = (URI)objRes;
                this._writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", uri.getURI());
            }
            this._writeEndOfEmptyTag();
        }
        this._writeNewLine();
    }

    public void writeComment(String comment) throws IOException {
        if (this._subjectStack.size() > 0) {
            this.emptyStack(null);
        }
        this._out.write("<!-- ");
        this._out.write(comment);
        this._out.write(" -->");
        this._writeNewLine();
    }

    protected void _writeIndents(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this._writeIndent();
        }
    }

    private SubjectStackElement _peekSubjectStack(int distFromTop) {
        return (SubjectStackElement)this._subjectStack.get(this._subjectStack.size() - 1 - distFromTop);
    }

    static class SubjectStackElement {
        private Value _subject;
        private URI _type = null;
        private boolean _isWritten = false;

        public SubjectStackElement(Value subject) {
            this._subject = subject;
        }

        public Value getSubject() {
            return this._subject;
        }

        public void setType(URI type) {
            this._type = type;
        }

        public URI getType() {
            return this._type;
        }

        public void setIsWritten(boolean isWritten) {
            this._isWritten = isWritten;
        }

        public boolean isWritten() {
            return this._isWritten;
        }
    }
}

