/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.rdfxml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.util.xml.XmlUtil;

public class RdfXmlWriter
implements RdfDocumentWriter {
    protected Writer _out;
    protected Map _namespaceTable = new HashMap();
    protected Set _stylesheets = new HashSet();
    protected boolean _writingStarted = false;
    private Resource _lastWrittenSubject = null;

    public RdfXmlWriter(OutputStream out) {
        try {
            this._out = new OutputStreamWriter(out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public RdfXmlWriter(Writer out) {
        this._out = out;
    }

    public void setNamespace(String prefix, String name) {
        this._setNamespace(prefix, name, true);
    }

    protected void _setNamespace(String prefix, String name, boolean fixedPrefix) {
        if (this._writingStarted) {
            throw new RuntimeException("Namespaces cannot be set after writing has started");
        }
        if (!this._namespaceTable.containsKey(name)) {
            if (!this._namespaceTable.containsValue(prefix)) {
                this._namespaceTable.put(name, prefix);
            } else {
                if (fixedPrefix) {
                    throw new IllegalArgumentException("prefix already in use: " + prefix);
                }
                int number = 1;
                while (this._namespaceTable.containsValue(prefix + number)) {
                    ++number;
                }
                this._namespaceTable.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", prefix + number);
            }
        }
    }

    public void startDocument() throws IOException {
        if (this._writingStarted) {
            throw new RuntimeException("Document writing has already started");
        }
        this._setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#", false);
        this._writingStarted = true;
        this._out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        Iterator sheetIterator = this._stylesheets.iterator();
        while (sheetIterator.hasNext()) {
            StyleSheet nextSheet = (StyleSheet)sheetIterator.next();
            this._out.write("<?xml-stylesheet href=\"" + nextSheet.getHref() + "\" " + "type=\"" + nextSheet.getType() + "\" ");
            if (nextSheet.getTitle() != null && !nextSheet.getTitle().equals("")) {
                this._out.write("title=\"" + nextSheet.getTitle() + "\" ");
            }
            if (nextSheet.getMedia() != null && !nextSheet.getMedia().equals("")) {
                this._out.write("media=\"" + nextSheet.getMedia() + "\" ");
            }
            if (nextSheet.getCharset() != null && !nextSheet.getCharset().equals("")) {
                this._out.write("charset=\"" + nextSheet.getCharset() + "\" ");
            }
            if (nextSheet.isAlternate()) {
                this._out.write("alternate=\"yes\" ");
            }
            this._out.write("?>\n");
        }
        this._writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
        Iterator nameIterator = this._namespaceTable.keySet().iterator();
        while (nameIterator.hasNext()) {
            String name = (String)nameIterator.next();
            String prefix = (String)this._namespaceTable.get(name);
            this._writeNewLine();
            this._writeIndent();
            this._out.write("xmlns");
            if (prefix.length() > 0) {
                this._out.write(58);
                this._out.write(prefix);
            }
            this._out.write("=\"");
            this._out.write(XmlUtil.escapeDoubleQuotedAttValue(name));
            this._out.write("\"");
        }
        this._writeEndOfStartTag();
        this._writeNewLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDocument() throws IOException {
        if (!this._writingStarted) {
            throw new RuntimeException("Document writing has not yet started");
        }
        try {
            if (this._lastWrittenSubject != null) {
                this._writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
                this._writeNewLine();
                this._lastWrittenSubject = null;
            }
            this._writeNewLine();
            this._writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF");
            this._out.flush();
        }
        finally {
            this._writingStarted = false;
        }
    }

    public void writeStatement(Resource subj, URI pred, Value obj) throws IOException {
        if (!this._writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        if (!subj.equals(this._lastWrittenSubject)) {
            if (this._lastWrittenSubject != null) {
                this._writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
                this._writeNewLine();
            }
            this._writeNewLine();
            this._writeStartOfStartTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
            if (subj instanceof BNode) {
                BNode bNode = (BNode)subj;
                this._writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", bNode.getID());
            } else {
                URI uri = (URI)subj;
                this._writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about", uri.getURI());
            }
            this._writeEndOfStartTag();
            this._writeNewLine();
            this._lastWrittenSubject = subj;
        }
        this._writeIndent();
        this._writeStartOfStartTag(pred.getNamespace(), pred.getLocalName());
        if (obj instanceof Resource) {
            Resource objRes = (Resource)obj;
            if (objRes instanceof BNode) {
                BNode bNode = (BNode)objRes;
                this._writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "nodeID", bNode.getID());
            } else {
                URI uri = (URI)objRes;
                this._writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "resource", uri.getURI());
            }
            this._writeEndOfEmptyTag();
        } else if (obj instanceof Literal) {
            Literal objLit = (Literal)obj;
            if (objLit.getLanguage() != null) {
                this._writeAttribute("xml:lang", objLit.getLanguage());
            }
            boolean isXmlLiteral = false;
            URI datatype = objLit.getDatatype();
            if (datatype != null) {
                String datatypeString = datatype.getURI();
                isXmlLiteral = datatypeString.equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral");
                if (isXmlLiteral) {
                    this._writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "parseType", "Literal");
                } else {
                    this._writeAttribute("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype", objLit.getDatatype().getURI());
                }
            }
            this._writeEndOfStartTag();
            if (isXmlLiteral) {
                this._out.write(objLit.getLabel());
            } else {
                this._writeCharacterData(objLit.getLabel());
            }
            this._writeEndTag(pred.getNamespace(), pred.getLocalName());
        }
        this._writeNewLine();
    }

    public void writeComment(String comment) throws IOException {
        if (this._lastWrittenSubject != null) {
            this._writeEndTag("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "Description");
            this._writeNewLine();
            this._lastWrittenSubject = null;
        }
        this._out.write("<!-- ");
        this._out.write(comment);
        this._out.write(" -->");
        this._writeNewLine();
    }

    protected void _writeStartOfStartTag(String namespace, String localName) throws IOException {
        String prefix = (String)this._namespaceTable.get(namespace);
        if (prefix == null) {
            this._out.write("<");
            this._out.write(localName);
            this._out.write(" xmlns=\"");
            this._out.write(XmlUtil.escapeDoubleQuotedAttValue(namespace));
            this._out.write("\"");
        } else if (prefix.length() == 0) {
            this._out.write("<");
            this._out.write(localName);
        } else {
            this._out.write("<");
            this._out.write(prefix);
            this._out.write(":");
            this._out.write(localName);
        }
    }

    protected void _writeAttribute(String attName, String value) throws IOException {
        this._out.write(" ");
        this._out.write(attName);
        this._out.write("=\"");
        this._out.write(XmlUtil.escapeDoubleQuotedAttValue(value));
        this._out.write("\"");
    }

    protected void _writeAttribute(String namespace, String attName, String value) throws IOException {
        String prefix = (String)this._namespaceTable.get(namespace);
        if (prefix == null || prefix.length() == 0) {
            throw new RuntimeException("No prefix has been declared for the namespace used in this attribute: " + namespace);
        }
        this._out.write(" ");
        this._out.write(prefix);
        this._out.write(":");
        this._out.write(attName);
        this._out.write("=\"");
        this._out.write(XmlUtil.escapeDoubleQuotedAttValue(value));
        this._out.write("\"");
    }

    protected void _writeEndOfStartTag() throws IOException {
        this._out.write(">");
    }

    protected void _writeEndOfEmptyTag() throws IOException {
        this._out.write("/>");
    }

    protected void _writeEndTag(String namespace, String localName) throws IOException {
        String prefix = (String)this._namespaceTable.get(namespace);
        if (prefix == null || prefix.length() == 0) {
            this._out.write("</");
            this._out.write(localName);
            this._out.write(">");
        } else {
            this._out.write("</");
            this._out.write(prefix);
            this._out.write(":");
            this._out.write(localName);
            this._out.write(">");
        }
    }

    protected void _writeCharacterData(String chars) throws IOException {
        this._out.write(XmlUtil.escapeCharacterData(chars));
    }

    protected void _writeIndent() throws IOException {
        this._out.write("\t");
    }

    protected void _writeNewLine() throws IOException {
        this._out.write("\n");
    }

    public void addStyleSheet(String href, String type, String title, String media, String charset, boolean alternate) {
        if (this._writingStarted) {
            throw new RuntimeException("Stylesheets cannot be added after writing has started");
        }
        this._stylesheets.add(new StyleSheet(href, type, title, media, charset, alternate));
    }

    public void addStyleSheet(String href, String type) {
        this._stylesheets.add(new StyleSheet(href, type, null, null, null, false));
    }

    private static class StyleSheet {
        private String href = null;
        private String type = null;
        private String title = null;
        private String media = null;
        private String charset = null;
        private boolean alternate = false;

        public StyleSheet(String href, String type, String title, String media, String charset, boolean alternate) {
            if (href == null || type == null) {
                throw new NullPointerException("href and type must not be null");
            }
            this.href = href;
            this.type = type;
            this.title = title;
            this.media = media;
            this.charset = charset;
            this.alternate = alternate;
        }

        public boolean isAlternate() {
            return this.alternate;
        }

        public void setAlternate(boolean alternate) {
            this.alternate = alternate;
        }

        public String getCharset() {
            return this.charset;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public String getHref() {
            return this.href;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public String getMedia() {
            return this.media;
        }

        public void setMedia(String media) {
            this.media = media;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

