/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.turtle;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.rio.turtle.TurtleUtil;

public class TurtleWriter
implements RdfDocumentWriter {
    private Writer _out;
    private Map _namespaceTable = new HashMap();
    private boolean _writingStarted = false;
    private boolean _statementClosed = true;
    private Resource _lastWrittenSubject = null;
    private URI _lastWrittenPredicate = null;

    protected TurtleWriter() {
    }

    public TurtleWriter(OutputStream out) {
        this();
        try {
            this._out = new OutputStreamWriter(out, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public TurtleWriter(Writer out) {
        this();
        this._out = out;
    }

    public void setNamespace(String prefix, String name) throws IOException {
        if (!this._namespaceTable.containsKey(name)) {
            this._namespaceTable.put(name, prefix);
            if (this._writingStarted) {
                this._closePreviousStatement();
                this._writeNamespace(prefix, name);
                this._writeNewLine();
            }
        }
    }

    public void startDocument() throws IOException {
        if (this._writingStarted) {
            throw new RuntimeException("Document writing has already started");
        }
        this._writingStarted = true;
        Iterator nameIterator = this._namespaceTable.keySet().iterator();
        while (nameIterator.hasNext()) {
            String name = (String)nameIterator.next();
            String prefix = (String)this._namespaceTable.get(name);
            this._writeNamespace(prefix, name);
        }
        if (!this._namespaceTable.isEmpty()) {
            this._writeNewLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDocument() throws IOException {
        if (!this._writingStarted) {
            throw new RuntimeException("Document writing has not yet started");
        }
        try {
            this._closePreviousStatement();
            this._out.flush();
        }
        finally {
            this._writingStarted = false;
        }
    }

    public void writeStatement(Resource subj, URI pred, Value obj) throws IOException {
        if (!this._writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        if (subj.equals(this._lastWrittenSubject)) {
            if (((Object)pred).equals(this._lastWrittenPredicate)) {
                this._out.write(" , ");
            } else {
                this._out.write(" ;");
                this._writeNewLine();
                this._writeIndent();
                this._writePredicate(pred);
                this._out.write(" ");
                this._lastWrittenPredicate = pred;
            }
        } else {
            this._closePreviousStatement();
            this._writeResource(subj);
            this._out.write(" ");
            this._lastWrittenSubject = subj;
            this._writePredicate(pred);
            this._out.write(" ");
            this._lastWrittenPredicate = pred;
            this._statementClosed = false;
        }
        this._writeValue(obj);
    }

    public void writeComment(String comment) throws IOException {
        this._closePreviousStatement();
        if (comment.indexOf(13) != -1 || comment.indexOf(10) != -1) {
            StringTokenizer st = new StringTokenizer(comment, "\r\n");
            while (st.hasMoreTokens()) {
                this._writeCommentLine(st.nextToken());
            }
        } else {
            this._writeCommentLine(comment);
        }
    }

    private void _writeNamespace(String prefix, String name) throws IOException {
        this._out.write("@prefix ");
        this._out.write(prefix);
        this._out.write(": <");
        this._out.write(TurtleUtil.encodeURIString(name));
        this._out.write("> .");
        this._writeNewLine();
    }

    private void _writeCommentLine(String line) throws IOException {
        this._out.write("# ");
        this._out.write(line);
        this._writeNewLine();
    }

    private void _writePredicate(URI predicate) throws IOException {
        if (predicate.getURI().equals("http://www.w3.org/1999/02/22-rdf-syntax-ns#type")) {
            this._out.write("a");
        } else {
            this._writeURI(predicate);
        }
    }

    private void _writeValue(Value val) throws IOException {
        if (val instanceof Resource) {
            this._writeResource((Resource)val);
        } else {
            this._writeLiteral((Literal)val);
        }
    }

    private void _writeResource(Resource res) throws IOException {
        if (res instanceof URI) {
            this._writeURI((URI)res);
        } else {
            this._writeBNode((BNode)res);
        }
    }

    private void _writeURI(URI uri) throws IOException {
        String namespace = uri.getNamespace();
        String localName = uri.getLocalName();
        String prefix = (String)this._namespaceTable.get(namespace);
        if (prefix != null && TurtleUtil.isLegalName(localName)) {
            this._out.write(prefix);
            this._out.write(":");
            this._out.write(localName);
        } else {
            this._out.write("<");
            this._out.write(TurtleUtil.encodeURIString(uri.getURI()));
            this._out.write(">");
        }
    }

    private void _writeBNode(BNode bNode) throws IOException {
        this._out.write("_:");
        this._out.write(bNode.getID());
    }

    private void _writeLiteral(Literal lit) throws IOException {
        if (lit.getLabel().indexOf(10) >= 0 || lit.getLabel().indexOf(13) >= 0 || lit.getLabel().indexOf(9) >= 0) {
            this._out.write("\"\"\"");
            this._out.write(TurtleUtil.encodeLongString(lit.getLabel()));
            this._out.write("\"\"\"");
        } else {
            this._out.write("\"");
            this._out.write(TurtleUtil.encodeString(lit.getLabel()));
            this._out.write("\"");
        }
        if (lit.getDatatype() != null) {
            this._out.write("^^");
            this._writeURI(lit.getDatatype());
        } else if (lit.getLanguage() != null) {
            this._out.write("@");
            this._out.write(lit.getLanguage());
        }
    }

    private void _writeIndent() throws IOException {
        this._out.write("\t");
    }

    private void _writeNewLine() throws IOException {
        this._out.write("\n");
    }

    private void _closePreviousStatement() throws IOException {
        if (!this._statementClosed) {
            this._out.write(" .");
            this._writeNewLine();
            this._writeNewLine();
            this._statementClosed = true;
            this._lastWrittenSubject = null;
            this._lastWrittenPredicate = null;
        }
    }
}

