/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.admin;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.util.xml.XmlUtil;

public class HtmlAdminMsgWriter
implements AdminListener {
    protected OutputStream _responseStream;
    protected PrintWriter _out;
    private boolean _transactionStarted;

    public HtmlAdminMsgWriter(OutputStream responseStream) throws IOException {
        this._responseStream = responseStream;
        this._out = new PrintWriter(new OutputStreamWriter(responseStream, "UTF-8"));
        this._transactionStarted = false;
    }

    public void transactionStart() {
        if (this._transactionStarted) {
            return;
        }
        this._out.println("<html>");
        this._out.println("<head>");
        this._out.println("<title>Transaction status</title>");
        this._out.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
        this._out.println("</head>");
        this._out.println("<body bgcolor=\"white\">");
        this._out.println("<pre>");
        this._out.println("<font color=\"black\"><b>Transaction started...</b></font>");
        this._out.flush();
        this._transactionStarted = true;
    }

    public void transactionEnd() {
        if (!this._transactionStarted) {
            return;
        }
        this._out.println();
        this._out.println("<font color=\"black\"><b>Transaction finished</b></font>");
        this._out.println("</pre>");
        this._out.println("</html>");
        this._out.flush();
        this._transactionStarted = false;
    }

    public void status(String msg, int lineNo, int colNo) {
        this._out.println();
        this._out.print("<font size=\"-1\" color=\"black\">");
        this._out.print("Status");
        this._printLineAndColumn(lineNo, colNo);
        this._out.println(":</font>");
        this._out.print("<font color=\"black\"><b>");
        if (msg != null) {
            this._out.print(XmlUtil.escapeCharacterData(msg));
        } else {
            this._out.print("(unspecified)");
        }
        this._out.println("</b></font>");
        this._out.flush();
    }

    public void notification(String msg, int lineNo, int colNo, Statement statement) {
        this._out.println();
        this._out.print("<font size=\"-1\" color=\"green\">");
        this._out.print("Notification");
        this._printLineAndColumn(lineNo, colNo);
        this._out.println(":</font>");
        this._out.print("<font color=\"green\"><b>");
        if (msg != null) {
            this._out.print(XmlUtil.escapeCharacterData(msg));
        } else {
            this._out.print("(unspecified)");
        }
        this._out.println("</b></font>");
        this._dumpStatement(statement);
        this._out.flush();
    }

    public void warning(String msg, int lineNo, int colNo, Statement statement) {
        this._out.println();
        this._out.print("<font size=\"-1\" color=\"orange\">");
        this._out.print("Warning");
        this._printLineAndColumn(lineNo, colNo);
        this._out.println(":</font>");
        this._out.print("<font color=\"orange\"><b>");
        if (msg != null) {
            this._out.print(XmlUtil.escapeCharacterData(msg));
        } else {
            this._out.print("(unspecified)");
        }
        this._out.println("</b></font>");
        this._dumpStatement(statement);
        this._out.flush();
    }

    public void error(String msg, int lineNo, int colNo, Statement statement) {
        this._out.println();
        this._out.print("<font size=\"-1\" color=\"red\">");
        this._out.print("Error");
        this._printLineAndColumn(lineNo, colNo);
        this._out.println(":</font>");
        this._out.print("<font color=\"red\"><b>");
        if (msg != null) {
            this._out.print(XmlUtil.escapeCharacterData(msg));
        } else {
            this._out.print("(unspecified)");
        }
        this._out.println("</b></font>");
        this._dumpStatement(statement);
        this._out.flush();
    }

    private void _printLineAndColumn(int lineNo, int colNo) {
        if (lineNo != -1) {
            this._out.print("[line=" + lineNo);
            if (colNo != -1) {
                this._out.print("; column=" + colNo);
            }
            this._out.print("]");
        }
    }

    private void _dumpStatement(Statement statement) {
        if (statement != null) {
            Resource subject = statement.getSubject();
            this._argLine("\tsubject   : " + XmlUtil.escapeCharacterData(subject.toString()));
            URI predicate = statement.getPredicate();
            this._argLine("\tpredicate : " + XmlUtil.escapeCharacterData(predicate.toString()));
            Value object = statement.getObject();
            if (object instanceof Literal) {
                this._argLine("\tobject    : <i>" + XmlUtil.escapeCharacterData(object.toString()) + "</i>");
            } else {
                this._argLine("\tobject    : " + XmlUtil.escapeCharacterData(object.toString()));
            }
        }
    }

    private void _argLine(String msg) {
        this._out.print("<font size=\"-1\" color=\"black\">");
        this._out.print(msg);
        this._out.println("</font>");
    }
}

