/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.rql.model.ClassQuery;
import org.openrdf.sesame.query.rql.model.ClassVar;
import org.openrdf.sesame.query.rql.model.Selector;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;

public class ClassSelector
implements Selector {
    protected ClassVar _classVar;
    protected ClassQuery _classQ;
    protected ResourceIterator _classQIter;
    protected boolean _classVarLocked;

    public ClassSelector(ClassVar classVar, ClassQuery classQ) {
        if (classQ instanceof ClassVar) {
            throw new IllegalArgumentException("classQ must not be an instance of ClassVar");
        }
        this._classVar = classVar;
        this._classQ = classQ;
    }

    public void initialize(RdfSchemaSource rss) throws QueryEvaluationException {
        this._classQIter = this._classQ.getClasses(rss);
        this._classVarLocked = this._classVar.getValue() != null;
    }

    public boolean selectNext(RdfSchemaSource rss) throws QueryEvaluationException {
        if (this._classVarLocked) {
            Value classVarValue = this._classVar.getValue();
            boolean result = false;
            while (this._classQIter.hasNext()) {
                Resource classQValue = (Resource)this._classQIter.next();
                if (classVarValue instanceof Resource) {
                    if (!classVarValue.equals(classQValue)) continue;
                    result = true;
                    continue;
                }
                result = false;
            }
            return result;
        }
        if (this._classQIter.hasNext()) {
            Resource classQValue = (Resource)this._classQIter.next();
            this._classVar.setValue(classQValue);
            return true;
        }
        this._classVar.setValue(null);
        return false;
    }

    public void clear() {
        if (this._classQIter != null) {
            this._classQIter.close();
            if (!this._classVarLocked) {
                this._classVar.setValue(null);
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("(");
        result.append(this._classQ.toString());
        result.append("{");
        result.append(this._classVar.toString());
        result.append("})");
        return result.toString();
    }
}

