/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.util.Iterator;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.rql.model.ClassQuery;
import org.openrdf.sesame.query.rql.model.ClassVar;
import org.openrdf.sesame.query.rql.model.Intersection;
import org.openrdf.sesame.query.rql.model.PropertyQuery;
import org.openrdf.sesame.query.rql.model.PropertyVar;
import org.openrdf.sesame.query.rql.model.Selector;
import org.openrdf.sesame.query.rql.model.iterators.StatementSubjectIterator;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;

public class DomainSelector
implements Selector {
    protected ClassQuery _domainQ;
    protected PropertyQuery _propQ;
    protected ResourceIterator _domainIter;
    protected ResourceIterator _propIter;
    protected boolean _domainQisVar;
    protected boolean _propQisVar;

    public DomainSelector(ClassQuery domainQ, PropertyQuery propQ) {
        this._domainQ = domainQ;
        this._propQ = propQ;
    }

    public void initialize(RdfSchemaSource rss) throws QueryEvaluationException {
        this._domainQisVar = this._domainQ instanceof ClassVar && !((ClassVar)this._domainQ).hasValue();
        this._propIter = this._propQ.getProperties(rss);
        boolean bl = this._propQisVar = this._propIter == null;
        if (this._propIter == null) {
            this._propIter = new StatementSubjectIterator(rss.getProperties());
        }
    }

    public boolean selectNext(RdfSchemaSource rss) throws QueryEvaluationException {
        if (this._domainQisVar) {
            if ((this._domainIter == null || !this._domainIter.hasNext()) && this._propIter.hasNext()) {
                URI property = (URI)this._propIter.next();
                Intersection intersect = new Intersection(rss.getDomain(property, null));
                Value propDomain = intersect.minimize(rss);
                if (propDomain instanceof Intersection) {
                    ((ClassVar)this._domainQ).setValue(propDomain);
                } else if (propDomain instanceof Resource) {
                    this._domainIter = new StatementSubjectIterator(rss.getSubClassOf(null, (Resource)propDomain));
                    if (this._domainIter.hasNext()) {
                        ((ClassVar)this._domainQ).setValue(this._domainIter.next());
                    }
                }
                if (this._propQisVar) {
                    ((PropertyVar)this._propQ).setValue(property);
                }
                return true;
            }
            if (this._domainIter != null && this._domainIter.hasNext()) {
                Resource subClass = (Resource)this._domainIter.next();
                ((ClassVar)this._domainQ).setValue(subClass);
                return true;
            }
            ((ClassVar)this._domainQ).setValue(null);
            if (this._propQisVar) {
                ((PropertyVar)this._propQ).setValue(null);
            }
            return false;
        }
        boolean result = false;
        while (this._propIter.hasNext()) {
            URI property = (URI)this._propIter.next();
            if (this._propQisVar) {
                ((PropertyVar)this._propQ).setValue(property);
            }
            Intersection intersect = new Intersection(rss.getDomain(property, null));
            Value propDomain = intersect.minimize(rss);
            this._domainIter = this._domainQ.getClasses(rss);
            while (this._domainIter.hasNext()) {
                Value nextDomain = this._domainIter.next();
                if (nextDomain.equals(propDomain)) {
                    result = true;
                    break;
                }
                if (propDomain instanceof Intersection) {
                    if (nextDomain instanceof Intersection) {
                        result = ((Intersection)nextDomain).lowerEqualThan((Intersection)propDomain, rss);
                        if (!result) continue;
                        break;
                    }
                    if (!(nextDomain instanceof Resource)) continue;
                    Iterator intersectIter = ((Intersection)propDomain).getMembers().iterator();
                    Resource member = null;
                    boolean mismatch = false;
                    while (intersectIter.hasNext()) {
                        member = (Resource)intersectIter.next();
                        if (rss.isSubClassOf((Resource)nextDomain, member)) continue;
                        mismatch = true;
                        break;
                    }
                    if (mismatch) continue;
                    result = true;
                    break;
                }
                if (nextDomain instanceof Intersection) {
                    Intersection myIntersection = new Intersection();
                    myIntersection.add((Resource)propDomain);
                    result = ((Intersection)nextDomain).lowerEqualThan(myIntersection, rss);
                    if (!result) continue;
                    break;
                }
                if (!(nextDomain instanceof Resource) || !(propDomain instanceof Resource) || !rss.isSubClassOf((Resource)nextDomain, (Resource)propDomain)) continue;
                result = true;
                break;
            }
            this._domainIter.close();
            if (!result) continue;
            if (!this._propQisVar) {
                this._propIter.close();
            }
            return true;
        }
        if (this._domainQisVar) {
            ((ClassVar)this._domainQ).setValue(null);
        }
        if (this._propQisVar) {
            ((PropertyVar)this._propQ).setValue(null);
        }
        return false;
    }

    public void clear() {
        if (this._propIter != null) {
            this._propIter.close();
            if (this._domainIter != null) {
                this._domainIter.close();
            }
            if (this._domainQisVar) {
                ((ClassVar)this._domainQ).setValue(null);
            }
            if (this._propQisVar) {
                ((PropertyVar)this._propQ).setValue(null);
            }
            this._propIter = null;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{:");
        result.append(this._domainQ.toString());
        result.append("}");
        result.append(this._propQ.toString());
        return result.toString();
    }
}

