/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.rql.model.ClassQuery;
import org.openrdf.sesame.query.rql.model.ClassVar;
import org.openrdf.sesame.query.rql.model.DataVar;
import org.openrdf.sesame.query.rql.model.Intersection;
import org.openrdf.sesame.query.rql.model.Selector;
import org.openrdf.sesame.query.rql.model.iterators.StatementSubjectIterator;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.ValueIterator;

public class InstanceSelector
implements Selector {
    protected DataVar _dataVar;
    protected ClassQuery _classQ;
    protected ResourceIterator _classIter;
    protected ValueIterator _instIter;
    protected StatementIterator _statIter;
    protected boolean _firstIteration;
    protected boolean _dataVarLocked;
    protected boolean _classQisVar;
    protected boolean _properInstances;

    public InstanceSelector(DataVar dataVar, ClassQuery classQ) {
        this(dataVar, classQ, false);
    }

    public InstanceSelector(DataVar dataVar, ClassQuery classQ, boolean properInstances) {
        this._dataVar = dataVar;
        this._classQ = classQ;
        this._properInstances = properInstances;
    }

    public void initialize(RdfSchemaSource rss) throws QueryEvaluationException {
        this._classIter = this._classQ.getClasses(rss);
        this._classQisVar = this._classIter == null;
        this._dataVarLocked = this._dataVar.hasValue();
        this._firstIteration = true;
    }

    public boolean selectNext(RdfSchemaSource rss) throws QueryEvaluationException {
        Value dataValue = this._dataVar.getValue();
        if (this._classQisVar) {
            if (dataValue instanceof Literal) {
                if (this._firstIteration) {
                    ((ClassVar)this._classQ).setValue(URIImpl.RDFS_LITERAL);
                    this._firstIteration = false;
                    return true;
                }
                ((ClassVar)this._classQ).setValue(null);
                return false;
            }
            Resource dataRes = (Resource)dataValue;
            if (this._statIter == null) {
                this._statIter = this._properInstances ? rss.getDirectType(dataRes, null) : rss.getType(dataRes, null);
            }
            while (this._statIter.hasNext()) {
                Statement stat = this._statIter.next();
                if (!(stat.getObject() instanceof Resource)) continue;
                ((ClassVar)this._classQ).setValue(stat.getObject());
                if (!this._dataVarLocked) {
                    this._dataVar.setValue(stat.getSubject());
                }
                return true;
            }
            this._statIter.close();
            ((ClassVar)this._classQ).setValue(null);
            if (!this._dataVarLocked) {
                this._dataVar.setValue(null);
            }
            return false;
        }
        if (this._dataVarLocked) {
            boolean isInstance = false;
            while (this._classIter.hasNext() && !isInstance) {
                Resource classRes = this._classIter.nextResource();
                isInstance = this._isInstanceOf(dataValue, classRes, rss);
            }
            this._classIter.close();
            return isInstance;
        }
        if (this._instIter == null || !this._instIter.hasNext()) {
            if (this._instIter != null) {
                this._instIter.close();
            }
            while (this._classIter.hasNext()) {
                Resource classRes = this._classIter.nextResource();
                this._instIter = classRes.equals(URIImpl.RDFS_LITERAL) ? rss.getLiterals(null, null, null) : (classRes instanceof Intersection ? ((Intersection)classRes).getInstances(rss) : (this._properInstances ? new StatementSubjectIterator(rss.getDirectType(null, classRes)) : new StatementSubjectIterator(rss.getType(null, classRes))));
                if (this._instIter.hasNext()) break;
                this._instIter.close();
            }
        }
        if (this._instIter != null && this._instIter.hasNext()) {
            this._dataVar.setValue(this._instIter.next());
            return true;
        }
        this._dataVar.setValue(null);
        return false;
    }

    private boolean _isInstanceOf(Value dataValue, Resource classRes, RdfSchemaSource rss) {
        boolean result = false;
        if (dataValue instanceof Literal) {
            result = classRes.equals(URIImpl.RDFS_LITERAL);
        } else {
            Resource dataRes = (Resource)dataValue;
            if (classRes instanceof Intersection) {
                Intersection intersect = (Intersection)classRes;
                result = intersect.containsInstance(dataRes, rss);
            } else {
                result = this._properInstances ? rss.isDirectType(dataRes, classRes) : rss.isType(dataRes, classRes);
            }
        }
        return result;
    }

    public void clear() {
        if (this._classIter != null) {
            this._classIter.close();
            this._classIter = null;
        }
        if (this._statIter != null) {
            this._statIter.close();
            this._statIter = null;
        }
        if (!this._dataVarLocked) {
            this._dataVar.setValue(null);
            this._dataVarLocked = true;
        }
        if (this._classQisVar) {
            ((ClassVar)this._classQ).setValue(null);
            this._classQisVar = false;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{");
        result.append(this._dataVar.toString());
        result.append(" : ");
        if (this._properInstances) {
            result.append("^");
        }
        result.append(this._classQ.toString());
        result.append("}");
        return result.toString();
    }
}

