/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.io.IOException;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.ClassQuery;
import org.openrdf.sesame.query.rql.model.DataQuery;
import org.openrdf.sesame.query.rql.model.PropertyQuery;
import org.openrdf.sesame.query.rql.model.iterators.StatementSubjectIterator;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.ValueIterator;
import org.openrdf.sesame.sail.util.SingleResourceIterator;

public class URI
implements PropertyQuery,
ClassQuery,
DataQuery {
    protected org.openrdf.model.URI _uri;

    public URI(String uri) {
        this._uri = new URIImpl(uri);
    }

    public URI(org.openrdf.model.URI uri) {
        this._uri = uri;
    }

    public String getQuery() {
        return this._uri.getLocalName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(RdfSchemaSource rss, TableQueryResultListener listener) throws QueryEvaluationException {
        try {
            if (rss.isClass(this._uri)) {
                String[] columnHeaders = new String[]{this.getQuery()};
                listener.startTableQueryResult(columnHeaders);
                StatementIterator iter = rss.getType(null, this._uri);
                try {
                    while (iter.hasNext()) {
                        listener.startTuple();
                        listener.tupleValue(iter.next().getSubject());
                        listener.endTuple();
                    }
                }
                finally {
                    iter.close();
                }
            } else if (rss.isProperty(this._uri)) {
                String[] columnHeaders = new String[]{"source of \"" + this.getQuery() + "\"", "target of \"" + this.getQuery() + "\""};
                listener.startTableQueryResult(columnHeaders);
                StatementIterator iter = rss.getStatements(null, this._uri, null);
                try {
                    while (iter.hasNext()) {
                        Statement st = iter.next();
                        listener.startTuple();
                        listener.tupleValue(st.getSubject());
                        listener.tupleValue(st.getObject());
                        listener.endTuple();
                    }
                }
                finally {
                    iter.close();
                }
            } else {
                String[] columnHeaders = new String[]{this.getQuery()};
                listener.startTableQueryResult(columnHeaders);
                listener.startTuple();
                listener.tupleValue(this._uri);
                listener.endTuple();
            }
            listener.endTableQueryResult();
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
    }

    public ValueIterator getResources(RdfSchemaSource rss) {
        return new SingleResourceIterator(this._uri);
    }

    public ResourceIterator getClasses(RdfSchemaSource rss) {
        return new SingleResourceIterator(this._uri);
    }

    public ResourceIterator getProperties(RdfSchemaSource rss) {
        return new SingleResourceIterator(this._uri);
    }

    public ValueIterator getInstances(RdfSchemaSource rss) {
        if (rss.isClass(this._uri)) {
            StatementIterator statIter = rss.getType(null, this._uri);
            return new StatementSubjectIterator(statIter);
        }
        return new SingleResourceIterator(this._uri);
    }

    public boolean returnsSet() {
        return false;
    }

    public Value getValue() {
        return this._uri;
    }

    public String toString() {
        return this._uri.getURI();
    }
}

