/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.sail.query.ValueExpr;
import org.openrdf.util.xml.XmlDatatypeUtil;

public class MathExpr
implements ValueExpr {
    public static final int PLUS = 0;
    public static final int SUBTRACT = 1;
    public static final int MULTIPLY = 2;
    public static final int DIVIDE = 3;
    public static final int REMAINDER = 4;
    private static final URI XSD_INTEGER_URI = new URIImpl("http://www.w3.org/2001/XMLSchema#integer");
    private static final URI XSD_DOUBLE_URI = new URIImpl("http://www.w3.org/2001/XMLSchema#double");
    private ValueExpr _leftArg;
    private ValueExpr _rightArg;
    private int _operator;

    public MathExpr(ValueExpr leftArg, ValueExpr rightArg, int op) {
        if (op < 0 || op > 4) {
            throw new IllegalArgumentException("Illegal operator: " + op);
        }
        this._leftArg = leftArg;
        this._rightArg = rightArg;
        this._operator = op;
    }

    public ValueExpr getLeftArg() {
        return this._leftArg;
    }

    public ValueExpr getRightArg() {
        return this._rightArg;
    }

    public int getOperator() {
        return this._operator;
    }

    public void getVariables(Collection variables) {
        this._leftArg.getVariables(variables);
        this._rightArg.getVariables(variables);
    }

    public String getString() {
        Value value = this.getValue();
        if (value != null) {
            return ((Literal)value).getLabel();
        }
        return null;
    }

    public Value getValue() {
        Value leftVal = this._leftArg.getValue();
        Value rightVal = this._rightArg.getValue();
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            return MathExpr.getValue((Literal)leftVal, (Literal)rightVal, this._operator);
        }
        return null;
    }

    public static Literal getValue(Literal leftLit, Literal rightLit, int op) {
        String rightLabel;
        String leftLabel;
        block19: {
            leftLabel = leftLit.getLabel();
            URI leftDatatype = leftLit.getDatatype();
            rightLabel = rightLit.getLabel();
            URI rightDatatype = rightLit.getDatatype();
            if (leftDatatype == null || XmlDatatypeUtil.isIntegerDatatype(leftDatatype.getURI()) && rightDatatype == null || XmlDatatypeUtil.isIntegerDatatype(rightDatatype.getURI())) {
                try {
                    BigInteger leftInt = new BigInteger(leftLabel);
                    BigInteger rightInt = new BigInteger(rightLabel);
                    BigInteger result = null;
                    switch (op) {
                        case 0: {
                            result = leftInt.add(rightInt);
                            break;
                        }
                        case 1: {
                            result = leftInt.subtract(rightInt);
                            break;
                        }
                        case 2: {
                            result = leftInt.multiply(rightInt);
                            break;
                        }
                        case 3: {
                            result = leftInt.divide(rightInt);
                            break;
                        }
                        case 4: {
                            result = leftInt.remainder(rightInt);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown operator: " + op);
                        }
                    }
                    return new LiteralImpl(result.toString(), XSD_INTEGER_URI);
                }
                catch (NumberFormatException e) {
                    if (leftDatatype == null || rightDatatype == null) break block19;
                    return null;
                }
            }
        }
        try {
            BigDecimal leftDec = new BigDecimal(leftLabel);
            BigDecimal rightDec = new BigDecimal(rightLabel);
            BigDecimal result = null;
            switch (op) {
                case 0: {
                    result = leftDec.add(rightDec);
                    break;
                }
                case 1: {
                    result = leftDec.subtract(rightDec);
                    break;
                }
                case 2: {
                    result = leftDec.multiply(rightDec);
                    break;
                }
                case 3: {
                    result = leftDec.divide(rightDec, 32, 1);
                    break;
                }
                case 4: {
                    return null;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operator: " + op);
                }
            }
            return new LiteralImpl(result.toString(), XSD_DOUBLE_URI);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(32);
        buf.append(this._leftArg.toString());
        switch (this._operator) {
            case 0: {
                buf.append(" + ");
                break;
            }
            case 1: {
                buf.append(" - ");
                break;
            }
            case 2: {
                buf.append(" * ");
                break;
            }
            case 3: {
                buf.append(" / ");
                break;
            }
            case 4: {
                buf.append(" % ");
            }
        }
        buf.append(this._rightArg.toString());
        return buf.toString();
    }
}

