/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.util.Collection;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.query.BooleanExpr;
import org.openrdf.sesame.sail.query.BooleanExprEvaluationException;
import org.openrdf.sesame.sail.query.ValueExpr;
import org.openrdf.util.xml.XmlDatatypeUtil;

public class ValueCompare
implements BooleanExpr {
    public static final int EQ = 1;
    public static final int NE = 2;
    public static final int LT = 3;
    public static final int LE = 4;
    public static final int GE = 5;
    public static final int GT = 6;
    private ValueExpr _leftArg;
    private ValueExpr _rightArg;
    private int _operator;

    public ValueCompare(ValueExpr leftArg, ValueExpr rightArg) {
        this(leftArg, rightArg, 1);
    }

    public ValueCompare(ValueExpr leftArg, ValueExpr rightArg, int op) {
        if (op < 1 || op > 6) {
            throw new IllegalArgumentException("Illegal operator value: " + op);
        }
        this._leftArg = leftArg;
        this._rightArg = rightArg;
        this._operator = op;
    }

    public ValueExpr getLeftArg() {
        return this._leftArg;
    }

    public ValueExpr getRightArg() {
        return this._rightArg;
    }

    public int getOperator() {
        return this._operator;
    }

    public void getVariables(Collection variables) {
        this._leftArg.getVariables(variables);
        this._rightArg.getVariables(variables);
    }

    public boolean isTrue(RdfSource rdfSource) throws BooleanExprEvaluationException {
        Value leftVal = this._leftArg.getValue();
        Value rightVal = this._rightArg.getValue();
        return ValueCompare.isTrue(leftVal, rightVal, this._operator);
    }

    public static boolean isTrue(Value leftVal, Value rightVal, int operator) throws BooleanExprEvaluationException {
        boolean result = false;
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            result = ValueCompare._compareLiterals((Literal)leftVal, (Literal)rightVal, operator);
        } else {
            switch (operator) {
                case 1: {
                    result = ValueCompare._valuesEqual(leftVal, rightVal);
                    break;
                }
                case 2: {
                    result = !ValueCompare._valuesEqual(leftVal, rightVal);
                    break;
                }
                default: {
                    throw new BooleanExprEvaluationException("Only literals with compatible, ordered datatypes can be compared using <, <=, > and >= operators");
                }
            }
        }
        return result;
    }

    private static boolean _valuesEqual(Value leftVal, Value rightVal) {
        boolean result = false;
        result = leftVal == null ? rightVal == null : leftVal.equals(rightVal);
        return result;
    }

    private static boolean _compareLiterals(Literal leftLit, Literal rightLit, int operator) throws BooleanExprEvaluationException {
        String leftLabel = leftLit.getLabel();
        String leftLang = leftLit.getLanguage();
        URI leftDatatype = leftLit.getDatatype();
        String rightLabel = rightLit.getLabel();
        String rightLang = rightLit.getLanguage();
        URI rightDatatype = rightLit.getDatatype();
        if (leftDatatype == null && rightDatatype != null) {
            leftDatatype = rightDatatype;
        } else if (rightDatatype == null && leftDatatype != null) {
            rightDatatype = leftDatatype;
        } else if (rightDatatype != null && leftDatatype != null && !((Object)leftDatatype).equals(rightDatatype) && XmlDatatypeUtil.isDecimalDatatype(rightDatatype.getURI()) && XmlDatatypeUtil.isDecimalDatatype(leftDatatype.getURI())) {
            leftDatatype = rightDatatype = new URIImpl("http://www.w3.org/2001/XMLSchema#decimal");
        }
        boolean result = false;
        if (leftDatatype != null && ((Object)leftDatatype).equals(rightDatatype) && XmlDatatypeUtil.isOrderedDatatype(leftDatatype.getURI())) {
            try {
                int compareTo = XmlDatatypeUtil.compare(leftLabel, rightLabel, leftDatatype.getURI());
                switch (operator) {
                    case 3: {
                        result = compareTo < 0;
                        break;
                    }
                    case 4: {
                        result = compareTo <= 0;
                        break;
                    }
                    case 1: {
                        result = compareTo == 0;
                        break;
                    }
                    case 2: {
                        result = compareTo != 0;
                        break;
                    }
                    case 5: {
                        result = compareTo >= 0;
                        break;
                    }
                    case 6: {
                        result = compareTo > 0;
                        break;
                    }
                    default: {
                        throw new BooleanExprEvaluationException("Unknown operator value: " + operator);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new BooleanExprEvaluationException(e.getMessage());
            }
        } else if ((leftDatatype == null && leftLang == null || leftDatatype != null && leftDatatype.getURI().equals("http://www.w3.org/2001/XMLSchema#string")) && (rightDatatype == null && rightLang == null || rightDatatype != null && rightDatatype.getURI().equals("http://www.w3.org/2001/XMLSchema#string"))) {
            int compareTo = leftLabel.compareTo(rightLabel);
            switch (operator) {
                case 3: {
                    result = compareTo < 0;
                    break;
                }
                case 4: {
                    result = compareTo <= 0;
                    break;
                }
                case 1: {
                    result = compareTo == 0;
                    break;
                }
                case 2: {
                    result = compareTo != 0;
                    break;
                }
                case 5: {
                    result = compareTo >= 0;
                    break;
                }
                case 6: {
                    result = compareTo > 0;
                    break;
                }
                default: {
                    throw new BooleanExprEvaluationException("Unknown operator value: " + operator);
                }
            }
        } else {
            switch (operator) {
                case 1: {
                    result = ((Object)leftLit).equals(rightLit);
                    break;
                }
                case 2: {
                    result = !((Object)leftLit).equals(rightLit);
                    break;
                }
                default: {
                    throw new BooleanExprEvaluationException("Only literals with compatible, ordered datatypes can be compared using <, <=, > and >= operators");
                }
            }
        }
        return result;
    }

    public static String operator2string(int op) {
        switch (op) {
            case 1: {
                return "=";
            }
            case 2: {
                return "!=";
            }
            case 3: {
                return "<";
            }
            case 4: {
                return "<=";
            }
            case 5: {
                return ">";
            }
            case 6: {
                return ">=";
            }
        }
        throw new IllegalArgumentException("Illegal operator value: " + op);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(32);
        buf.append('(');
        buf.append(this._leftArg.toString());
        buf.append(' ');
        buf.append(ValueCompare.operator2string(this._operator));
        buf.append(' ');
        buf.append(this._rightArg.toString());
        buf.append(')');
        return buf.toString();
    }
}

