/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.nativerdf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.openrdf.sesame.sail.SailInitializationException;
import org.openrdf.sesame.sailimpl.nativerdf.btree.BTree;
import org.openrdf.sesame.sailimpl.nativerdf.btree.BTreeIterator;
import org.openrdf.sesame.sailimpl.nativerdf.btree.BTreeValueComparator;
import org.openrdf.util.ByteArrayUtil;
import org.openrdf.util.log.ThreadLog;

public class TripleStore {
    private static final String PROPERTIES_FILE = "triples.prop";
    private static final String VERSION_KEY = "version";
    private static final String INDEXES_KEY = "triple-indexes";
    private static final int SCHEME_VERSION = 1;
    private static final String OLD_IDX_FILE = "triples.dat";
    static final int RECORD_LENGTH = 13;
    static final int SUBJ_IDX = 0;
    static final int PRED_IDX = 4;
    static final int OBJ_IDX = 8;
    static final int FLAG_IDX = 12;
    static final byte EXPLICIT_FLAG = 1;
    private File _dir;
    private Properties _properties;
    private TripleIndex[] _indexes;

    public TripleStore(File dir, String indexSpecStr) throws IOException, SailInitializationException {
        this._dir = dir;
        this._properties = new Properties();
        File propFile = new File(dir, PROPERTIES_FILE);
        if (propFile.exists()) {
            this._loadProperties(propFile);
        } else {
            File oldIndexFile = new File(dir, OLD_IDX_FILE);
            if (oldIndexFile.exists()) {
                File spoFile = this._getIndexFile("spo");
                if (!spoFile.exists()) {
                    ThreadLog.log("Updating old triple indexing scheme...");
                    oldIndexFile.renameTo(spoFile);
                }
                this._properties.setProperty(VERSION_KEY, String.valueOf(1));
                this._properties.setProperty(INDEXES_KEY, "spo");
            }
        }
        Set indexSpecs = this._parseIndexSpecList(indexSpecStr);
        if (indexSpecs.isEmpty()) {
            ThreadLog.log("No indexes specified, defaulting to single spo index");
            indexSpecs.add("spo");
            indexSpecStr = "spo";
        }
        this._reindex(indexSpecs);
        this._properties.setProperty(VERSION_KEY, String.valueOf(1));
        this._properties.setProperty(INDEXES_KEY, indexSpecStr);
        this._storeProperties(propFile);
        this._indexes = new TripleIndex[indexSpecs.size()];
        int i = 0;
        Iterator iter = indexSpecs.iterator();
        while (iter.hasNext()) {
            String fieldSeq = (String)iter.next();
            ThreadLog.trace("Activating index '" + fieldSeq + "'...");
            this._indexes[i++] = new TripleIndex(fieldSeq);
        }
    }

    private Set _parseIndexSpecList(String indexSpecStr) throws SailInitializationException {
        HashSet<String> indexes = new HashSet<String>();
        if (indexSpecStr != null) {
            StringTokenizer tok = new StringTokenizer(indexSpecStr, ", \t");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken().toLowerCase();
                if (index.length() != 3 || index.indexOf(115) == -1 || index.indexOf(112) == -1 || index.indexOf(111) == -1) {
                    throw new SailInitializationException("invalid value '" + index + "' in index specification: " + indexSpecStr);
                }
                indexes.add(index);
            }
        }
        return indexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _reindex(Set newIndexSpecs) throws IOException, SailInitializationException {
        String currentIndexSpecStr = this._properties.getProperty(INDEXES_KEY);
        if (currentIndexSpecStr == null) {
            return;
        }
        Set currentIndexSpecs = this._parseIndexSpecList(currentIndexSpecStr);
        if (currentIndexSpecs.isEmpty()) {
            throw new SailInitializationException("Invalid index specification found in index properties");
        }
        HashSet addedIndexSpecs = new HashSet(newIndexSpecs);
        addedIndexSpecs.removeAll(currentIndexSpecs);
        if (!addedIndexSpecs.isEmpty()) {
            String sourceIndexSpec = (String)currentIndexSpecs.iterator().next();
            TripleIndex sourceIndex = new TripleIndex(sourceIndexSpec);
            try {
                Iterator fieldSeqIter = addedIndexSpecs.iterator();
                while (fieldSeqIter.hasNext()) {
                    String fieldSeq = (String)fieldSeqIter.next();
                    ThreadLog.trace("Initializing new index '" + fieldSeq + "'...");
                    TripleIndex addedIndex = new TripleIndex(fieldSeq);
                    BTree addedBTree = addedIndex.getBTree();
                    addedBTree.startTransaction();
                    BTreeIterator sourceIter = sourceIndex.getBTree().iterateAll();
                    try {
                        byte[] value = null;
                        while ((value = sourceIter.next()) != null) {
                            addedBTree.insert(value);
                        }
                    }
                    finally {
                        sourceIter.close();
                    }
                    addedBTree.commitTransaction();
                    addedBTree.close();
                }
                ThreadLog.trace("New index(es) initialized");
            }
            finally {
                sourceIndex.getBTree().close();
            }
        }
        HashSet removedIndexSpecs = new HashSet(currentIndexSpecs);
        removedIndexSpecs.removeAll(newIndexSpecs);
        Iterator iter = removedIndexSpecs.iterator();
        while (iter.hasNext()) {
            String fieldSeq = (String)iter.next();
            boolean deleted = this._getIndexFile(fieldSeq).delete();
            if (deleted) {
                ThreadLog.trace("Deleted file for removed " + fieldSeq + " index");
                continue;
            }
            ThreadLog.warning("Unable to delete file for removed " + fieldSeq + " index");
        }
    }

    public void close() throws IOException {
        for (int i = 0; i < this._indexes.length; ++i) {
            this._indexes[i].getBTree().close();
        }
        this._indexes = null;
    }

    public BTreeIterator getTriples(int subj, int pred, int obj) throws IOException {
        int bestScore = -1;
        TripleIndex bestIndex = null;
        for (int i = 0; i < this._indexes.length; ++i) {
            int score = this._indexes[i].getPatternScore(subj, pred, obj);
            if (score <= bestScore) continue;
            bestScore = score;
            bestIndex = this._indexes[i];
        }
        byte[] searchKey = this._getSearchKey(subj, pred, obj);
        byte[] searchMask = this._getSearchMask(subj, pred, obj);
        if (bestScore > 0) {
            byte[] minValue = this._getMinValue(subj, pred, obj);
            byte[] maxValue = this._getMaxValue(subj, pred, obj);
            return bestIndex.getBTree().iterateValues(searchKey, searchMask, minValue, maxValue);
        }
        return bestIndex.getBTree().iterateValues(searchKey, searchMask);
    }

    public void startTransaction() throws IOException {
        for (int i = 0; i < this._indexes.length; ++i) {
            this._indexes[i].getBTree().startTransaction();
        }
    }

    public void commitTransaction() throws IOException {
        for (int i = 0; i < this._indexes.length; ++i) {
            this._indexes[i].getBTree().commitTransaction();
        }
    }

    public void rollbackTransaction() throws IOException {
        throw new IOException("transaction rollback not implemented yet");
    }

    public void clear() throws IOException {
        for (int i = 0; i < this._indexes.length; ++i) {
            this._indexes[i].getBTree().clear();
        }
    }

    public byte[] storeTriple(int subj, int pred, int obj) throws IOException {
        byte[] data = this._getData(subj, pred, obj);
        byte[] oldData = this._indexes[0].getBTree().insert(data);
        if (oldData == null || !Arrays.equals(data, oldData)) {
            for (int i = 1; i < this._indexes.length; ++i) {
                this._indexes[i].getBTree().insert(data);
            }
        }
        return oldData;
    }

    public int removeTriples(int subj, int pred, int obj) throws IOException {
        ArrayList<byte[]> removeList = new ArrayList<byte[]>();
        BTreeIterator iter = this.getTriples(subj, pred, obj);
        byte[] value = iter.next();
        while (value != null) {
            removeList.add(value);
            value = iter.next();
        }
        for (int i = 0; i < this._indexes.length; ++i) {
            BTree btree = this._indexes[i].getBTree();
            for (int j = 0; j < removeList.size(); ++j) {
                btree.remove((byte[])removeList.get(j));
            }
        }
        return removeList.size();
    }

    private byte[] _getData(int subj, int pred, int obj) {
        byte[] data = new byte[13];
        ByteArrayUtil.putInt(subj, data, 0);
        ByteArrayUtil.putInt(pred, data, 4);
        ByteArrayUtil.putInt(obj, data, 8);
        data[12] = 1;
        return data;
    }

    private byte[] _getSearchKey(int subj, int pred, int obj) {
        byte[] searchKey = this._getData(subj, pred, obj);
        searchKey[12] = 0;
        return searchKey;
    }

    private byte[] _getSearchMask(int subj, int pred, int obj) {
        byte[] mask = new byte[13];
        if (subj != 0) {
            ByteArrayUtil.putInt(-1, mask, 0);
        }
        if (pred != 0) {
            ByteArrayUtil.putInt(-1, mask, 4);
        }
        if (obj != 0) {
            ByteArrayUtil.putInt(-1, mask, 8);
        }
        return mask;
    }

    private byte[] _getMinValue(int subj, int pred, int obj) {
        byte[] minValue = new byte[13];
        ByteArrayUtil.putInt(subj, minValue, 0);
        ByteArrayUtil.putInt(pred, minValue, 4);
        ByteArrayUtil.putInt(obj, minValue, 8);
        return minValue;
    }

    private byte[] _getMaxValue(int subj, int pred, int obj) {
        byte[] maxValue = new byte[13];
        ByteArrayUtil.putInt(subj == 0 ? -1 : subj, maxValue, 0);
        ByteArrayUtil.putInt(pred == 0 ? -1 : pred, maxValue, 4);
        ByteArrayUtil.putInt(obj == 0 ? -1 : obj, maxValue, 8);
        return maxValue;
    }

    private File _getIndexFile(String fieldSeq) {
        return new File(this._dir, "triples-" + fieldSeq + ".dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadProperties(File propFile) throws IOException {
        FileInputStream in = new FileInputStream(propFile);
        try {
            this._properties.clear();
            this._properties.load(in);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _storeProperties(File propFile) throws IOException {
        FileOutputStream out = new FileOutputStream(propFile);
        try {
            this._properties.store(out, "triple indexes meta-data, DO NOT EDIT!");
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    private static class TripleComparator
    implements BTreeValueComparator {
        private String _fieldSeq;

        public TripleComparator(String fieldSeq) {
            this._fieldSeq = fieldSeq;
        }

        public final int compareBTreeValues(byte[] key, byte[] data, int offset, int length) {
            int result = 0;
            block5: for (int i = 0; result == 0 && i < this._fieldSeq.length(); ++i) {
                switch (this._fieldSeq.charAt(i)) {
                    case 's': {
                        result = ByteArrayUtil.compareRegion(key, 0, data, offset + 0, 4);
                        continue block5;
                    }
                    case 'p': {
                        result = ByteArrayUtil.compareRegion(key, 4, data, offset + 4, 4);
                        continue block5;
                    }
                    case 'o': {
                        result = ByteArrayUtil.compareRegion(key, 8, data, offset + 8, 4);
                        continue block5;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid character '" + this._fieldSeq.charAt(i) + "' in field sequence: " + this._fieldSeq);
                    }
                }
            }
            return result;
        }
    }

    private class TripleIndex {
        private String _fieldSeq;
        private File _file;
        private BTree _btree;

        public TripleIndex(String fieldSeq) throws IOException {
            this._fieldSeq = fieldSeq;
            this._file = TripleStore.this._getIndexFile(fieldSeq);
            this._btree = new BTree(this._file, 2048, 13, new TripleComparator(this._fieldSeq));
        }

        public String getFieldSeq() {
            return this._fieldSeq;
        }

        public File getFile() {
            return this._file;
        }

        public BTree getBTree() {
            return this._btree;
        }

        public int getPatternScore(int subj, int pred, int obj) {
            int score = 0;
            for (int i = 0; i < this._fieldSeq.length(); ++i) {
                char field = this._fieldSeq.charAt(i);
                if (field == 's') {
                    if (subj == 0) break;
                    ++score;
                    continue;
                }
                if (field == 'p') {
                    if (pred == 0) break;
                    ++score;
                    continue;
                }
                if (field != 'o') continue;
                if (obj == 0) break;
                ++score;
            }
            return score;
        }
    }
}

