/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms.iterators;

import java.sql.Connection;
import java.sql.SQLException;
import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.LiteralIterator;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sailimpl.rdbms.RdfSource;
import org.openrdf.sesame.sailimpl.rdbms.iterators.RdbmsValueIterator;
import org.openrdf.sesame.sailimpl.rdbms.model.IdLiteral;
import org.openrdf.sesame.sailimpl.rdbms.model.IdURI;

public class RdbmsLiteralIterator
extends RdbmsValueIterator
implements LiteralIterator {
    public RdbmsLiteralIterator(RdfSource source, String[] namespaceNames, Connection databaseCon, String query) {
        super(source, namespaceNames, databaseCon, query);
    }

    protected Value getResult() {
        try {
            int id = this._resultSet.getInt(1);
            int dtId = this._resultSet.getInt(2);
            String label = this._resultSet.getString(6);
            if (label == null) {
                label = "";
            }
            if (dtId != 0) {
                int dtNsId = this._resultSet.getInt(3);
                String dtLname = this._resultSet.getString(4);
                if (dtLname == null) {
                    dtLname = "";
                }
                IdURI datatype = new IdURI(this._source, this._namespaceNames[dtNsId], dtLname, dtId);
                return new IdLiteral(this._source, label, datatype, id);
            }
            String lang = this._resultSet.getString(5);
            if (lang != null) {
                return new IdLiteral(this._source, label, lang, id);
            }
            return new IdLiteral(this._source, label, id);
        }
        catch (SQLException e) {
            throw new SailInternalException(e);
        }
    }

    public Literal nextLiteral() {
        return (Literal)this.next();
    }
}

