/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.HtmlAdminMsgWriter;
import org.openrdf.sesame.admin.XmlAdminMsgWriter;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.constants.AdminResultFormat;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.repository.remote.HTTPErrorType;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.HTTPOutputStream;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

public class ClearRepositoryServlet
extends SesameServlet {
    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (HttpServerUtil.isMultipartFormRequest(request)) {
            this._handleMultipartFormRequest(request, response);
        } else {
            this._handleFormURLEncodedRequest(request, response);
        }
    }

    private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String repository = HttpServerUtil.getParameter(request, "repository");
        String resultFormatStr = HttpServerUtil.getParameter(request, "resultFormat", AdminResultFormat.XML.toString());
        this._handleRequest(request, response, repository, resultFormatStr);
    }

    private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map fileItemMap = HttpServerUtil.parseMultipartFormRequest(request);
        String repository = HttpServerUtil.getParameter(fileItemMap, "repository");
        String resultFormatStr = HttpServerUtil.getParameter(fileItemMap, "resultFormat", AdminResultFormat.XML.toString());
        this._handleRequest(request, response, repository, resultFormatStr);
    }

    /*
     * WARNING - void declaration
     */
    private void _handleRequest(HttpServletRequest request, HttpServletResponse response, String repository, String resultFormatStr) throws IOException {
        void var7_7;
        AdminListener report;
        SesameServer.setThreadLogFileForRepository(repository);
        this._logIP(request);
        ThreadLog.log(">>> clear repository");
        ThreadLog.trace("repository = " + repository);
        ThreadLog.trace("resultFormat = " + resultFormatStr);
        if (repository == null) {
            this._sendBadRequest("No repository specified", response);
            return;
        }
        HTTPOutputStream httpOut = new HTTPOutputStream(response);
        httpOut.setCacheableResult(false);
        AdminResultFormat resultFormat = AdminResultFormat.forValue(resultFormatStr);
        if (resultFormat == AdminResultFormat.XML) {
            httpOut.setContentType("text/xml");
            report = new XmlAdminMsgWriter(httpOut);
        } else if (resultFormat == AdminResultFormat.HTML) {
            httpOut.setContentType("text/html");
            report = new HtmlAdminMsgWriter(httpOut);
        } else {
            this._sendBadRequest("Unknown result format: " + resultFormatStr, response);
            return;
        }
        try {
            LocalService service = SesameServer.getLocalService();
            this._login(service);
            SesameRepository rep = service.getRepository(repository);
            long startTime = System.currentTimeMillis();
            rep.clear((AdminListener)var7_7);
            long endTime = System.currentTimeMillis();
            ThreadLog.trace("Repository " + repository + " cleared in " + (endTime - startTime) + "ms");
        }
        catch (UnknownRepositoryException e) {
            this._sendBadRequest(HTTPErrorType.UNKNOWN_REPOSITORY, "Unknown repository", response);
        }
        catch (AccessDeniedException e) {
            this._sendForbidden("Access denied", response);
        }
        catch (Exception e) {
            ThreadLog.error("Error while clearing repository", e);
            var7_7.error("Error while clearing repository: " + e.getMessage(), -1, -1, null);
        }
    }
}

