/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.sesame.config.RepositoryListWriter;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.HTTPOutputStream;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

public class ListRepositoriesServlet
extends SesameServlet {
    protected void _doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SesameServer.setThreadLogFile("list-repositories.log");
        this._logIP(request);
        ThreadLog.log(">>> list repositories");
        try {
            LocalService service = SesameServer.getLocalService();
            this._login(service);
            HTTPOutputStream httpOut = new HTTPOutputStream(response, "text/xml");
            httpOut.setUseGZIPCompression(HttpServerUtil.acceptsGZIPEncoding(request));
            httpOut.setCacheableResult(false);
            RepositoryListWriter repListWriter = new RepositoryListWriter();
            repListWriter.write(service.getRepositoryList(), httpOut);
            httpOut.close();
        }
        catch (IOException e) {
            ThreadLog.warning("I/O error, client connection closed?: " + e.getMessage());
        }
        catch (Exception e) {
            this._sendInternalError("The server generated an error; Please inform the server administrator", e, response);
        }
    }
}

