/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.omm.SessionContext;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

public class LoginServlet
extends SesameServlet {
    private static long FAILURE_DELAY = 3000L;
    private static String FAILURE_MSG_KEY = "loginFailedMsg";

    protected void _doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this._handleFormURLEncodedRequest(request, response);
    }

    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (HttpServerUtil.isMultipartFormRequest(request)) {
            this._handleMultipartFormRequest(request, response);
        } else {
            this._handleFormURLEncodedRequest(request, response);
        }
    }

    private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String user = HttpServerUtil.getParameter(request, "user");
        String password = HttpServerUtil.getParameter(request, "password");
        String successPage = HttpServerUtil.getParameter(request, "successPage");
        String failurePage = HttpServerUtil.getParameter(request, "failurePage");
        this._handleRequest(request, response, user, password, successPage, failurePage);
    }

    private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map fileItemMap = HttpServerUtil.parseMultipartFormRequest(request);
        String user = HttpServerUtil.getParameter(fileItemMap, "user");
        String password = HttpServerUtil.getParameter(fileItemMap, "password");
        String successPage = HttpServerUtil.getParameter(fileItemMap, "successPage");
        String failurePage = HttpServerUtil.getParameter(fileItemMap, "failurePage");
        this._handleRequest(request, response, user, password, successPage, failurePage);
    }

    private void _handleRequest(HttpServletRequest request, HttpServletResponse response, String user, String password, String successPage, String failurePage) throws IOException {
        SesameServer.setThreadLogFile("login.log");
        this._logIP(request);
        ThreadLog.log(">>> login");
        ThreadLog.trace("user = " + user);
        ThreadLog.trace("password set = " + (password != null));
        ThreadLog.trace("successPage = " + successPage);
        ThreadLog.trace("failurePage = " + failurePage);
        HttpServerUtil.setNoCacheHeaders(response);
        if (user == null) {
            String errMsg = "user parameter is missing";
            request.getSession().setAttribute(FAILURE_MSG_KEY, (Object)errMsg);
            this._sendBadRequest(errMsg, response);
            return;
        }
        try {
            SesameServer.getLocalService().login(user, password);
            HttpSession session = request.getSession();
            SessionContext.put(session.getId(), SessionContext.getContext());
            Cookie sessionCookie = new Cookie("sesame_sid", session.getId());
            sessionCookie.setPath(request.getContextPath() + "/");
            response.addCookie(sessionCookie);
            session.removeAttribute(FAILURE_MSG_KEY);
            ThreadLog.trace("User '" + user + "' logged in");
            if (successPage != null) {
                response.sendRedirect(request.getContextPath() + successPage);
            } else {
                response.setStatus(200);
                response.setContentType("text/plain");
                PrintWriter writer = response.getWriter();
                writer.write("Logged in successfully");
                writer.close();
            }
        }
        catch (AccessDeniedException e) {
            String errMsg = e.getMessage();
            if (errMsg == null) {
                errMsg = "Access denied";
            }
            request.getSession().setAttribute(FAILURE_MSG_KEY, (Object)errMsg);
            ThreadLog.trace("Login failed: " + errMsg);
            try {
                Thread.sleep(FAILURE_DELAY);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            if (failurePage != null) {
                response.sendRedirect(request.getContextPath() + failurePage);
            }
            this._sendForbidden(errMsg, response);
        }
    }
}

