/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.rio.n3.N3Writer;
import org.openrdf.rio.ntriples.NTriplesWriter;
import org.openrdf.rio.rdfxml.RdfXmlWriter;
import org.openrdf.rio.turtle.TurtleWriter;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.repository.remote.HTTPErrorType;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.HTTPOutputStream;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

public class RdfExtractionServlet
extends SesameServlet {
    protected void _doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this._handleFormURLEncodedRequest(request, response);
    }

    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (HttpServerUtil.isMultipartFormRequest(request)) {
            this._handleMultipartFormRequest(request, response);
        } else {
            this._handleFormURLEncodedRequest(request, response);
        }
    }

    private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String repository = HttpServerUtil.getParameter(request, "repository");
        String schema = HttpServerUtil.getParameter(request, "schema", "off");
        String data = HttpServerUtil.getParameter(request, "data", "off");
        String explicitOnly = HttpServerUtil.getParameter(request, "explicitOnly", "off");
        String niceOutput = HttpServerUtil.getParameter(request, "niceOutput", "off");
        String serialization = HttpServerUtil.getParameter(request, "serialization", RDFFormat.RDFXML.toString());
        this._handleRequest(request, response, repository, schema, data, explicitOnly, niceOutput, serialization);
    }

    private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map fileItemMap = HttpServerUtil.parseMultipartFormRequest(request);
        String repository = HttpServerUtil.getParameter(fileItemMap, "repository");
        String schema = HttpServerUtil.getParameter(fileItemMap, "schema", "off");
        String data = HttpServerUtil.getParameter(fileItemMap, "data", "off");
        String explicitOnly = HttpServerUtil.getParameter(fileItemMap, "explicitOnly", "off");
        String niceOutput = HttpServerUtil.getParameter(fileItemMap, "niceOutput", "off");
        String serialization = HttpServerUtil.getParameter(fileItemMap, "serialization", RDFFormat.RDFXML.toString());
        this._handleRequest(request, response, repository, schema, data, explicitOnly, niceOutput, serialization);
    }

    private void _handleRequest(HttpServletRequest request, HttpServletResponse response, String repository, String schema, String data, String explicitOnly, String niceOutput, String serialization) throws IOException {
        OutputStreamWriter out;
        SesameServer.setThreadLogFileForRepository(repository);
        this._logIP(request);
        ThreadLog.log(">>> extract RDF");
        ThreadLog.trace("repository = " + repository);
        ThreadLog.trace("schema = " + schema);
        ThreadLog.trace("data = " + data);
        ThreadLog.trace("explicitOnly = " + explicitOnly);
        ThreadLog.trace("niceOutput = " + niceOutput);
        ThreadLog.trace("serialization = " + serialization);
        if (repository == null) {
            this._sendBadRequest("No repository specified", response);
            return;
        }
        boolean exportSchema = schema.equals("on");
        boolean exportData = data.equals("on");
        boolean explicit = explicitOnly.equals("on");
        boolean nice = niceOutput.equals("on");
        HTTPOutputStream httpOut = new HTTPOutputStream(response);
        httpOut.setCacheableResult(false);
        httpOut.setUseGZIPCompression(HttpServerUtil.acceptsGZIPEncoding(request));
        RdfDocumentWriter rdfDocWriter = null;
        RDFFormat rdfFormat = RDFFormat.forValue(serialization);
        if (rdfFormat == RDFFormat.RDFXML) {
            httpOut.setContentType("application/rdf+xml; charset=utf-8");
            out = new OutputStreamWriter((OutputStream)httpOut, "UTF-8");
            rdfDocWriter = new RdfXmlWriter(out);
        } else if (rdfFormat == RDFFormat.NTRIPLES) {
            httpOut.setContentType("text/plain");
            out = new OutputStreamWriter((OutputStream)httpOut, "UTF-8");
            rdfDocWriter = new NTriplesWriter(out);
        } else if (rdfFormat == RDFFormat.N3) {
            httpOut.setContentType("text/rdf+n3");
            out = new OutputStreamWriter((OutputStream)httpOut, "UTF-8");
            rdfDocWriter = new N3Writer(out);
        } else if (rdfFormat == RDFFormat.TURTLE) {
            httpOut.setContentType("application/x-turtle");
            out = new OutputStreamWriter((OutputStream)httpOut, "UTF-8");
            rdfDocWriter = new TurtleWriter(out);
        } else {
            this._sendBadRequest("Unknown serialization: " + serialization, response);
            return;
        }
        try {
            LocalService service = SesameServer.getLocalService();
            this._login(service);
            LocalRepository rep = (LocalRepository)service.getRepository(repository);
            long startTime = System.currentTimeMillis();
            rep.extractRDF(rdfDocWriter, exportSchema, exportData, explicit, nice);
            httpOut.close();
            long endTime = System.currentTimeMillis();
            ThreadLog.trace("RDF exported in " + (endTime - startTime) + "ms");
        }
        catch (UnknownRepositoryException e) {
            this._sendBadRequest(HTTPErrorType.UNKNOWN_REPOSITORY, "Unknown repository: " + repository, response);
        }
        catch (AccessDeniedException e) {
            this._sendForbidden("Access denied: " + e.getMessage(), response);
        }
        catch (IOException e) {
            ThreadLog.warning("I/O error, client connection closed?: " + e.getMessage());
        }
        catch (Exception e) {
            this._sendInternalError("Unknown error on exporting RDF from repository " + repository, e, response);
        }
    }
}

