/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.omm.SessionContext;
import org.openrdf.sesame.omm.VersionManagement;
import org.openrdf.sesame.repository.local.LocalRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.repository.remote.HTTPErrorType;
import org.openrdf.sesame.sail.SailUtil;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;

public class SelectBranch
extends SesameServlet {
    protected void _doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this._handleFormURLEncodedRequest(request, response);
    }

    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (HttpServerUtil.isMultipartFormRequest(request)) {
            this._handleMultipartFormRequest(request, response);
        } else {
            this._handleFormURLEncodedRequest(request, response);
        }
    }

    private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uidStr = HttpServerUtil.getParameter(request, "uid");
        this._handleRequest(request, response, uidStr);
    }

    private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map fileItemMap = HttpServerUtil.parseMultipartFormRequest(request);
        String uidStr = HttpServerUtil.getParameter(fileItemMap, "uid");
        this._handleRequest(request, response, uidStr);
    }

    private void _handleRequest(HttpServletRequest request, HttpServletResponse response, String uidStr) throws IOException {
        HttpServerUtil.setNoCacheHeaders(response);
        int uid = Integer.parseInt(uidStr);
        SessionContext sc = SessionContext.getContext();
        int usid = sc.userID;
        try {
            LocalService service = SesameServer.getLocalService();
            this._login(service);
            LocalRepository rep = (LocalRepository)service.getRepository(sc.repository);
            Class<?> vmClass = Class.forName("org.openrdf.sesame.omm.VersionManagement");
            VersionManagement vsail = (VersionManagement)SailUtil.findSailInStack(rep.getSail(), vmClass);
            if (vsail != null) {
                vsail.branchState(usid);
                response.sendRedirect(request.getContextPath() + "/actionFrameset.jsp?repository=" + sc.repository);
            }
        }
        catch (ClassNotFoundException e) {
            this._sendInternalError("Class VersionManagement not found", e, response);
        }
        catch (AccessDeniedException e) {
            this._sendForbidden(e.getMessage(), response);
        }
        catch (ConfigurationException e) {
            this._sendBadRequest(e.getMessage(), response);
        }
        catch (UnknownRepositoryException e) {
            this._sendBadRequest(HTTPErrorType.UNKNOWN_REPOSITORY, e.getMessage(), response);
        }
    }
}

