/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.omm.SessionContext;
import org.openrdf.sesame.omm.SessionKilled;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.repository.remote.HTTPErrorType;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.util.log.ThreadLog;

public abstract class SesameServlet
extends HttpServlet {
    protected static final String SESSIONID = "sesame_sid";

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        this._init(config);
        SesameServer.unsetThreadLogFile();
    }

    protected void _init(ServletConfig config) throws ServletException {
    }

    public final void destroy() {
        this._destroy();
        SesameServer.unsetThreadLogFile();
        super.destroy();
    }

    protected void _destroy() {
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        SesameServlet.setSessionContext(request);
        this._doGet(request, response);
        SesameServlet.unsetSessionContext();
        long endTime = System.currentTimeMillis();
        ThreadLog.log(">>> request processed in " + (endTime - startTime) + " ms");
        SesameServer.unsetThreadLogFile();
    }

    protected void _doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doGet(request, response);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        SesameServlet.setSessionContext(request);
        this._doPost(request, response);
        SesameServlet.unsetSessionContext();
        long endTime = System.currentTimeMillis();
        ThreadLog.log(">>> request processed in " + (endTime - startTime) + " ms");
        SesameServer.unsetThreadLogFile();
    }

    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doPost(request, response);
    }

    public static void setSessionContext(HttpServletRequest request) throws ServletException, IOException {
        SesameServlet.unsetSessionContext();
        Cookie[] cookies = request.getCookies();
        Cookie sessionCookie = null;
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(SESSIONID)) continue;
                sessionCookie = cookies[i];
                break;
            }
        }
        if (sessionCookie != null) {
            SessionContext sc = SessionContext.get(sessionCookie.getValue());
            if (sc == null) {
                sc = new SessionContext();
                SessionContext.put(sessionCookie.getValue(), sc);
                HttpSession session = request.getSession();
                session.setAttribute("foo", (Object)new SessionKilled(sessionCookie.getValue()));
            } else {
                ThreadLog.trace("session context: user=" + sc.user + "; repository=" + sc.repository);
            }
            SessionContext.setContext(sc);
        }
    }

    public static void unsetSessionContext() throws ServletException, IOException {
        SessionContext.setContext(null);
    }

    protected void _logIP(HttpServletRequest request) {
        ThreadLog.log(">>> request from " + request.getRemoteAddr());
    }

    protected void _login(LocalService service) throws AccessDeniedException {
        SessionContext sc = SessionContext.getContext();
        if (sc != null && sc.user.trim().length() > 0) {
            ThreadLog.trace("user = " + sc.user);
            service.login(sc.user, sc.pass);
        }
    }

    protected void _sendBadRequest(String msg, HttpServletResponse response) throws IOException {
        ThreadLog.log("Bad request: " + msg);
        response.sendError(400, msg);
    }

    protected void _sendBadRequest(HTTPErrorType errType, String msg, HttpServletResponse response) throws IOException {
        ThreadLog.log("Bad request: " + msg);
        response.sendError(400, errType.toString() + ": " + msg);
    }

    protected void _sendForbidden(String msg, HttpServletResponse response) throws IOException {
        ThreadLog.log("Access denied: " + msg);
        response.sendError(403, msg);
    }

    protected void _sendInternalError(String msg, Exception e, HttpServletResponse response) throws IOException {
        ThreadLog.error("Internal error: " + msg, e);
        response.sendError(500, msg);
    }
}

