/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.uri;

import java.util.LinkedList;
import java.util.StringTokenizer;
import org.openrdf.util.StringUtil;

public class URI
implements Cloneable {
    private String _scheme;
    private String _schemeSpecificPart;
    private String _fragment;
    private String _authority;
    private String _path;
    private String _query;

    public URI(String uriSpec) {
        this._parse(uriSpec);
    }

    public URI(String scheme, String schemeSpecificPart, String fragment) {
        this._scheme = scheme;
        this._schemeSpecificPart = schemeSpecificPart;
        this._fragment = fragment;
    }

    public URI(String scheme, String authority, String path, String query, String fragment) {
        this._scheme = scheme;
        this._authority = authority;
        this._path = path;
        this._query = query;
        this._fragment = fragment;
    }

    public boolean isHierarchical() {
        return this._path != null;
    }

    public boolean isOpaque() {
        return this._path == null;
    }

    public boolean isAbsolute() {
        return this._scheme != null;
    }

    public boolean isRelative() {
        return this._scheme == null;
    }

    public boolean isSelfReference() {
        return this._scheme == null && this._authority == null && this._query == null && this._path.length() == 0;
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getSchemeSpecificPart() {
        return this._schemeSpecificPart;
    }

    public String getAuthority() {
        return this._authority;
    }

    public String getPath() {
        return this._path;
    }

    public String getQuery() {
        return this._query;
    }

    public String getFragment() {
        return this._fragment;
    }

    public void normalize() {
        if (this._path == null) {
            return;
        }
        this._path = StringUtil.gsub("/./", "/", this._path);
        if (this._path.startsWith("./")) {
            this._path = this._path.substring(2);
        }
        if (this._path.endsWith("/.")) {
            this._path = this._path.substring(0, this._path.length() - 1);
        }
        if (this._path.indexOf("/../") == -1 && !this._path.endsWith("/..")) {
            return;
        }
        LinkedList<String> segments = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(this._path, "/");
        while (st.hasMoreTokens()) {
            segments.add(st.nextToken());
        }
        boolean lastSegmentRemoved = false;
        int i = 1;
        while (i < segments.size()) {
            String segment = (String)segments.get(i);
            if (segment.equals("..")) {
                String prevSegment = (String)segments.get(i - 1);
                if (prevSegment.equals("..")) {
                    i += 2;
                    continue;
                }
                if (i == segments.size() - 1) {
                    lastSegmentRemoved = true;
                }
                segments.remove(i);
                segments.remove(i - 1);
                if (i <= 1) continue;
                --i;
                continue;
            }
            ++i;
        }
        StringBuffer newPath = new StringBuffer(this._path.length());
        if (this._path.startsWith("/")) {
            newPath.append('/');
        }
        int segmentCount = segments.size();
        for (i = 0; i < segmentCount - 1; ++i) {
            newPath.append((String)segments.get(i));
            newPath.append('/');
        }
        if (segmentCount > 0) {
            String lastSegment = (String)segments.get(segmentCount - 1);
            newPath.append(lastSegment);
            if (this._path.endsWith("/") || lastSegmentRemoved) {
                newPath.append('/');
            }
        }
        this._path = newPath.toString();
    }

    public URI resolve(String relUriSpec) {
        URI relUri = new URI(relUriSpec);
        return this.resolve(relUri);
    }

    public URI resolve(URI relUri) {
        String path;
        String authority;
        if (relUri.isAbsolute()) {
            return relUri;
        }
        if (relUri._authority == null && relUri._query == null && relUri._path.length() == 0) {
            URI result = (URI)this.clone();
            result._fragment = relUri._fragment;
            return result;
        }
        boolean normalizeURI = false;
        String scheme = this._scheme;
        String query = relUri._query;
        String fragment = relUri._fragment;
        if (relUri._authority != null) {
            authority = relUri._authority;
            path = relUri._path;
        } else {
            authority = this._authority;
            if (relUri._path.startsWith("/")) {
                path = relUri._path;
            } else {
                path = this._path;
                if (path == null) {
                    path = "/";
                } else {
                    if (!path.endsWith("/")) {
                        int lastSlashIdx = path.lastIndexOf(47);
                        path = path.substring(0, lastSlashIdx + 1);
                    }
                    if (path.length() == 0) {
                        path = "/";
                    }
                }
                path = path + relUri._path;
                normalizeURI = true;
            }
        }
        URI result = new URI(scheme, authority, path, query, fragment);
        if (normalizeURI) {
            result.normalize();
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(64);
        if (this._scheme != null) {
            result.append(this._scheme);
            result.append(':');
        }
        if (this.isOpaque()) {
            if (this._schemeSpecificPart != null) {
                result.append(this._schemeSpecificPart);
            }
        } else {
            if (this._authority != null) {
                result.append("//");
                result.append(this._authority);
            }
            result.append(this._path);
            if (this._query != null) {
                result.append('?');
                result.append(this._query);
            }
        }
        if (this._fragment != null) {
            result.append('#');
            result.append(this._fragment);
        }
        return result.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private void _parse(String uri) {
        if (this._parseScheme(uri)) {
            if (this._schemeSpecificPart.startsWith("/")) {
                String rest = this._schemeSpecificPart;
                rest = this._parseAuthority(rest);
                rest = this._parsePath(rest);
                rest = this._parseQuery(rest);
                this._parseFragment(rest);
            } else {
                String rest = this._schemeSpecificPart;
                rest = this._parseOpaquePart(rest);
                this._parseFragment(rest);
            }
        } else {
            String rest = uri;
            rest = this._parseAuthority(rest);
            rest = this._parsePath(rest);
            rest = this._parseQuery(rest);
            this._parseFragment(rest);
        }
    }

    private boolean _parseScheme(String uri) {
        int i;
        int c = 0;
        for (i = 0; i < uri.length() && (c = (int)uri.charAt(i)) != 58 && c != 47 && c != 63 && c != 35; ++i) {
        }
        if (c == 58 && i > 0) {
            this._scheme = uri.substring(0, i);
            this._schemeSpecificPart = uri.substring(i + 1);
            return true;
        }
        return false;
    }

    private String _parseAuthority(String s2) {
        if (s2.startsWith("//")) {
            char c;
            int i;
            for (i = 2; i < s2.length() && (c = s2.charAt(i)) != '/' && c != '?' && c != '#'; ++i) {
            }
            this._authority = s2.substring(2, i);
            return s2.substring(i);
        }
        return s2;
    }

    private String _parsePath(String s2) {
        char c;
        int i;
        for (i = 0; i < s2.length() && (c = s2.charAt(i)) != '?' && c != '#'; ++i) {
        }
        this._path = s2.substring(0, i);
        return s2.substring(i);
    }

    private String _parseQuery(String s2) {
        if (s2.startsWith("?")) {
            char c;
            int i;
            for (i = 1; i < s2.length() && (c = s2.charAt(i)) != '#'; ++i) {
            }
            this._query = s2.substring(1, i);
            return s2.substring(i);
        }
        return s2;
    }

    private String _parseOpaquePart(String s2) {
        char c;
        int i;
        for (i = 0; i < s2.length() && (c = s2.charAt(i)) != '#'; ++i) {
        }
        this._schemeSpecificPart = s2.substring(0, i);
        return s2.substring(i);
    }

    private void _parseFragment(String s2) {
        if (s2.startsWith("#")) {
            this._fragment = s2.substring(1);
        }
    }
}

