/*
 * Decompiled with CFR 0.152.
 */
package org.phyloref.jphyloref;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.phyloref.jphyloref.commands.Command;
import org.phyloref.jphyloref.commands.ResolveCommand;
import org.phyloref.jphyloref.commands.TestCommand;
import org.phyloref.jphyloref.commands.WebserverCommand;
import org.phyloref.jphyloref.helpers.ReasonerHelper;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPhyloRef {
    private static final Logger logger = LoggerFactory.getLogger(JPhyloRef.class);
    public static final String VERSION = "1.0.0";
    private List<Command> commands = Arrays.asList(new HelpCommand(), new TestCommand(), new WebserverCommand(), new ResolveCommand());

    public int execute(String[] args) {
        CommandLine cmdLine;
        Options opts = new Options();
        ReasonerHelper.addCommandLineOptions(opts);
        for (Command cmd : this.commands) {
            cmd.addCommandLineOptions(opts);
        }
        try {
            cmdLine = new DefaultParser().parse(opts, args);
        }
        catch (ParseException ex) {
            logger.error("Could not parse command line options: {}", (Object)ex.toString());
            return 1;
        }
        if (cmdLine.getArgList().isEmpty()) {
            HelpCommand help = new HelpCommand();
            return help.execute(cmdLine);
        }
        String command = cmdLine.getArgList().get(0);
        for (Command cmd : this.commands) {
            if (!cmd.getName().equalsIgnoreCase(command)) continue;
            return cmd.execute(cmdLine);
        }
        logger.error("Command '{}' has not been implemented.", (Object)command);
        return 1;
    }

    public static void main(String[] args) {
        JPhyloRef jphyloref = new JPhyloRef();
        System.exit(jphyloref.execute(args));
    }

    private class HelpCommand
    implements Command {
        private HelpCommand() {
        }

        @Override
        public String getName() {
            return "help";
        }

        @Override
        public String getDescription() {
            return "Provides help on all jphyloref commands";
        }

        @Override
        public void addCommandLineOptions(Options opts) {
        }

        @Override
        public int execute(CommandLine cmdLine) {
            System.out.println("JPhyloRef/1.0.0 OWLAPI/" + VersionInfo.getVersionInfo().getVersion());
            System.out.println("Synopsis: jphyloref <command> <options>\n");
            System.out.println("Where command is one of:");
            for (Command cmd : JPhyloRef.this.commands) {
                System.out.println(" - " + cmd.getName() + ": " + cmd.getDescription());
                Options opts = new Options();
                cmd.addCommandLineOptions(opts);
                for (Option opt : opts.getOptions()) {
                    String longOpt = "";
                    if (opt.getLongOpt() != null) {
                        longOpt = ", " + opt.getLongOpt();
                    }
                    System.out.println("    - " + opt.getOpt() + longOpt + ": " + opt.getDescription());
                }
            }
            System.out.println("\nWe also accept some global options, including:");
            System.out.println(" --reasoner <reasonerName>: sets the reasoner name, which should be one of:");
            Map<String, OWLReasonerFactory> reasonerList = ReasonerHelper.getReasonerFactories();
            for (String name : reasonerList.keySet()) {
                OWLReasonerFactory factory = reasonerList.get(name);
                System.out.println("    '" + name + "': " + ReasonerHelper.getReasonerNameAndVersion(factory));
            }
            System.out.println("");
            return 0;
        }
    }
}

