/*
 * Decompiled with CFR 0.152.
 */
package org.phyloref.jphyloref.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.eclipse.rdf4j.rio.RDFParser;
import org.json.JSONStringer;
import org.phyloref.jphyloref.commands.Command;
import org.phyloref.jphyloref.helpers.JSONLDHelper;
import org.phyloref.jphyloref.helpers.PhylorefHelper;
import org.phyloref.jphyloref.helpers.ReasonerHelper;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.AutoIRIMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveCommand
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(ResolveCommand.class);
    private static final String DEFAULT_URI_PREFIX = "http://example.org/jphyloref";

    @Override
    public String getName() {
        return "resolve";
    }

    @Override
    public String getDescription() {
        return "Resolve phyloreferences in the input ontology and report on their resolution in JSON.";
    }

    @Override
    public void addCommandLineOptions(Options opts) {
        opts.addOption("i", "input", true, "The input ontology to read in RDF/XML or JSON-LD (can also be provided without the '-i').");
        opts.addOption("j", "jsonld", false, "Treat the input file as a JSON-LD file. Files with a '.json' or '.jsonld' extension will automatically be treated as a JSON-LD file.");
        opts.addOption("e", "errors-as-json", false, "By default, errors during reasoning are reported to STDERR. Setting this flag collects all errors and includes them as part of the JSON output. This makes it easier to run JPhyloRef as a backend to a web server.");
    }

    @Override
    public int execute(CommandLine cmdLine) throws RuntimeException {
        boolean flagErrorsAsJSON = cmdLine.hasOption("errors-as-json");
        String inputFilename = cmdLine.getOptionValue("input");
        if (inputFilename == null && cmdLine.getArgList().size() > 1) {
            inputFilename = cmdLine.getArgList().get(1);
        }
        if (inputFilename == null) {
            throw new IllegalArgumentException("Error: no input ontology specified (use '-i input.owl')");
        }
        InputStream inputStreamToReadFrom = null;
        if (inputFilename.equals("-")) {
            inputStreamToReadFrom = System.in;
        } else {
            try {
                inputStreamToReadFrom = new FileInputStream(inputFilename);
            }
            catch (FileNotFoundException ex) {
                logger.error("Could not open input file '{}': {}", (Object)inputFilename, (Object)ex);
                return 1;
            }
        }
        logger.info("Input: {}", (Object)inputFilename);
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        AutoIRIMapper mapper = new AutoIRIMapper(new File("ontologies"), true);
        logger.info("Found local ontologies: {}", (Object)mapper.getOntologyIRIs());
        manager.addIRIMapper(mapper);
        String inputFileLowercase = inputFilename.toLowerCase();
        try {
            OWLOntology ontology;
            if (cmdLine.hasOption("jsonld") || inputFileLowercase.endsWith(".json") || inputFileLowercase.endsWith(".jsonld")) {
                ontology = manager.createOntology();
                RDFParser parser = JSONLDHelper.createRDFParserForOntology(ontology);
                parser.parse(inputStreamToReadFrom, DEFAULT_URI_PREFIX);
            } else {
                ontology = manager.loadOntologyFromOntologyDocument(inputStreamToReadFrom);
            }
            System.err.println("Loaded ontology: " + ontology);
            HashMap nodesPerPhylorefAsString = new HashMap();
            OWLReasonerFactory factory = ReasonerHelper.getReasonerFactoryFromCmdLine(cmdLine);
            OWLReasoner reasoner = factory.createReasoner(ontology);
            for (OWLClass phyloref : PhylorefHelper.getPhyloreferences(ontology, reasoner)) {
                IRI phylorefIRI = phyloref.getIRI();
                Set nodes = PhylorefHelper.getNodesInClass(phyloref, ontology, reasoner).stream().map(indiv -> indiv.getIRI().toString()).map(iri -> iri.replaceFirst("^http://example.org/jphyloref", "")).collect(Collectors.toSet());
                String nodeURI = phylorefIRI.toString();
                nodeURI = nodeURI.replaceFirst("^http://example.org/jphyloref", "");
                nodesPerPhylorefAsString.put(nodeURI, nodes);
            }
            reasoner.dispose();
            System.out.println(new JSONStringer().object().key("phylorefs").value(nodesPerPhylorefAsString).endObject().toString());
            return 0;
        }
        catch (OWLOntologyCreationException ex) {
            if (flagErrorsAsJSON) {
                System.out.println(new JSONStringer().object().key("error").value("Could not create ontology (OWLOntologyCreationException)").key("message").value(ex.toString()).endObject().toString());
                return 0;
            }
            System.err.println("Could not create ontology '" + inputFilename + "': " + ex);
            return 1;
        }
        catch (IOException ex) {
            if (flagErrorsAsJSON) {
                System.out.println(new JSONStringer().object().key("error").value("Could not read and load ontology (IOException)").key("message").value(ex.toString()).endObject().toString());
                return 0;
            }
            System.err.println("Could not create ontology '" + inputFilename + "': " + ex);
            return 1;
        }
        catch (IllegalArgumentException ex) {
            if (flagErrorsAsJSON) {
                System.out.println(new JSONStringer().object().key("error").value("Arguments were invalid (IllegalArgumentException), likely because no phylorefs were present").key("message").value(ex.toString()).endObject().toString());
                return 0;
            }
            System.err.println("Arguments were invalid, likely because no phylorefs were present in '" + inputFilename + "': " + ex);
            return 1;
        }
        catch (Exception ex) {
            if (flagErrorsAsJSON) {
                System.out.println(new JSONStringer().object().key("error").value("Unexpected exception (" + ex.getClass().toString() + ")").key("message").value(ex.toString()).endObject().toString());
                return 0;
            }
            System.err.println("Unexcepted exception while reasoning over '" + inputFilename + "': " + ex);
            return 1;
        }
    }
}

