/*
 * Decompiled with CFR 0.152.
 */
package org.phyloref.jphyloref.commands;

import fi.iki.elonen.NanoHTTPD;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.json.JSONObject;
import org.phyloref.jphyloref.commands.Command;
import org.phyloref.jphyloref.helpers.JSONLDHelper;
import org.phyloref.jphyloref.helpers.PhylorefHelper;
import org.phyloref.jphyloref.helpers.ReasonerHelper;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.AutoIRIMapper;
import org.semanticweb.owlapi.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebserverCommand
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(WebserverCommand.class);

    @Override
    public String getName() {
        return "webserver";
    }

    @Override
    public String getDescription() {
        return "Set up a webserver to allow reasoning of phyloreferences over HTTP.";
    }

    @Override
    public void addCommandLineOptions(Options opts) {
        opts.addOption("h", "host", true, "The hostname to listen to HTTP connections on (default: 'localhost')");
        opts.addOption("p", "port", true, "The TCP port to listen to HTTP connections on (default: 34214)");
    }

    @Override
    public int execute(CommandLine cmdLine) throws RuntimeException {
        String hostname = cmdLine.getOptionValue("host", "localhost");
        String portString = cmdLine.getOptionValue("port", "34214");
        int port = Integer.parseInt(portString);
        try {
            Webserver webserver = new Webserver(this, hostname, port, cmdLine);
            while (webserver.isAlive()) {
            }
        }
        catch (IOException ex) {
            logger.error("An error occurred while running webserver: {}", (Object)ex.toString());
        }
        return 0;
    }

    class Webserver
    extends NanoHTTPD {
        private final WebserverCommand cmd;
        private final CommandLine cmdLine;

        public Webserver(WebserverCommand cmd, String hostname, int port, CommandLine cmdLine) throws IOException {
            super(hostname, port);
            this.cmd = cmd;
            this.cmdLine = cmdLine;
            this.start(5000, false);
            logger.info("Webserver started with reasoner {}. Try accessing it at http://{}:{}/", ReasonerHelper.getReasonerNameAndVersion(ReasonerHelper.getReasonerFactoryFromCmdLine(cmdLine)), hostname, port);
        }

        public JSONObject serveReason(File jsonldFile) throws OWLOntologyCreationException, RDFParseException, IOException {
            JSONObject response = new JSONObject("{'status': 'ok'}");
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            AutoIRIMapper mapper = new AutoIRIMapper(new File("ontologies"), true);
            logger.info("Found local ontologies: {}", (Object)mapper.getOntologyIRIs());
            manager.addIRIMapper(mapper);
            String DEFAULT_URI_PREFIX = "http://example.org/jphyloref";
            OWLOntology ontology = manager.createOntology();
            RDFParser parser = JSONLDHelper.createRDFParserForOntology(ontology);
            parser.parse(new FileReader(jsonldFile), DEFAULT_URI_PREFIX);
            response.put("ontology", ontology.toString());
            HashMap nodesPerPhylorefAsString = new HashMap();
            OWLReasonerFactory factory = ReasonerHelper.getReasonerFactoryFromCmdLine(this.cmdLine);
            OWLReasoner reasoner = factory.createReasoner(ontology);
            for (OWLClass phyloref : PhylorefHelper.getPhyloreferences(ontology, reasoner)) {
                IRI phylorefIRI = phyloref.getIRI();
                Set nodes = PhylorefHelper.getNodesInClass(phyloref, ontology, reasoner).stream().map(indiv -> indiv.getIRI().toString()).map(iri -> iri.replaceFirst("^" + DEFAULT_URI_PREFIX, "")).collect(Collectors.toSet());
                String nodeURI = phylorefIRI.toString();
                nodeURI = nodeURI.replaceFirst("^" + DEFAULT_URI_PREFIX, "");
                nodesPerPhylorefAsString.put(nodeURI, nodes);
            }
            reasoner.dispose();
            logger.info("Phyloreferencing reasoning results: {}", (Object)nodesPerPhylorefAsString);
            response.put("phylorefs", nodesPerPhylorefAsString);
            return response;
        }

        public JSONObject serveVersion() {
            JSONObject response = new JSONObject("{'status': 'ok'}");
            String owlapiVersion = VersionInfo.getVersionInfo().getVersion();
            response.put("owlapiVersion", owlapiVersion);
            String reasonerVersion = ReasonerHelper.getReasonerNameAndVersion(ReasonerHelper.getReasonerFactoryFromCmdLine(this.cmdLine));
            response.put("reasonerVersion", reasonerVersion);
            response.put("name", "JPhyloRef/1.0.0 OWLAPI/" + owlapiVersion + " " + reasonerVersion);
            response.put("version", "1.0.0");
            return response;
        }

        public NanoHTTPD.Response createResponse(NanoHTTPD.Response.IStatus status, JSONObject result) {
            NanoHTTPD.Response response = Webserver.newFixedLengthResponse(status, "application/json", result.toString());
            response.addHeader("Access-Control-Allow-Origin", "*");
            return response;
        }

        @Override
        public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
            HashMap<String, String> files = new HashMap<String, String>();
            if (session.getMethod().equals((Object)NanoHTTPD.Method.PUT) || session.getMethod().equals((Object)NanoHTTPD.Method.POST)) {
                try {
                    session.parseBody(files);
                }
                catch (IOException ex) {
                    return Webserver.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", "Server threw IOException: " + ex);
                }
                catch (NanoHTTPD.ResponseException re) {
                    return Webserver.newFixedLengthResponse(re.getStatus(), "text/plain", re.getMessage());
                }
            }
            JSONObject response = new JSONObject("{'status': 'ok'}");
            String path = session.getUri();
            Map<String, List<String>> params = session.getParameters();
            logger.info(">> Request received to '{}': {}", (Object)path, (Object)params);
            if (path.equals("/reason")) {
                if (session.getMethod().equals((Object)NanoHTTPD.Method.OPTIONS)) {
                    NanoHTTPD.Response preflightResponse = Webserver.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "text/plain", "Options");
                    preflightResponse.addHeader("Access-Control-Allow-Origin", "*");
                    preflightResponse.addHeader("Access-Control-Allow-Methods", "POST");
                    preflightResponse.addHeader("Access-Control-Allow-Headers", "x-hub-signature");
                    return preflightResponse;
                }
                try {
                    File jsonldFile = null;
                    if (params.containsKey("jsonldFile")) {
                        jsonldFile = new File((String)files.get("jsonldFile"));
                    } else {
                        String jsonld = null;
                        if (params.containsKey("jsonld")) {
                            jsonld = String.join((CharSequence)"", (Iterable<? extends CharSequence>)params.get("jsonld"));
                        } else if (params.containsKey("jsonldGzipped")) {
                            String buffer;
                            String jsonldgzBase64 = String.join((CharSequence)"", (Iterable<? extends CharSequence>)params.get("jsonldGzipped"));
                            byte[] jsonldGzipped = Base64.getDecoder().decode(jsonldgzBase64);
                            GZIPInputStream gzis = new GZIPInputStream(new ByteArrayInputStream(jsonldGzipped));
                            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)gzis, "UTF-8"));
                            StringBuffer jsonldStringBuffer = new StringBuffer();
                            while ((buffer = reader.readLine()) != null) {
                                jsonldStringBuffer.append(buffer);
                            }
                            jsonld = jsonldStringBuffer.toString();
                        } else {
                            response.put("status", "error");
                            response.put("error", "Expected a form with a file upload in the 'jsonldFile' field or a JSON-LD string in the 'jsonld' or 'jsonldGzipped' field, but no such field was found");
                            return this.createResponse(NanoHTTPD.Response.Status.BAD_REQUEST, response);
                        }
                        if (jsonld != null) {
                            jsonldFile = File.createTempFile("jphyloref", null);
                            FileWriter writer = new FileWriter(jsonldFile);
                            writer.write(String.join((CharSequence)";", jsonld));
                            writer.close();
                        }
                    }
                    return this.createResponse(NanoHTTPD.Response.Status.OK, this.serveReason(jsonldFile));
                }
                catch (IOException | RDFParseException | OWLOntologyCreationException ex) {
                    response.put("status", "error");
                    response.put("error", "Exception thrown: " + ex.getMessage());
                    ex.printStackTrace();
                    return this.createResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, response);
                }
            }
            if (path.equals("/version")) {
                return this.createResponse(NanoHTTPD.Response.Status.OK, this.serveVersion());
            }
            response.put("status", "error");
            response.put("error", "Path '" + path + "' could not be found.");
            return this.createResponse(NanoHTTPD.Response.Status.NOT_FOUND, response);
        }
    }
}

