/*
 * Decompiled with CFR 0.152.
 */
package org.phyloref.jphyloref.helpers;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.semanticweb.elk.owlapi.ElkReasonerFactory;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.Version;

public class ReasonerHelper {
    private static Map<String, OWLReasonerFactory> reasonerFactories = new HashMap<String, OWLReasonerFactory>();

    public static OWLReasonerFactory getReasonerFactory(String name) {
        if (reasonerFactories.containsKey(name)) {
            return reasonerFactories.get(name);
        }
        throw new IllegalArgumentException("No reasoner named '" + name + "'; must be one of: " + reasonerFactories.keySet().toString());
    }

    public static Map<String, OWLReasonerFactory> getReasonerFactories() {
        return reasonerFactories;
    }

    public static String getReasonerNameAndVersion(OWLReasonerFactory factory) {
        String versionString;
        if (factory == null) {
            return "No reasoner used";
        }
        try {
            OWLReasoner reasoner = factory.createNonBufferingReasoner(OWLManager.createOWLOntologyManager().createOntology());
            Version version = reasoner.getReasonerVersion();
            versionString = version.getMajor() + "." + version.getMinor() + "." + version.getBuild() + "." + version.getPatch();
        }
        catch (NumberFormatException e) {
            String errorMessage = e.getMessage();
            versionString = errorMessage.startsWith("For input string: \"") && errorMessage.endsWith("\"") ? errorMessage.substring(19, errorMessage.length() - 1) : "(error: " + errorMessage + ")";
        }
        catch (OWLOntologyCreationException e) {
            versionString = "(error: " + e + ")";
        }
        catch (UnsatisfiedLinkError err) {
            versionString = "(JNI library not linked)";
        }
        return factory.getReasonerName() + "/" + versionString;
    }

    public static OWLReasonerFactory getReasonerFactoryFromCmdLine(CommandLine cmdLine) {
        if (cmdLine.hasOption("reasoner")) {
            return ReasonerHelper.getReasonerFactory(cmdLine.getOptionValue("reasoner"));
        }
        return new ElkReasonerFactory();
    }

    public static void addCommandLineOptions(Options opts) {
        opts.addOption("reasoner", "reasoner", true, "The reasoner to be used (use help to see list of options)");
    }

    static {
        reasonerFactories.put("null", null);
        reasonerFactories.put("elk", new ElkReasonerFactory());
    }
}

