/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.loading;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.loading.Owl2ParserLoader;
import org.semanticweb.elk.owl.parsing.Owl2ParserFactory;

public class Owl2StreamLoader
extends Owl2ParserLoader
implements AxiomLoader {
    private final InputStream stream_;

    public Owl2StreamLoader(Owl2ParserFactory parserFactory, InputStream stream) {
        super(parserFactory.getParser(stream));
        this.stream_ = stream;
    }

    public Owl2StreamLoader(Owl2ParserFactory parserFactory, File file) throws FileNotFoundException {
        this(parserFactory, new FileInputStream(file));
    }

    public Owl2StreamLoader(Owl2ParserFactory parserFactory, String text) {
        this(parserFactory, new ByteArrayInputStream(text.getBytes()));
    }

    @Override
    public void disposeParserResources() {
        super.disposeParserResources();
        try {
            this.stream_.close();
        }
        catch (IOException e) {
            this.exception = new ElkLoadingException("Cannot close the input stream!", e);
        }
    }
}

