/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import java.util.HashSet;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.exceptions.ElkRuntimeException;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owlapi.ElkEntityConverter;
import org.semanticweb.elk.reasoner.ElkFreshEntitiesException;
import org.semanticweb.elk.reasoner.ElkInconsistentOntologyException;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;

public class ElkExceptionConverter {
    private static ElkExceptionConverter INSTANCE_ = new ElkExceptionConverter();

    private ElkExceptionConverter() {
    }

    public static ElkExceptionConverter getInstance() {
        return INSTANCE_;
    }

    public FreshEntitiesException convert(ElkFreshEntitiesException e) {
        HashSet<OWLEntity> owlEntities = new HashSet<OWLEntity>();
        for (ElkEntity elkEntity : e.getEntities()) {
            owlEntities.add(elkEntity.accept(ElkEntityConverter.getInstance()));
        }
        return new FreshEntitiesException(owlEntities);
    }

    public InconsistentOntologyException convert(ElkInconsistentOntologyException e) {
        return new InconsistentOntologyException();
    }

    public ReasonerInterruptedException convert(ElkInterruptedException e) {
        return new ReasonerInterruptedException(e);
    }

    public OWLRuntimeException convert(ElkRuntimeException e) {
        return new ReasonerInternalException(e);
    }

    public OWLRuntimeException convert(ElkException e) {
        if (e instanceof ElkFreshEntitiesException) {
            return this.convert((ElkFreshEntitiesException)e);
        }
        if (e instanceof ElkInconsistentOntologyException) {
            return this.convert((ElkInconsistentOntologyException)e);
        }
        if (e instanceof ElkInterruptedException) {
            return this.convert((ElkInterruptedException)e);
        }
        return new ReasonerInterruptedException(e);
    }
}

