/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.exceptions.ElkRuntimeException;
import org.semanticweb.elk.owl.implementation.ElkObjectFactoryImpl;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkObjectFactory;
import org.semanticweb.elk.owlapi.ElkConverter;
import org.semanticweb.elk.owlapi.ElkReasonerConfiguration;
import org.semanticweb.elk.owlapi.ElkReasonerProgressMonitor;
import org.semanticweb.elk.owlapi.OwlChangesLoader;
import org.semanticweb.elk.owlapi.OwlOntologyLoader;
import org.semanticweb.elk.owlapi.wrapper.OwlConverter;
import org.semanticweb.elk.reasoner.DummyProgressMonitor;
import org.semanticweb.elk.reasoner.ElkUnsupportedReasoningTaskException;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.ReasonerFactory;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.stages.LoggingStageExecutor;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.util.logging.ElkMessage;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeProgressListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.AxiomNotInProfileException;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.ClassExpressionNotInProfileException;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.UnsupportedEntailmentTypeException;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.util.Version;

public class ElkReasoner
implements OWLReasoner {
    private static final Logger LOGGER_ = Logger.getLogger(ElkReasoner.class);
    private final OWLOntology owlOntology_;
    private final OWLOntologyManager owlOntologymanager_;
    private final ProgressMonitor mainProgressMonitor_;
    private final ProgressMonitor secondaryProgressMonitor_;
    private final boolean isBufferingMode_;
    private final OntologyChangeListener ontologyChangeListener_;
    private final OntologyChangeProgressListener ontologyChangeProgressListener_;
    private final ElkObjectFactory objectFactory_;
    private final OwlConverter owlConverter_;
    private final ElkConverter elkConverter_;
    private volatile OwlChangesLoader bufferedChangesLoader_;
    private final ReasonerConfiguration config_;
    private final boolean isAllowFreshEntities;
    private final ReasonerStageExecutor stageExecutor_;
    private Reasoner reasoner_;
    private boolean loadBeforeChanges_ = true;
    private boolean ontologyReloadRequired_;

    ElkReasoner(OWLOntology ontology, boolean isBufferingMode, ElkReasonerConfiguration elkConfig, ReasonerStageExecutor stageExecutor) {
        this.owlOntology_ = ontology;
        this.owlOntologymanager_ = ontology.getOWLOntologyManager();
        this.mainProgressMonitor_ = elkConfig.getProgressMonitor() == null ? new DummyProgressMonitor() : new ElkReasonerProgressMonitor(elkConfig.getProgressMonitor());
        this.secondaryProgressMonitor_ = new DummyProgressMonitor();
        this.isBufferingMode_ = isBufferingMode;
        this.ontologyChangeListener_ = new OntologyChangeListener();
        this.owlOntologymanager_.addOntologyChangeListener(this.ontologyChangeListener_);
        this.ontologyChangeProgressListener_ = new OntologyChangeProgressListener();
        this.owlOntologymanager_.addOntologyChangeProgessListener(this.ontologyChangeProgressListener_);
        this.objectFactory_ = new ElkObjectFactoryImpl();
        this.owlConverter_ = OwlConverter.getInstance();
        this.elkConverter_ = ElkConverter.getInstance();
        this.config_ = elkConfig.getElkConfiguration();
        this.stageExecutor_ = stageExecutor;
        this.isAllowFreshEntities = elkConfig.getFreshEntityPolicy() == FreshEntityPolicy.ALLOW;
        this.reCreateReasoner();
        this.bufferedChangesLoader_ = new OwlChangesLoader(this.mainProgressMonitor_);
        if (!this.isBufferingMode_) {
            this.reasoner_.registerAxiomLoader(this.bufferedChangesLoader_);
        }
        this.ontologyReloadRequired_ = false;
    }

    ElkReasoner(OWLOntology ontology, boolean isBufferingMode, ElkReasonerConfiguration elkConfig) {
        this(ontology, isBufferingMode, elkConfig, new LoggingStageExecutor());
    }

    ElkReasoner(OWLOntology ontology, boolean isBufferingMode, ReasonerStageExecutor stageExecutor, ReasonerProgressMonitor progressMonitor) {
        this(ontology, isBufferingMode, new ElkReasonerConfiguration(progressMonitor), stageExecutor);
    }

    ElkReasoner(OWLOntology ontology, boolean isBufferingMode, ReasonerStageExecutor stageExecutor) {
        this(ontology, isBufferingMode, new ElkReasonerConfiguration(), stageExecutor);
    }

    ElkReasoner(OWLOntology ontology, boolean isBufferingMode) {
        this(ontology, isBufferingMode, new ElkReasonerConfiguration(), new LoggingStageExecutor());
    }

    private void reCreateReasoner() {
        this.reasoner_ = new ReasonerFactory().createReasoner(new OwlOntologyLoader(this.owlOntology_, this.mainProgressMonitor_), this.stageExecutor_, this.config_);
        this.reasoner_.setAllowFreshEntities(this.isAllowFreshEntities);
        this.reasoner_.setProgressMonitor(this.secondaryProgressMonitor_);
    }

    public Reasoner getInternalReasoner() {
        return this.reasoner_;
    }

    public void setConfigurationOptions(ReasonerConfiguration config) {
        this.reasoner_.setConfigurationOptions(config);
    }

    private static UnsupportedOperationException unsupportedOwlApiMethod(String method) {
        String message = "OWL API reasoner method is not implemented: " + method + ".";
        LOGGER_.warn(ElkMessage.serialize("owlapi.unsupportedMethod", message));
        return new UnsupportedOperationException(message);
    }

    private static UnsupportedOperationException unsupportedOwlApiMethod(String method, String reason) {
        String message = "OWL API reasoner method is not fully implemented: " + method + ": " + reason;
        LOGGER_.warn(ElkMessage.serialize("owlapi.unsupportedMethod", message));
        return new UnsupportedOperationException(message);
    }

    private Node<OWLClass> getClassNode(ElkClass elkClass) throws FreshEntitiesException, InconsistentOntologyException, ElkException {
        try {
            return this.elkConverter_.convertClassNode(this.reasoner_.getEquivalentClasses(elkClass));
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    private void checkInterrupted() throws ReasonerInterruptedException {
        if (this.reasoner_.isInterrupted()) {
            throw new ReasonerInterruptedException("ELK was interrupted");
        }
    }

    @Override
    public void dispose() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("dispose()");
        }
        this.owlOntologymanager_.removeOntologyChangeListener(this.ontologyChangeListener_);
        this.owlOntologymanager_.removeOntologyChangeProgessListener(this.ontologyChangeProgressListener_);
        try {
            while (true) {
                try {
                    if (!this.reasoner_.shutdown()) {
                        throw new ReasonerInternalException("Failed to shut down ELK!");
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    @Override
    public void flush() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("flush()");
        }
        this.checkInterrupted();
        try {
            if (this.ontologyReloadRequired_) {
                this.reCreateReasoner();
                this.bufferedChangesLoader_ = new OwlChangesLoader(this.secondaryProgressMonitor_);
                this.ontologyReloadRequired_ = false;
            } else if (!this.bufferedChangesLoader_.isLoadingFinished()) {
                if (this.isBufferingMode_) {
                    this.reasoner_.registerAxiomLoader(this.bufferedChangesLoader_);
                    this.bufferedChangesLoader_ = new OwlChangesLoader(this.secondaryProgressMonitor_);
                } else {
                    this.reasoner_.resetAxiomLoading();
                }
            }
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    @Override
    public Node<OWLClass> getBottomClassNode() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getBottomClassNode()");
        }
        this.checkInterrupted();
        try {
            return this.getClassNode(this.objectFactory_.getOwlNothing());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getBottomClassNode()", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    @Override
    public Node<OWLDataProperty> getBottomDataPropertyNode() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getBottomDataPropertyNode()");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getBottomDataPropertyNode()");
    }

    @Override
    public Node<OWLObjectPropertyExpression> getBottomObjectPropertyNode() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getBottomObjectPropertyNode()");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getBottomObjectPropertyNode()");
    }

    @Override
    public BufferingMode getBufferingMode() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getBufferingMode()");
        }
        return this.isBufferingMode_ ? BufferingMode.BUFFERING : BufferingMode.NON_BUFFERING;
    }

    @Override
    public NodeSet<OWLClass> getDataPropertyDomains(OWLDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getDataPropertyDomains(OWLDataProperty, boolean)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDataPropertyDomains(OWLDataProperty, boolean)");
    }

    @Override
    public Set<OWLLiteral> getDataPropertyValues(OWLNamedIndividual arg0, OWLDataProperty arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getDataPropertyValues(OWLNamedIndividual, OWLDataProperty)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDataPropertyValues(OWLNamedIndividual, OWLDataProperty)");
    }

    @Override
    public NodeSet<OWLNamedIndividual> getDifferentIndividuals(OWLNamedIndividual arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getDifferentIndividuals(OWLNamedIndividual)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDifferentIndividuals(OWLNamedIndividual)");
    }

    @Override
    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression arg0) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getDisjointClasses(OWLClassExpression)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDisjointClasses(OWLClassExpression)");
    }

    @Override
    public NodeSet<OWLDataProperty> getDisjointDataProperties(OWLDataPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getDisjointDataProperties(OWLDataPropertyExpression)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDisjointDataProperties(OWLDataPropertyExpression)");
    }

    @Override
    public NodeSet<OWLObjectPropertyExpression> getDisjointObjectProperties(OWLObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getDisjointObjectProperties(OWLObjectPropertyExpression)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDisjointObjectProperties(OWLObjectPropertyExpression)");
    }

    @Override
    public Node<OWLClass> getEquivalentClasses(OWLClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getEquivalentClasses(OWLClassExpression)");
        }
        this.checkInterrupted();
        try {
            return this.elkConverter_.convertClassNode(this.reasoner_.getEquivalentClasses(this.owlConverter_.convert(ce)));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentClasses(OWLClassExpression)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    @Override
    public Node<OWLDataProperty> getEquivalentDataProperties(OWLDataProperty arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getEquivalentDataProperties(OWLDataProperty)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentDataProperties(OWLDataProperty)");
    }

    @Override
    public Node<OWLObjectPropertyExpression> getEquivalentObjectProperties(OWLObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getEquivalentObjectProperties(OWLObjectPropertyExpression)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentObjectProperties(OWLObjectPropertyExpression)");
    }

    @Override
    public FreshEntityPolicy getFreshEntityPolicy() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getFreshEntityPolicy()");
        }
        return this.reasoner_.getAllowFreshEntities() ? FreshEntityPolicy.ALLOW : FreshEntityPolicy.DISALLOW;
    }

    @Override
    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getIndividualNodeSetPolicy()");
        }
        return IndividualNodeSetPolicy.BY_NAME;
    }

    @Override
    public NodeSet<OWLNamedIndividual> getInstances(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getInstances(OWLClassExpression, boolean)");
        }
        this.checkInterrupted();
        try {
            return this.elkConverter_.convertIndividualNodes(this.reasoner_.getInstances(this.owlConverter_.convert(ce), direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getInstances(OWLClassExpression, boolean)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    @Override
    public Node<OWLObjectPropertyExpression> getInverseObjectProperties(OWLObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getInverseObjectProperties(OWLObjectPropertyExpression)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getInverseObjectProperties(OWLObjectPropertyExpression)");
    }

    @Override
    public NodeSet<OWLClass> getObjectPropertyDomains(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getObjectPropertyDomains(OWLObjectPropertyExpression, boolean)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getObjectPropertyDomains(OWLObjectPropertyExpression, boolean)");
    }

    @Override
    public NodeSet<OWLClass> getObjectPropertyRanges(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getObjectPropertyRanges(OWLObjectPropertyExpression, boolean)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getObjectPropertyRanges(OWLObjectPropertyExpression, boolean)");
    }

    @Override
    public NodeSet<OWLNamedIndividual> getObjectPropertyValues(OWLNamedIndividual arg0, OWLObjectPropertyExpression arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getObjectPropertyValues(OWLNamedIndividual, OWLObjectPropertyExpression)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getObjectPropertyValues(OWLNamedIndividual, OWLObjectPropertyExpression)");
    }

    @Override
    public Set<OWLAxiom> getPendingAxiomAdditions() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getPendingAxiomAdditions()");
        }
        return this.bufferedChangesLoader_.getPendingAxiomAdditions();
    }

    @Override
    public Set<OWLAxiom> getPendingAxiomRemovals() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getPendingAxiomRemovals()");
        }
        return this.bufferedChangesLoader_.getPendingAxiomRemovals();
    }

    @Override
    public List<OWLOntologyChange> getPendingChanges() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getPendingChanges()");
        }
        return this.bufferedChangesLoader_.getPendingChanges();
    }

    @Override
    public Set<InferenceType> getPrecomputableInferenceTypes() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getPrecomputableInferenceTypes()");
        }
        return new HashSet<InferenceType>(Arrays.asList(InferenceType.CLASS_ASSERTIONS, InferenceType.CLASS_HIERARCHY));
    }

    @Override
    public String getReasonerName() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getReasonerName()");
        }
        return ElkReasoner.class.getPackage().getImplementationTitle();
    }

    @Override
    public Version getReasonerVersion() {
        int filled;
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getReasonerVersion()");
        }
        String versionString = ElkReasoner.class.getPackage().getImplementationVersion();
        int[] version = new int[4];
        if (versionString != null) {
            String[] splitted = versionString.split("\\.");
            for (filled = 0; filled < splitted.length; ++filled) {
                version[filled] = Integer.parseInt(splitted[filled]);
            }
        }
        while (filled < version.length) {
            version[filled] = 0;
            ++filled;
        }
        return new Version(version[0], version[1], version[2], version[3]);
    }

    @Override
    public OWLOntology getRootOntology() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getRootOntology()");
        }
        return this.owlOntology_;
    }

    @Override
    public Node<OWLNamedIndividual> getSameIndividuals(OWLNamedIndividual arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getSameIndividuals(OWLNamedIndividual)");
        }
        this.checkInterrupted();
        return new OWLNamedIndividualNode(arg0);
    }

    @Override
    public NodeSet<OWLClass> getSubClasses(OWLClassExpression ce, boolean direct) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException, ClassExpressionNotInProfileException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getSubClasses(OWLClassExpression, boolean)");
        }
        this.checkInterrupted();
        try {
            return this.elkConverter_.convertClassNodes(this.reasoner_.getSubClasses(this.owlConverter_.convert(ce), direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getSubClasses(OWLClassExpression, boolean)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    @Override
    public NodeSet<OWLDataProperty> getSubDataProperties(OWLDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getSubDataProperties(OWLDataProperty, boolean)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getSubDataProperties(OWLDataProperty, boolean)");
    }

    @Override
    public NodeSet<OWLObjectPropertyExpression> getSubObjectProperties(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getSubObjectProperties(OWLObjectPropertyExpression, boolean)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getSubObjectProperties(OWLObjectPropertyExpression, boolean)");
    }

    @Override
    public NodeSet<OWLClass> getSuperClasses(OWLClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getSuperClasses(OWLClassExpression, boolean)");
        }
        this.checkInterrupted();
        try {
            return this.elkConverter_.convertClassNodes(this.reasoner_.getSuperClasses(this.owlConverter_.convert(ce), direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getSuperClasses(OWLClassExpression, boolean)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    @Override
    public NodeSet<OWLDataProperty> getSuperDataProperties(OWLDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getSuperDataProperties(OWLDataProperty, boolean)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getSuperDataProperties(OWLDataProperty, boolean)");
    }

    @Override
    public NodeSet<OWLObjectPropertyExpression> getSuperObjectProperties(OWLObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getSuperObjectProperties(OWLObjectPropertyExpression, boolean)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getSuperObjectProperties(OWLObjectPropertyExpression, boolean)");
    }

    @Override
    public long getTimeOut() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getTimeOut()");
        }
        return 0L;
    }

    @Override
    public Node<OWLClass> getTopClassNode() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getTopClassNode()");
        }
        this.checkInterrupted();
        try {
            return this.getClassNode(this.objectFactory_.getOwlThing());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getTopClassNode()", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    @Override
    public Node<OWLDataProperty> getTopDataPropertyNode() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getTopDataPropertyNode()");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getTopDataPropertyNode()");
    }

    @Override
    public Node<OWLObjectPropertyExpression> getTopObjectPropertyNode() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getTopObjectPropertyNode()");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getTopObjectPropertyNode()");
    }

    @Override
    public NodeSet<OWLClass> getTypes(OWLNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getTypes(OWLNamedIndividual, boolean)");
        }
        this.checkInterrupted();
        try {
            return this.elkConverter_.convertClassNodes(this.reasoner_.getTypes(this.owlConverter_.convert(ind), direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getTypes(OWLNamedIndividual, boolean)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    @Override
    public Node<OWLClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("getUnsatisfiableClasses()");
        }
        this.checkInterrupted();
        try {
            return this.getClassNode(this.objectFactory_.getOwlNothing());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getUnsatisfiableClasses()", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    @Override
    public void interrupt() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("interrupt()");
        }
        this.reasoner_.interrupt();
    }

    @Override
    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("isConsistent()");
        }
        try {
            return !this.reasoner_.isInconsistent();
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("isConsistent()", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    @Override
    public boolean isEntailed(OWLAxiom arg0) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("isEntailed(OWLAxiom)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("isEntailed(OWLAxiom)");
    }

    @Override
    public boolean isEntailed(Set<? extends OWLAxiom> arg0) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("isEntailed(Set<? extends OWLAxiom>)");
        }
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("isEntailed(Set<? extends OWLAxiom>)");
    }

    @Override
    public boolean isEntailmentCheckingSupported(AxiomType<?> arg0) {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("isEntailmentCheckingSupported(AxiomType<?>)");
        }
        return false;
    }

    @Override
    public boolean isPrecomputed(InferenceType inferenceType) {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("isPrecomputed(InferenceType)");
        }
        if (inferenceType.equals((Object)InferenceType.CLASS_HIERARCHY)) {
            return this.reasoner_.doneTaxonomy();
        }
        if (inferenceType.equals((Object)InferenceType.CLASS_ASSERTIONS)) {
            return this.reasoner_.doneInstanceTaxonomy();
        }
        return false;
    }

    @Override
    public boolean isSatisfiable(OWLClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("isSatisfiable(OWLClassExpression)");
        }
        this.checkInterrupted();
        try {
            return this.reasoner_.isSatisfiable(this.owlConverter_.convert(classExpression));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("isSatisfiable(classExpression)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    @Override
    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("precomputeInferences(InferenceType...)");
        }
        this.checkInterrupted();
        this.reasoner_.setProgressMonitor(this.mainProgressMonitor_);
        try {
            for (InferenceType inferenceType : inferenceTypes) {
                if (inferenceType.equals((Object)InferenceType.CLASS_HIERARCHY)) {
                    this.reasoner_.getTaxonomy();
                    continue;
                }
                if (!inferenceType.equals((Object)InferenceType.CLASS_ASSERTIONS)) continue;
                this.reasoner_.getInstanceTaxonomy();
            }
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("precomputeInferences(inferenceTypes)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
        finally {
            this.reasoner_.setProgressMonitor(this.secondaryProgressMonitor_);
        }
    }

    private class OntologyChangeProgressListener
    implements OWLOntologyChangeProgressListener {
        private static final long serialVersionUID = -609834181047406971L;

        private OntologyChangeProgressListener() {
        }

        @Override
        public void begin(int size) {
            if (ElkReasoner.this.isBufferingMode_ && ElkReasoner.this.loadBeforeChanges_) {
                try {
                    LOGGER_.trace("force initial loading");
                    ElkReasoner.this.reasoner_.forceLoading();
                    ElkReasoner.this.loadBeforeChanges_ = false;
                }
                catch (ElkException e) {
                    throw ElkReasoner.this.elkConverter_.convert(e);
                }
            }
        }

        @Override
        public void appliedChange(OWLOntologyChange change) {
        }

        @Override
        public void end() {
        }
    }

    protected class OntologyChangeListener
    implements OWLOntologyChangeListener {
        protected OntologyChangeListener() {
        }

        @Override
        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            Set<OWLOntology> importClosure = null;
            for (OWLOntologyChange oWLOntologyChange : changes) {
                OWLOntology changedOntology = oWLOntologyChange.getOntology();
                if (!changedOntology.equals(ElkReasoner.this.owlOntology_)) {
                    if (importClosure == null) {
                        importClosure = ElkReasoner.this.owlOntology_.getImportsClosure();
                    }
                    if (!importClosure.contains(changedOntology)) {
                        if (!LOGGER_.isTraceEnabled()) continue;
                        LOGGER_.trace("Ignoring the change not applicable to the current ontology: " + oWLOntologyChange);
                        continue;
                    }
                }
                if (!oWLOntologyChange.isAxiomChange()) {
                    if (LOGGER_.isTraceEnabled()) {
                        LOGGER_.trace("Non-axiom change: " + oWLOntologyChange + "\n The ontology will be reloaded.");
                    }
                    ElkReasoner.this.ontologyReloadRequired_ = true;
                    continue;
                }
                ElkReasoner.this.bufferedChangesLoader_.registerChange(oWLOntologyChange);
            }
            if (!ElkReasoner.this.isBufferingMode_) {
                ElkReasoner.this.flush();
            }
        }
    }
}

