/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.conclusions;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.AbstractConclusion;
import org.semanticweb.elk.reasoner.saturation.conclusions.BackwardLink;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ModifiableLinkRule;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.util.collections.Multimap;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ModifiableLinkImpl;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;

public class Contradiction
extends AbstractConclusion {
    private static final Logger LOGGER_ = Logger.getLogger(Contradiction.class);
    private static Contradiction INSTANCE_ = new Contradiction();

    public static Contradiction getInstance() {
        return INSTANCE_;
    }

    private Contradiction() {
    }

    public void deapply(BasicSaturationStateWriter engine, Context context) {
        this.propagateThroughBackwardLinks(engine, context);
        context.getBackwardLinkRuleChain().remove(ContradictionBackwardLinkRule.MATCHER_);
    }

    public void apply(BasicSaturationStateWriter engine, Context context) {
        this.propagateThroughBackwardLinks(engine, context);
        context.getBackwardLinkRuleChain().getCreate(ContradictionBackwardLinkRule.MATCHER_, ContradictionBackwardLinkRule.FACTORY_);
    }

    private void propagateThroughBackwardLinks(BasicSaturationStateWriter engine, Context context) {
        Multimap<IndexedPropertyChain, Context> backLinks = context.getBackwardLinksByObjectProperty();
        for (IndexedPropertyChain propRelation : backLinks.keySet()) {
            Collection<Context> targets = backLinks.get(propRelation);
            for (Context target : targets) {
                engine.produce(target, Contradiction.getInstance());
            }
        }
    }

    @Override
    public <R> R accept(ConclusionVisitor<R> visitor, Context context) {
        return visitor.visit(this, context);
    }

    public String toString() {
        return "Contradiction";
    }

    public static class ContradictionBackwardLinkRule
    extends ModifiableLinkImpl<ModifiableLinkRule<BackwardLink>>
    implements ModifiableLinkRule<BackwardLink> {
        private static final String NAME = "Contradiction Existential Propagation";
        private static final Matcher<ModifiableLinkRule<BackwardLink>, ContradictionBackwardLinkRule> MATCHER_ = new SimpleTypeBasedMatcher<ModifiableLinkRule<BackwardLink>, ContradictionBackwardLinkRule>(ContradictionBackwardLinkRule.class);
        private static final ReferenceFactory<ModifiableLinkRule<BackwardLink>, ContradictionBackwardLinkRule> FACTORY_ = new ReferenceFactory<ModifiableLinkRule<BackwardLink>, ContradictionBackwardLinkRule>(){

            @Override
            public ContradictionBackwardLinkRule create(ModifiableLinkRule<BackwardLink> tail) {
                return new ContradictionBackwardLinkRule(tail);
            }
        };

        ContradictionBackwardLinkRule(ModifiableLinkRule<BackwardLink> tail) {
            super(tail);
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public void apply(BasicSaturationStateWriter engine, BackwardLink link) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("Applying Contradiction Existential Propagation to " + link);
            }
            engine.produce(link.getSource(), Contradiction.getInstance());
        }

        @Override
        public void accept(RuleApplicationVisitor visitor, BasicSaturationStateWriter writer, BackwardLink backwardLink) {
            visitor.visit(this, writer, backwardLink);
        }
    }
}

