/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.saturation.properties;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedBinaryPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;

class CompositionClosure {
    private static final Logger LOGGER_ = Logger.getLogger(CompositionClosure.class);
    protected final Collection<IndexedPropertyChain> relevantCompositions;

    CompositionClosure(IndexedBinaryPropertyChain root) {
        if (SaturatedPropertyChain.isRelevant(root)) {
            this.relevantCompositions = Collections.singleton(root);
        } else {
            this.relevantCompositions = new LinkedList<IndexedPropertyChain>();
            this.relevantCompositions.addAll(root.getToldSuperProperties());
        }
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace(root + " relevant compositions: " + this.relevantCompositions);
        }
    }

    public void applyTo(Collection<IndexedPropertyChain> currentCompositions) {
        currentCompositions.addAll(this.relevantCompositions);
    }
}

