/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.stages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.semanticweb.elk.owl.interfaces.ElkAnnotationProperty;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkDataProperty;
import org.semanticweb.elk.owl.interfaces.ElkDatatype;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.visitors.ElkEntityVisitor;
import org.semanticweb.elk.reasoner.incremental.IncrementalChangesInitialization;
import org.semanticweb.elk.reasoner.incremental.IncrementalStages;
import org.semanticweb.elk.reasoner.indexing.hierarchy.DifferentialIndex;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexObjectConverter;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.ContextCreationListener;
import org.semanticweb.elk.reasoner.saturation.ContextModificationListener;
import org.semanticweb.elk.reasoner.saturation.ExtendedSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.SaturationUtils;
import org.semanticweb.elk.reasoner.saturation.conclusions.ConclusionVisitor;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ChainableRule;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.reasoner.stages.AbstractIncrementalChangesInitializationStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerStage;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.util.collections.Operations;

public class IncrementalAdditionInitializationStage
extends AbstractIncrementalChangesInitializationStage {
    public IncrementalAdditionInitializationStage(AbstractReasonerState reasoner, AbstractReasonerStage ... preStages) {
        super(reasoner, preStages);
    }

    @Override
    protected IncrementalStages stage() {
        return IncrementalStages.ADDITIONS_INIT;
    }

    @Override
    public boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        DifferentialIndex diffIndex = this.reasoner.ontologyIndex;
        ChainableRule<Context> changedInitRules = null;
        Map<IndexedClassExpression, ChainableRule<Context>> changedRulesByCE = null;
        Collection<ArrayList<Context>> inputs = Collections.emptyList();
        RuleApplicationVisitor initRuleAppVisitor = SaturationUtils.getStatsAwareCompositionRuleAppVisitor(this.stageStatistics_.getRuleStatistics());
        ContextCreationListener contextCreationListener = SaturationUtils.addStatsToContextCreationListener(ContextCreationListener.DUMMY, this.stageStatistics_.getContextStatistics());
        ContextModificationListener contextModificationListener = SaturationUtils.addStatsToContextModificationListener(ContextModificationListener.DUMMY, this.stageStatistics_.getContextStatistics());
        ConclusionVisitor<?> conclusionVisitor = SaturationUtils.addStatsToConclusionVisitor(this.stageStatistics_.getConclusionStatistics());
        final IndexObjectConverter converter = this.reasoner.objectCache_.getIndexObjectConverter();
        ExtendedSaturationStateWriter writer = this.reasoner.saturationState.getExtendedWriter(contextCreationListener, contextModificationListener, initRuleAppVisitor, conclusionVisitor, true);
        for (ElkEntity elkEntity : Operations.concat(this.reasoner.ontologyIndex.getAddedClasses(), this.reasoner.ontologyIndex.getAddedIndividuals())) {
            IndexedClassExpression ice = elkEntity.accept(new ElkEntityVisitor<IndexedClassExpression>(){

                @Override
                public IndexedClassExpression visit(ElkAnnotationProperty elkAnnotationProperty) {
                    return null;
                }

                @Override
                public IndexedClassExpression visit(ElkClass elkClass) {
                    return converter.visit(elkClass);
                }

                @Override
                public IndexedClassExpression visit(ElkDataProperty elkDataProperty) {
                    return null;
                }

                @Override
                public IndexedClassExpression visit(ElkDatatype elkDatatype) {
                    return null;
                }

                @Override
                public IndexedClassExpression visit(ElkNamedIndividual elkNamedIndividual) {
                    return converter.visit(elkNamedIndividual);
                }

                @Override
                public IndexedClassExpression visit(ElkObjectProperty elkObjectProperty) {
                    return null;
                }
            });
            if (ice.getContext() != null) continue;
            writer.getCreateContext(ice);
        }
        changedInitRules = diffIndex.getAddedContextInitRules();
        changedRulesByCE = diffIndex.getAddedContextRulesByClassExpressions();
        if (changedInitRules != null || !changedRulesByCE.isEmpty()) {
            inputs = Operations.split(this.reasoner.saturationState.getContexts(), 8 * this.workerNo);
        }
        this.initialization = new IncrementalChangesInitialization(inputs, changedInitRules, changedRulesByCE, this.reasoner.saturationState, this.reasoner.getProcessExecutor(), this.stageStatistics_, this.workerNo, this.reasoner.getProgressMonitor());
        return true;
    }

    @Override
    public boolean postExecute() {
        if (!super.postExecute()) {
            return false;
        }
        this.reasoner.ontologyIndex.commitAddedRules();
        this.reasoner.ontologyIndex.initClassSignatureChanges();
        this.reasoner.ontologyIndex.initIndividualSignatureChanges();
        return true;
    }
}

