/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.hashing;

import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.reasoner.taxonomy.hashing.NodeHasher;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.util.hashing.HashGenerator;
import org.semanticweb.elk.util.hashing.Hasher;

public class TaxonomyNodeHasher
implements Hasher<TaxonomyNode<? extends ElkEntity>> {
    public static TaxonomyNodeHasher INSTANCE = new TaxonomyNodeHasher();

    private TaxonomyNodeHasher() {
    }

    @Override
    public int hash(TaxonomyNode<? extends ElkEntity> node) {
        int memberHash = NodeHasher.INSTANCE.hash((Node<? extends ElkEntity>)node);
        int subClassHash = "subClassOf".hashCode();
        for (Node node2 : node.getDirectSubNodes()) {
            subClassHash = HashGenerator.combineMultisetHash(false, subClassHash, NodeHasher.INSTANCE.hash(node2));
        }
        int superClassHash = "superClassOf".hashCode();
        for (Node node3 : node.getDirectSuperNodes()) {
            superClassHash = HashGenerator.combineMultisetHash(false, superClassHash, NodeHasher.INSTANCE.hash(node3));
        }
        return HashGenerator.combineListHash(memberHash, subClassHash, superClassHash);
    }
}

