/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.taxonomy.model;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;

public class SimpleNode<T extends ElkObject>
implements Node<T> {
    final SortedSet<T> members;

    public SimpleNode(Collection<T> members, Comparator<T> cmp) {
        this.members = new TreeSet<T>(cmp);
        this.members.addAll(members);
    }

    @Override
    public Set<T> getMembers() {
        return this.members;
    }

    @Override
    public T getCanonicalMember() {
        return (T)(this.members.isEmpty() ? null : (ElkObject)this.members.iterator().next());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ElkObject member : this.members) {
            builder.append(OwlFunctionalStylePrinter.toString(member) + ",");
        }
        return builder.toString();
    }
}

