/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.concurrent.computation;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.semanticweb.elk.util.concurrent.computation.ComputationRuntimeException;
import org.semanticweb.elk.util.concurrent.computation.ComputationThreadGroup;

public class ComputationExecutor
extends ThreadPoolExecutor {
    private final ComputationThreadGroup threadGroup;
    CountDownLatch done;
    volatile boolean canStart = true;
    ComputationRuntimeException exception;

    public ComputationExecutor(int threadCount, final ComputationThreadGroup threadGroup) {
        super(threadCount, threadCount, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(threadCount), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread result = new Thread(threadGroup, r, threadGroup.getName() + "-thread-" + threadGroup.getNextThreadId());
                result.setDaemon(true);
                return result;
            }
        });
        this.threadGroup = threadGroup;
        this.exception = null;
    }

    public ComputationExecutor(int threadCount, String name) {
        this(threadCount, new ComputationThreadGroup(name));
    }

    public synchronized boolean start(Runnable job, int noCopies) {
        if (!this.canStart) {
            return false;
        }
        this.done = new CountDownLatch(noCopies);
        Worker worker = new Worker(job, this.done, Thread.currentThread());
        for (int i = 0; i < noCopies; ++i) {
            this.execute(worker);
        }
        this.canStart = false;
        this.checkException();
        return true;
    }

    public void interrupt() {
        this.checkException();
        this.threadGroup.interrupt();
    }

    public synchronized void waitDone() throws InterruptedException {
        try {
            this.done.await();
        }
        catch (InterruptedException e) {
            this.checkException();
            throw e;
        }
        this.canStart = true;
    }

    private void checkException() throws ComputationRuntimeException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private class Worker
    implements Runnable {
        protected final Runnable job;
        protected final CountDownLatch done;
        protected final Thread executorThread;

        Worker(Runnable job, CountDownLatch done, Thread executorThread) {
            this.job = job;
            this.done = done;
            this.executorThread = executorThread;
        }

        @Override
        public void run() {
            try {
                this.job.run();
                return;
            }
            catch (Throwable e) {
                this.handleUnexpectedException(e);
            }
            finally {
                this.done.countDown();
                Thread.interrupted();
            }
        }

        private void handleUnexpectedException(Throwable e) {
            ComputationExecutor.this.exception = new ComputationRuntimeException("Uncaught exception in a worker thread:", e);
            this.executorThread.interrupt();
        }
    }
}

