/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;
import org.semanticweb.owlapi.util.RemappingIndividualProvider;

public class CoerceConstantsIntoDataPropertyRange
extends AbstractCompositeOntologyChange {
    private static final long serialVersionUID = 40000L;

    public CoerceConstantsIntoDataPropertyRange(@Nonnull OWLDataFactory dataFactory, @Nonnull Set<OWLOntology> ontologies) {
        super(dataFactory);
        HashMap<OWLDataPropertyExpression, OWLDatatype> map = new HashMap<OWLDataPropertyExpression, OWLDatatype>();
        for (OWLOntology ont : OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null")) {
            for (OWLDataPropertyRangeAxiom ax : ont.getAxioms(AxiomType.DATA_PROPERTY_RANGE)) {
                if (!((OWLDataRange)ax.getRange()).isDatatype()) continue;
                map.put((OWLDataPropertyExpression)ax.getProperty(), (OWLDatatype)ax.getRange());
            }
        }
        OWLConstantReplacer replacer = new OWLConstantReplacer(this.getDataFactory(), map);
        for (OWLOntology ont : ontologies) {
            assert (ont != null);
            for (OWLAxiom oWLAxiom : ont.getLogicalAxioms()) {
                assert (oWLAxiom != null);
                OWLAxiom dupAx = (OWLAxiom)replacer.duplicateObject(oWLAxiom);
                if (oWLAxiom.equals(dupAx)) continue;
                this.addChange(new RemoveAxiom(ont, oWLAxiom));
                this.addChange(new AddAxiom(ont, dupAx));
            }
        }
    }

    private class OWLConstantReplacer
    extends OWLObjectDuplicator {
        private final Map<OWLDataPropertyExpression, OWLDatatype> map;

        OWLConstantReplacer(@Nonnull OWLDataFactory dataFactory, Map<OWLDataPropertyExpression, OWLDatatype> m3) {
            super(new HashMap<OWLEntity, IRI>(), dataFactory, Collections.emptyMap(), new RemappingIndividualProvider(dataFactory, false));
            this.map = m3;
        }

        @Nonnull
        private OWLDataOneOf process(@Nonnull OWLDataPropertyExpression prop, @Nonnull OWLDataOneOf oneOf) {
            HashSet<OWLLiteral> vals = new HashSet<OWLLiteral>();
            for (OWLLiteral con : oneOf.getValues()) {
                assert (con != null);
                vals.add(this.process(prop, con));
            }
            return CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataOneOf(vals);
        }

        @Nonnull
        private OWLLiteral process(@Nonnull OWLDataPropertyExpression prop, @Nonnull OWLLiteral con) {
            OWLDatatype dt = this.map.get(prop);
            if (dt != null) {
                return CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLLiteral(con.getLiteral(), dt);
            }
            return con;
        }

        @Override
        public void visit(@Nonnull OWLDataHasValue ce) {
            super.visit(ce);
            this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataHasValue((OWLDataPropertyExpression)ce.getProperty(), this.process((OWLDataPropertyExpression)ce.getProperty(), (OWLLiteral)ce.getFiller())));
        }

        @Override
        public void visit(OWLDataSomeValuesFrom ce) {
            super.visit(ce);
            if (ce instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataSomeValuesFrom((OWLDataPropertyExpression)ce.getProperty(), this.process((OWLDataPropertyExpression)ce.getProperty(), (OWLDataOneOf)ce.getFiller())));
            }
        }

        @Override
        public void visit(OWLDataMinCardinality ce) {
            super.visit(ce);
            if (ce instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataMinCardinality(ce.getCardinality(), (OWLDataPropertyExpression)ce.getProperty(), this.process((OWLDataPropertyExpression)ce.getProperty(), (OWLDataOneOf)ce.getFiller())));
            }
        }

        @Override
        public void visit(OWLDataMaxCardinality ce) {
            super.visit(ce);
            if (ce instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataMaxCardinality(ce.getCardinality(), (OWLDataPropertyExpression)ce.getProperty(), this.process((OWLDataPropertyExpression)ce.getProperty(), (OWLDataOneOf)ce.getFiller())));
            }
        }

        @Override
        public void visit(OWLDataExactCardinality ce) {
            super.visit(ce);
            if (ce instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataExactCardinality(ce.getCardinality(), (OWLDataPropertyExpression)ce.getProperty(), this.process((OWLDataPropertyExpression)ce.getProperty(), (OWLDataOneOf)ce.getFiller())));
            }
        }

        @Override
        public void visit(OWLDataAllValuesFrom ce) {
            super.visit(ce);
            if (ce instanceof OWLDataOneOf) {
                this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataAllValuesFrom((OWLDataPropertyExpression)ce.getProperty(), this.process((OWLDataPropertyExpression)ce.getProperty(), (OWLDataOneOf)ce.getFiller())));
            }
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            super.visit(axiom);
            this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)axiom.getProperty(), axiom.getSubject(), this.process((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject())));
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            super.visit(axiom);
            this.setLastObject(CoerceConstantsIntoDataPropertyRange.this.getDataFactory().getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)axiom.getProperty(), axiom.getSubject(), this.process((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject())));
        }
    }
}

