/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.dlsyntax.renderer;

import java.io.PrintWriter;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.dlsyntax.renderer.DLSyntax;
import org.semanticweb.owlapi.dlsyntax.renderer.DLSyntaxObjectRenderer;
import org.semanticweb.owlapi.dlsyntax.renderer.DLSyntaxStorerBase;
import org.semanticweb.owlapi.formats.DLSyntaxHTMLDocumentFormat;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class DLSyntaxHTMLStorer
extends DLSyntaxStorerBase {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    protected final SimpleShortFormProvider sfp = new SimpleShortFormProvider();

    @Override
    public boolean canStoreOntology(OWLDocumentFormat ontologyFormat) {
        return ontologyFormat instanceof DLSyntaxHTMLDocumentFormat;
    }

    @Override
    @Nonnull
    protected String getRendering(final @Nullable OWLEntity subject, OWLAxiom axiom) {
        OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null");
        DLSyntaxObjectRenderer ren = new DLSyntaxObjectRenderer(){

            @Override
            protected String renderEntity(@Nonnull OWLEntity entity) {
                String shortForm = DLSyntaxHTMLStorer.this.sfp.getShortForm(OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null"));
                if (entity.equals(subject)) {
                    return shortForm;
                }
                return "<a href=\"#" + shortForm + "\">" + shortForm + "</a>";
            }

            @Override
            protected void write(DLSyntax keyword) {
                this.write(OWLAPIPreconditions.checkNotNull(keyword, "keyword cannot be null").toHTMLString());
            }
        };
        ren.setFocusedObject(subject);
        ren.setShortFormProvider(this.sfp);
        return ren.render(axiom);
    }

    @Override
    protected void beginWritingOntology(@Nonnull OWLOntology ontology, @Nonnull PrintWriter writer) {
        this.checkOntologyNotNull(ontology);
        this.checkWriterNotNull(writer);
        writer.println("<html>");
        writer.println("<body>");
        writer.println("<h1>Ontology: ");
        writer.print(ontology.getOntologyID());
        writer.println("</h1>");
    }

    protected void checkOntologyNotNull(OWLOntology ontology) {
        OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
    }

    protected PrintWriter checkWriterNotNull(PrintWriter writer) {
        return OWLAPIPreconditions.checkNotNull(writer, "writer cannot be null");
    }

    protected void writeEntity(@Nonnull OWLEntity entity, @Nonnull PrintWriter writer) {
    }

    @Override
    protected void endWritingOntology(OWLOntology ontology, PrintWriter writer) {
        this.checkOntologyNotNull(ontology);
        this.checkWriterNotNull(writer);
        writer.println("</body>");
        writer.println("</html>");
    }

    @Override
    protected void beginWritingAxiom(OWLAxiom axiom, PrintWriter writer) {
        OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null");
        this.checkWriterNotNull(writer).println("<div class=\"axiombox\"> ");
    }

    @Override
    protected void endWritingAxiom(OWLAxiom axiom, PrintWriter writer) {
        OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null");
        this.checkWriterNotNull(writer).println(" </div>");
    }

    @Override
    protected void beginWritingAxioms(@Nonnull OWLEntity subject, Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
        OWLAPIPreconditions.checkNotNull(subject, "subject cannot be null");
        this.checkWriterNotNull(writer);
        writer.print("<h2><a name=\"");
        writer.print(this.sfp.getShortForm(subject));
        writer.print("\">");
        writer.print(subject.getIRI());
        writer.println("</a></h2>");
        writer.println("<div class=\"entitybox\">");
    }

    @Override
    protected void endWritingAxioms(OWLEntity subject, Set<? extends OWLAxiom> axioms, @Nonnull PrintWriter writer) {
        writer.println("</div>");
    }

    @Override
    protected void beginWritingGeneralAxioms(Set<? extends OWLAxiom> axioms, PrintWriter writer) {
        this.checkWriterNotNull(writer).println("<div>");
    }

    @Override
    protected void endWritingGeneralAxioms(Set<? extends OWLAxiom> axioms, PrintWriter writer) {
        OWLAPIPreconditions.checkNotNull(axioms, "axioms cannot be null");
        this.checkWriterNotNull(writer).println("</div>");
    }

    @Override
    protected void beginWritingUsage(int size, PrintWriter writer) {
        writer.println("<div class=\"usage\" style=\"margin-left: 60px; size: tiny\">");
        writer.println("<h3>Usages (" + size + ")</h3>");
    }

    @Override
    protected void endWritingUsage(OWLEntity subject, Set<? extends OWLAxiom> axioms, PrintWriter writer) {
        OWLAPIPreconditions.checkNotNull(subject, "subject cannot be null");
        OWLAPIPreconditions.checkNotNull(axioms, "axioms cannot be null");
        this.checkWriterNotNull(writer).println("</div>");
    }
}

